package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import org.openapitools.client.model.EmailTemplateEmbedded;
    import org.openapitools.client.model.EmailTemplateLinks;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* EmailTemplate
*/
    @JsonPropertyOrder({
        EmailTemplate.JSON_PROPERTY_NAME,
        EmailTemplate.JSON_PROPERTY_EMBEDDED,
        EmailTemplate.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class EmailTemplate {


        public static final String JSON_PROPERTY_NAME = "name";
            private String name;

        public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
            private EmailTemplateEmbedded embedded;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private EmailTemplateLinks links;

public EmailTemplate() { 
}

    /*
    @JsonCreator
    public EmailTemplate(
        @JsonProperty(JSON_PROPERTY_NAME) String name
    ) {
    this();
        this.name = name;
    }*/


    /**
        * The name of this email template.
    * @return name
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "The name of this email template.")
      @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }




        public EmailTemplate embedded(EmailTemplateEmbedded embedded) {
        
        this.embedded = embedded;
        return this;
        }

    /**
        * Get embedded
    * @return embedded
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_EMBEDDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EmailTemplateEmbedded getEmbedded() {
        return embedded;
    }


          @JsonProperty(JSON_PROPERTY_EMBEDDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmbedded(EmailTemplateEmbedded embedded) {
            this.embedded = embedded;
        }


        public EmailTemplate links(EmailTemplateLinks links) {
        
        this.links = links;
        return this;
        }

    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EmailTemplateLinks getLinks() {
        return links;
    }


          @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(EmailTemplateLinks links) {
            this.links = links;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        EmailTemplate emailTemplate = (EmailTemplate) o;
        return Objects.equals(this.name, emailTemplate.name) &&
        Objects.equals(this.embedded, emailTemplate.embedded) &&
        Objects.equals(this.links, emailTemplate.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(name, embedded, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EmailTemplate {\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
