package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets EmailDomainStatus
 */
public enum EmailDomainStatus {
  
  DELETED("DELETED"),
  
  ERROR("ERROR"),
  
  NOT_STARTED("NOT_STARTED"),
  
  POLLING("POLLING"),
  
  VERIFIED("VERIFIED");

  private String value;

  EmailDomainStatus(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static EmailDomainStatus fromValue(String value) {
    for (EmailDomainStatus b : EmailDomainStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

