package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets DeviceStatus
 */
public enum DeviceStatus {
  
  ACTIVE("ACTIVE"),
  
  CREATED("CREATED"),
  
  DEACTIVATED("DEACTIVATED"),
  
  SUSPENDED("SUSPENDED");

  private String value;

  DeviceStatus(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static DeviceStatus fromValue(String value) {
    for (DeviceStatus b : DeviceStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

