package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import io.swagger.annotations.ApiModel;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * OS platform of the device
 */
public enum DevicePlatform {
  
  ANDROID("ANDROID"),
  
  IOS("IOS"),
  
  MACOS("MACOS"),
  
  WINDOWS("WINDOWS");

  private String value;

  DevicePlatform(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static DevicePlatform fromValue(String value) {
    for (DevicePlatform b : DevicePlatform.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

