package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import io.swagger.annotations.ApiModel;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * An AWS region
 */
public enum AwsRegion {
  
  CA_CENTRAL_1("ca-central-1"),
  
  EU_CENTRAL_1("eu-central-1"),
  
  EU_NORTH_1("eu-north-1"),
  
  EU_SOUTH_1("eu-south-1"),
  
  EU_WEST_1("eu-west-1"),
  
  EU_WEST_2("eu-west-2"),
  
  EU_WEST_3("eu-west-3"),
  
  US_EAST_1("us-east-1"),
  
  US_EAST_2("us-east-2"),
  
  US_WEST_1("us-west-1"),
  
  US_WEST_2("us-west-2");

  private String value;

  AwsRegion(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static AwsRegion fromValue(String value) {
    for (AwsRegion b : AwsRegion.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

