package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets AuthenticatorType
 */
public enum AuthenticatorType {
  
  APP("app"),
  
  EMAIL("email"),
  
  FEDERATED("federated"),
  
  PASSWORD("password"),
  
  PHONE("phone"),
  
  SECURITY_KEY("security_key"),
  
  SECURITY_QUESTION("security_question");

  private String value;

  AuthenticatorType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static AuthenticatorType fromValue(String value) {
    for (AuthenticatorType b : AuthenticatorType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

