package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets AuthenticationProviderType
 */
public enum AuthenticationProviderType {
  
  ACTIVE_DIRECTORY("ACTIVE_DIRECTORY"),
  
  FEDERATION("FEDERATION"),
  
  IMPORT("IMPORT"),
  
  LDAP("LDAP"),
  
  OKTA("OKTA"),
  
  SOCIAL("SOCIAL");

  private String value;

  AuthenticationProviderType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static AuthenticationProviderType fromValue(String value) {
    for (AuthenticationProviderType b : AuthenticationProviderType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

