package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets ApplicationCredentialsScheme
 */
public enum ApplicationCredentialsScheme {
  
  ADMIN_SETS_CREDENTIALS("ADMIN_SETS_CREDENTIALS"),
  
  EDIT_PASSWORD_ONLY("EDIT_PASSWORD_ONLY"),
  
  EDIT_USERNAME_AND_PASSWORD("EDIT_USERNAME_AND_PASSWORD"),
  
  EXTERNAL_PASSWORD_SYNC("EXTERNAL_PASSWORD_SYNC"),
  
  SHARED_USERNAME_AND_PASSWORD("SHARED_USERNAME_AND_PASSWORD");

  private String value;

  ApplicationCredentialsScheme(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static ApplicationCredentialsScheme fromValue(String value) {
    for (ApplicationCredentialsScheme b : ApplicationCredentialsScheme.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

