package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonSubTypes;
    import com.fasterxml.jackson.annotation.JsonTypeInfo;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import java.util.ArrayList;
    import java.util.HashMap;
    import java.util.List;
    import java.util.Map;
    import org.openapitools.client.model.ApplicationAccessibility;
    import org.openapitools.client.model.ApplicationLicensing;
    import org.openapitools.client.model.ApplicationLifecycleStatus;
    import org.openapitools.client.model.ApplicationLinks;
    import org.openapitools.client.model.ApplicationSignOnMode;
    import org.openapitools.client.model.ApplicationVisibility;
    import org.openapitools.client.model.AutoLoginApplication;
    import org.openapitools.client.model.BasicAuthApplication;
    import org.openapitools.client.model.BookmarkApplication;
    import org.openapitools.client.model.BrowserPluginApplication;
    import org.openapitools.client.model.OpenIdConnectApplication;
    import org.openapitools.client.model.SamlApplication;
    import org.openapitools.client.model.SecurePasswordStoreApplication;
    import org.openapitools.client.model.WsFederationApplication;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* Application
*/
    @JsonPropertyOrder({
        Application.JSON_PROPERTY_ACCESSIBILITY,
        Application.JSON_PROPERTY_CREATED,
        Application.JSON_PROPERTY_FEATURES,
        Application.JSON_PROPERTY_ID,
        Application.JSON_PROPERTY_LABEL,
        Application.JSON_PROPERTY_LAST_UPDATED,
        Application.JSON_PROPERTY_LICENSING,
        Application.JSON_PROPERTY_PROFILE,
        Application.JSON_PROPERTY_SIGN_ON_MODE,
        Application.JSON_PROPERTY_STATUS,
        Application.JSON_PROPERTY_VISIBILITY,
        Application.JSON_PROPERTY_EMBEDDED,
        Application.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class Application {


        public static final String JSON_PROPERTY_ACCESSIBILITY = "accessibility";
            private ApplicationAccessibility accessibility;

        public static final String JSON_PROPERTY_CREATED = "created";
            private OffsetDateTime created;

        public static final String JSON_PROPERTY_FEATURES = "features";
            private List<String> features = null;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_LABEL = "label";
            private String label;

        public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
            private OffsetDateTime lastUpdated;

        public static final String JSON_PROPERTY_LICENSING = "licensing";
            private ApplicationLicensing licensing;

        public static final String JSON_PROPERTY_PROFILE = "profile";
            private Map<String, Object> profile = null;

        public static final String JSON_PROPERTY_SIGN_ON_MODE = "signOnMode";
            protected ApplicationSignOnMode signOnMode;

        public static final String JSON_PROPERTY_STATUS = "status";
            private ApplicationLifecycleStatus status;

        public static final String JSON_PROPERTY_VISIBILITY = "visibility";
            private ApplicationVisibility visibility;

        public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
            private Map<String, Object> embedded = null;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private ApplicationLinks links;

public Application() { 
}

    /*
    @JsonCreator
    public Application(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated, 
        @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded
    ) {
    this();
        this.created = created;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.embedded = embedded;
    }*/


        public Application accessibility(ApplicationAccessibility accessibility) {
        
        this.accessibility = accessibility;
        return this;
        }

    /**
        * Get accessibility
    * @return accessibility
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ACCESSIBILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationAccessibility getAccessibility() {
        return accessibility;
    }


          @JsonProperty(JSON_PROPERTY_ACCESSIBILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccessibility(ApplicationAccessibility accessibility) {
            this.accessibility = accessibility;
        }


    /**
        * Get created
    * @return created
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }




        public Application features(List<String> features) {
        
        this.features = features;
        return this;
        }

            public Application addFeaturesItem(String featuresItem) {
                    if (this.features == null) {
                    this.features = new ArrayList<>();
                    }
                this.features.add(featuresItem);
                return this;
            }

    /**
        * Get features
    * @return features
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getFeatures() {
        return features;
    }


          @JsonProperty(JSON_PROPERTY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeatures(List<String> features) {
            this.features = features;
        }


    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




        public Application label(String label) {
        
        this.label = label;
        return this;
        }

    /**
        * Get label
    * @return label
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LABEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLabel() {
        return label;
    }


          @JsonProperty(JSON_PROPERTY_LABEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLabel(String label) {
            this.label = label;
        }


    /**
        * Get lastUpdated
    * @return lastUpdated
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }




        public Application licensing(ApplicationLicensing licensing) {
        
        this.licensing = licensing;
        return this;
        }

    /**
        * Get licensing
    * @return licensing
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LICENSING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationLicensing getLicensing() {
        return licensing;
    }


          @JsonProperty(JSON_PROPERTY_LICENSING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLicensing(ApplicationLicensing licensing) {
            this.licensing = licensing;
        }


        public Application profile(Map<String, Object> profile) {
        
        this.profile = profile;
        return this;
        }

            public Application putProfileItem(String key, Object profileItem) {
                    if (this.profile == null) {
                    this.profile = new HashMap<>();
                    }
                this.profile.put(key, profileItem);
                return this;
            }

    /**
        * Get profile
    * @return profile
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getProfile() {
        return profile;
    }


          @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfile(Map<String, Object> profile) {
            this.profile = profile;
        }


        public Application signOnMode(ApplicationSignOnMode signOnMode) {
        
        this.signOnMode = signOnMode;
        return this;
        }

    /**
        * Get signOnMode
    * @return signOnMode
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SIGN_ON_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationSignOnMode getSignOnMode() {
        return signOnMode;
    }


          @JsonProperty(JSON_PROPERTY_SIGN_ON_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSignOnMode(ApplicationSignOnMode signOnMode) {
            this.signOnMode = signOnMode;
        }


        public Application status(ApplicationLifecycleStatus status) {
        
        this.status = status;
        return this;
        }

    /**
        * Get status
    * @return status
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationLifecycleStatus getStatus() {
        return status;
    }


          @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(ApplicationLifecycleStatus status) {
            this.status = status;
        }


        public Application visibility(ApplicationVisibility visibility) {
        
        this.visibility = visibility;
        return this;
        }

    /**
        * Get visibility
    * @return visibility
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_VISIBILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationVisibility getVisibility() {
        return visibility;
    }


          @JsonProperty(JSON_PROPERTY_VISIBILITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisibility(ApplicationVisibility visibility) {
            this.visibility = visibility;
        }


    /**
        * Get embedded
    * @return embedded
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_EMBEDDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getEmbedded() {
        return embedded;
    }




        public Application links(ApplicationLinks links) {
        
        this.links = links;
        return this;
        }

    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationLinks getLinks() {
        return links;
    }


          @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(ApplicationLinks links) {
            this.links = links;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        Application application = (Application) o;
        return Objects.equals(this.accessibility, application.accessibility) &&
        Objects.equals(this.created, application.created) &&
        Objects.equals(this.features, application.features) &&
        Objects.equals(this.id, application.id) &&
        Objects.equals(this.label, application.label) &&
        Objects.equals(this.lastUpdated, application.lastUpdated) &&
        Objects.equals(this.licensing, application.licensing) &&
        Objects.equals(this.profile, application.profile) &&
        Objects.equals(this.signOnMode, application.signOnMode) &&
        Objects.equals(this.status, application.status) &&
        Objects.equals(this.visibility, application.visibility) &&
        Objects.equals(this.embedded, application.embedded) &&
        Objects.equals(this.links, application.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(accessibility, created, features, id, label, lastUpdated, licensing, profile, signOnMode, status, visibility, embedded, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Application {\n");
        sb.append("    accessibility: ").append(toIndentedString(accessibility)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    features: ").append(toIndentedString(features)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    licensing: ").append(toIndentedString(licensing)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    signOnMode: ").append(toIndentedString(signOnMode)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    visibility: ").append(toIndentedString(visibility)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
