package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import java.util.HashMap;
    import java.util.Map;
    import org.openapitools.client.model.AppUserCredentials;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* AppUser
*/
    @JsonPropertyOrder({
        AppUser.JSON_PROPERTY_CREATED,
        AppUser.JSON_PROPERTY_CREDENTIALS,
        AppUser.JSON_PROPERTY_EXTERNAL_ID,
        AppUser.JSON_PROPERTY_ID,
        AppUser.JSON_PROPERTY_LAST_SYNC,
        AppUser.JSON_PROPERTY_LAST_UPDATED,
        AppUser.JSON_PROPERTY_PASSWORD_CHANGED,
        AppUser.JSON_PROPERTY_PROFILE,
        AppUser.JSON_PROPERTY_SCOPE,
        AppUser.JSON_PROPERTY_STATUS,
        AppUser.JSON_PROPERTY_STATUS_CHANGED,
        AppUser.JSON_PROPERTY_SYNC_STATE,
        AppUser.JSON_PROPERTY_EMBEDDED,
        AppUser.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class AppUser {


        public static final String JSON_PROPERTY_CREATED = "created";
            private OffsetDateTime created;

        public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
            private AppUserCredentials credentials;

        public static final String JSON_PROPERTY_EXTERNAL_ID = "externalId";
            private String externalId;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_LAST_SYNC = "lastSync";
            private OffsetDateTime lastSync;

        public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
            private OffsetDateTime lastUpdated;

        public static final String JSON_PROPERTY_PASSWORD_CHANGED = "passwordChanged";
            private OffsetDateTime passwordChanged;

        public static final String JSON_PROPERTY_PROFILE = "profile";
            private Map<String, Object> profile = null;

        public static final String JSON_PROPERTY_SCOPE = "scope";
            private String scope;

        public static final String JSON_PROPERTY_STATUS = "status";
            private String status;

        public static final String JSON_PROPERTY_STATUS_CHANGED = "statusChanged";
            private OffsetDateTime statusChanged;

        public static final String JSON_PROPERTY_SYNC_STATE = "syncState";
            private String syncState;

        public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
            private Map<String, Object> embedded = null;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private Map<String, Object> links = null;

public AppUser() { 
}

    /*
    @JsonCreator
    public AppUser(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_EXTERNAL_ID) String externalId, 
        @JsonProperty(JSON_PROPERTY_LAST_SYNC) OffsetDateTime lastSync, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated, 
        @JsonProperty(JSON_PROPERTY_PASSWORD_CHANGED) OffsetDateTime passwordChanged, 
        @JsonProperty(JSON_PROPERTY_STATUS) String status, 
        @JsonProperty(JSON_PROPERTY_STATUS_CHANGED) OffsetDateTime statusChanged, 
        @JsonProperty(JSON_PROPERTY_SYNC_STATE) String syncState, 
        @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded, 
        @JsonProperty(JSON_PROPERTY_LINKS) Map<String, Object> links
    ) {
    this();
        this.created = created;
        this.externalId = externalId;
        this.lastSync = lastSync;
        this.lastUpdated = lastUpdated;
        this.passwordChanged = passwordChanged;
        this.status = status;
        this.statusChanged = statusChanged;
        this.syncState = syncState;
        this.embedded = embedded;
        this.links = links;
    }*/


    /**
        * Get created
    * @return created
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }




        public AppUser credentials(AppUserCredentials credentials) {
        
        this.credentials = credentials;
        return this;
        }

    /**
        * Get credentials
    * @return credentials
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppUserCredentials getCredentials() {
        return credentials;
    }


          @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCredentials(AppUserCredentials credentials) {
            this.credentials = credentials;
        }


    /**
        * Get externalId
    * @return externalId
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_EXTERNAL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getExternalId() {
        return externalId;
    }




        public AppUser id(String id) {
        
        this.id = id;
        return this;
        }

    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }


          @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
            this.id = id;
        }


    /**
        * Get lastSync
    * @return lastSync
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LAST_SYNC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastSync() {
        return lastSync;
    }




    /**
        * Get lastUpdated
    * @return lastUpdated
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }




    /**
        * Get passwordChanged
    * @return passwordChanged
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_PASSWORD_CHANGED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getPasswordChanged() {
        return passwordChanged;
    }




        public AppUser profile(Map<String, Object> profile) {
        
        this.profile = profile;
        return this;
        }

            public AppUser putProfileItem(String key, Object profileItem) {
                    if (this.profile == null) {
                    this.profile = new HashMap<>();
                    }
                this.profile.put(key, profileItem);
                return this;
            }

    /**
        * Get profile
    * @return profile
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getProfile() {
        return profile;
    }


          @JsonProperty(JSON_PROPERTY_PROFILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfile(Map<String, Object> profile) {
            this.profile = profile;
        }


        public AppUser scope(String scope) {
        
        this.scope = scope;
        return this;
        }

    /**
        * Get scope
    * @return scope
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SCOPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getScope() {
        return scope;
    }


          @JsonProperty(JSON_PROPERTY_SCOPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScope(String scope) {
            this.scope = scope;
        }


    /**
        * Get status
    * @return status
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getStatus() {
        return status;
    }




    /**
        * Get statusChanged
    * @return statusChanged
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_STATUS_CHANGED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getStatusChanged() {
        return statusChanged;
    }




    /**
        * Get syncState
    * @return syncState
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SYNC_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSyncState() {
        return syncState;
    }




    /**
        * Get embedded
    * @return embedded
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_EMBEDDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getEmbedded() {
        return embedded;
    }




    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getLinks() {
        return links;
    }




@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        AppUser appUser = (AppUser) o;
        return Objects.equals(this.created, appUser.created) &&
        Objects.equals(this.credentials, appUser.credentials) &&
        Objects.equals(this.externalId, appUser.externalId) &&
        Objects.equals(this.id, appUser.id) &&
        Objects.equals(this.lastSync, appUser.lastSync) &&
        Objects.equals(this.lastUpdated, appUser.lastUpdated) &&
        Objects.equals(this.passwordChanged, appUser.passwordChanged) &&
        Objects.equals(this.profile, appUser.profile) &&
        Objects.equals(this.scope, appUser.scope) &&
        Objects.equals(this.status, appUser.status) &&
        Objects.equals(this.statusChanged, appUser.statusChanged) &&
        Objects.equals(this.syncState, appUser.syncState) &&
        Objects.equals(this.embedded, appUser.embedded) &&
        Objects.equals(this.links, appUser.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(created, credentials, externalId, id, lastSync, lastUpdated, passwordChanged, profile, scope, status, statusChanged, syncState, embedded, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppUser {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastSync: ").append(toIndentedString(lastSync)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    passwordChanged: ").append(toIndentedString(passwordChanged)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    statusChanged: ").append(toIndentedString(statusChanged)).append("\n");
        sb.append("    syncState: ").append(toIndentedString(syncState)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
