package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import org.openapitools.client.model.AgentType;
    import org.openapitools.client.model.AgentUpdateInstanceStatus;
    import org.openapitools.client.model.HrefObject;
    import org.openapitools.client.model.OperationalStatus;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* Agent details
*/
    @ApiModel(description = "Agent details")
    @JsonPropertyOrder({
        Agent.JSON_PROPERTY_ID,
        Agent.JSON_PROPERTY_IS_HIDDEN,
        Agent.JSON_PROPERTY_IS_LATEST_G_AED_VERSION,
        Agent.JSON_PROPERTY_LAST_CONNECTION,
        Agent.JSON_PROPERTY_NAME,
        Agent.JSON_PROPERTY_OPERATIONAL_STATUS,
        Agent.JSON_PROPERTY_POOL_ID,
        Agent.JSON_PROPERTY_TYPE,
        Agent.JSON_PROPERTY_UPDATE_MESSAGE,
        Agent.JSON_PROPERTY_UPDATE_STATUS,
        Agent.JSON_PROPERTY_VERSION,
        Agent.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class Agent {


        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_IS_HIDDEN = "isHidden";
            private Boolean isHidden;

        public static final String JSON_PROPERTY_IS_LATEST_G_AED_VERSION = "isLatestGAedVersion";
            private Boolean isLatestGAedVersion;

        public static final String JSON_PROPERTY_LAST_CONNECTION = "lastConnection";
            private OffsetDateTime lastConnection;

        public static final String JSON_PROPERTY_NAME = "name";
            private String name;

        public static final String JSON_PROPERTY_OPERATIONAL_STATUS = "operationalStatus";
            private OperationalStatus operationalStatus;

        public static final String JSON_PROPERTY_POOL_ID = "poolId";
            private String poolId;

        public static final String JSON_PROPERTY_TYPE = "type";
            private AgentType type;

        public static final String JSON_PROPERTY_UPDATE_MESSAGE = "updateMessage";
            private String updateMessage;

        public static final String JSON_PROPERTY_UPDATE_STATUS = "updateStatus";
            private AgentUpdateInstanceStatus updateStatus;

        public static final String JSON_PROPERTY_VERSION = "version";
            private String version;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private HrefObject links;

public Agent() { 
}

    /*
    @JsonCreator
    public Agent(
        @JsonProperty(JSON_PROPERTY_ID) String id
    ) {
    this();
        this.id = id;
    }*/


    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




        public Agent isHidden(Boolean isHidden) {
        
        this.isHidden = isHidden;
        return this;
        }

    /**
        * Get isHidden
    * @return isHidden
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_IS_HIDDEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getIsHidden() {
        return isHidden;
    }


          @JsonProperty(JSON_PROPERTY_IS_HIDDEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsHidden(Boolean isHidden) {
            this.isHidden = isHidden;
        }


        public Agent isLatestGAedVersion(Boolean isLatestGAedVersion) {
        
        this.isLatestGAedVersion = isLatestGAedVersion;
        return this;
        }

    /**
        * Get isLatestGAedVersion
    * @return isLatestGAedVersion
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_IS_LATEST_G_AED_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getIsLatestGAedVersion() {
        return isLatestGAedVersion;
    }


          @JsonProperty(JSON_PROPERTY_IS_LATEST_G_AED_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsLatestGAedVersion(Boolean isLatestGAedVersion) {
            this.isLatestGAedVersion = isLatestGAedVersion;
        }


        public Agent lastConnection(OffsetDateTime lastConnection) {
        
        this.lastConnection = lastConnection;
        return this;
        }

    /**
        * Get lastConnection
    * @return lastConnection
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LAST_CONNECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastConnection() {
        return lastConnection;
    }


          @JsonProperty(JSON_PROPERTY_LAST_CONNECTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastConnection(OffsetDateTime lastConnection) {
            this.lastConnection = lastConnection;
        }


        public Agent name(String name) {
        
        this.name = name;
        return this;
        }

    /**
        * Get name
    * @return name
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }


          @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
            this.name = name;
        }


        public Agent operationalStatus(OperationalStatus operationalStatus) {
        
        this.operationalStatus = operationalStatus;
        return this;
        }

    /**
        * Get operationalStatus
    * @return operationalStatus
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_OPERATIONAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OperationalStatus getOperationalStatus() {
        return operationalStatus;
    }


          @JsonProperty(JSON_PROPERTY_OPERATIONAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperationalStatus(OperationalStatus operationalStatus) {
            this.operationalStatus = operationalStatus;
        }


        public Agent poolId(String poolId) {
        
        this.poolId = poolId;
        return this;
        }

    /**
        * Get poolId
    * @return poolId
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_POOL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPoolId() {
        return poolId;
    }


          @JsonProperty(JSON_PROPERTY_POOL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPoolId(String poolId) {
            this.poolId = poolId;
        }


        public Agent type(AgentType type) {
        
        this.type = type;
        return this;
        }

    /**
        * Get type
    * @return type
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AgentType getType() {
        return type;
    }


          @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(AgentType type) {
            this.type = type;
        }


        public Agent updateMessage(String updateMessage) {
        
        this.updateMessage = updateMessage;
        return this;
        }

    /**
        * Get updateMessage
    * @return updateMessage
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_UPDATE_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUpdateMessage() {
        return updateMessage;
    }


          @JsonProperty(JSON_PROPERTY_UPDATE_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdateMessage(String updateMessage) {
            this.updateMessage = updateMessage;
        }


        public Agent updateStatus(AgentUpdateInstanceStatus updateStatus) {
        
        this.updateStatus = updateStatus;
        return this;
        }

    /**
        * Get updateStatus
    * @return updateStatus
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_UPDATE_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AgentUpdateInstanceStatus getUpdateStatus() {
        return updateStatus;
    }


          @JsonProperty(JSON_PROPERTY_UPDATE_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdateStatus(AgentUpdateInstanceStatus updateStatus) {
            this.updateStatus = updateStatus;
        }


        public Agent version(String version) {
        
        this.version = version;
        return this;
        }

    /**
        * Get version
    * @return version
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getVersion() {
        return version;
    }


          @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(String version) {
            this.version = version;
        }


        public Agent links(HrefObject links) {
        
        this.links = links;
        return this;
        }

    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getLinks() {
        return links;
    }


          @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(HrefObject links) {
            this.links = links;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        Agent agent = (Agent) o;
        return Objects.equals(this.id, agent.id) &&
        Objects.equals(this.isHidden, agent.isHidden) &&
        Objects.equals(this.isLatestGAedVersion, agent.isLatestGAedVersion) &&
        Objects.equals(this.lastConnection, agent.lastConnection) &&
        Objects.equals(this.name, agent.name) &&
        Objects.equals(this.operationalStatus, agent.operationalStatus) &&
        Objects.equals(this.poolId, agent.poolId) &&
        Objects.equals(this.type, agent.type) &&
        Objects.equals(this.updateMessage, agent.updateMessage) &&
        Objects.equals(this.updateStatus, agent.updateStatus) &&
        Objects.equals(this.version, agent.version) &&
        Objects.equals(this.links, agent.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(id, isHidden, isLatestGAedVersion, lastConnection, name, operationalStatus, poolId, type, updateMessage, updateStatus, version, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Agent {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    isHidden: ").append(toIndentedString(isHidden)).append("\n");
        sb.append("    isLatestGAedVersion: ").append(toIndentedString(isLatestGAedVersion)).append("\n");
        sb.append("    lastConnection: ").append(toIndentedString(lastConnection)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    operationalStatus: ").append(toIndentedString(operationalStatus)).append("\n");
        sb.append("    poolId: ").append(toIndentedString(poolId)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    updateMessage: ").append(toIndentedString(updateMessage)).append("\n");
        sb.append("    updateStatus: ").append(toIndentedString(updateStatus)).append("\n");
        sb.append("    version: ").append(toIndentedString(version)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
