package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.AppLink;
import org.openapitools.client.model.ChangePasswordRequest;
import org.openapitools.client.model.CreateUserRequest;
import org.openapitools.client.model.Error;
import org.openapitools.client.model.ForgotPasswordResponse;
import org.openapitools.client.model.Group;
import org.openapitools.client.model.IdentityProvider;
import org.openapitools.client.model.OAuth2Client;
import org.openapitools.client.model.OAuth2RefreshToken;
import org.openapitools.client.model.OAuth2ScopeConsentGrant;
import org.openapitools.client.model.ResetPasswordToken;
import org.openapitools.client.model.TempPassword;
import org.openapitools.client.model.UpdateUserRequest;
import org.openapitools.client.model.User;
import org.openapitools.client.model.UserActivationToken;
import org.openapitools.client.model.UserCredentials;
import org.openapitools.client.model.UserNextLogin;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.UserApi")
    public class UserApi {
    private ApiClient apiClient;

    public UserApi() {
    this(new ApiClient());
    }

    @Autowired
    public UserApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Activate a User
        * Activates a user.  This operation can only be performed on users with a &#x60;STAGED&#x60; status.  Activation of a user is an asynchronous operation. The user will have the &#x60;transitioningToStatus&#x60; property with a value of &#x60;ACTIVE&#x60; during activation to indicate that the user hasn&#39;t completed the asynchronous operation.  The user will have a status of &#x60;ACTIVE&#x60; when the activation process is complete.
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail Sends an activation email to the user if true (required)
                * @return UserActivationToken
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public UserActivationToken activateUser(String userId, Boolean sendEmail) throws RestClientException {
                return activateUserWithHttpInfo(userId, sendEmail).getBody();
            }






            /**
            * Activate a User
            * Activates a user.  This operation can only be performed on users with a &#x60;STAGED&#x60; status.  Activation of a user is an asynchronous operation. The user will have the &#x60;transitioningToStatus&#x60; property with a value of &#x60;ACTIVE&#x60; during activation to indicate that the user hasn&#39;t completed the asynchronous operation.  The user will have a status of &#x60;ACTIVE&#x60; when the activation process is complete.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail Sends an activation email to the user if true (required)
            * @return ResponseEntity&lt;UserActivationToken&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<UserActivationToken> activateUserWithHttpInfo(String userId, Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling activateUser");
                }
        
                // verify the required parameter 'sendEmail' is set ''
                if (sendEmail == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sendEmail' when calling activateUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserActivationToken> localReturnType = new ParameterizedTypeReference<UserActivationToken>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Activate a User
            * Activates a user.  This operation can only be performed on users with a &#x60;STAGED&#x60; status.  Activation of a user is an asynchronous operation. The user will have the &#x60;transitioningToStatus&#x60; property with a value of &#x60;ACTIVE&#x60; during activation to indicate that the user hasn&#39;t completed the asynchronous operation.  The user will have a status of &#x60;ACTIVE&#x60; when the activation process is complete.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail Sends an activation email to the user if true (required)
            * @return ResponseEntity&lt;UserActivationToken&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList activateUserWithPaginationInfo(String userId, Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling activateUser");
                }
        
                // verify the required parameter 'sendEmail' is set
                if (sendEmail == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sendEmail' when calling activateUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserActivationToken> localReturnType = new ParameterizedTypeReference<UserActivationToken>() {};
            ResponseEntity<UserActivationToken> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Change Password
        * Changes a user&#39;s password by validating the user&#39;s current password. This operation can only be performed on users in &#x60;STAGED&#x60;, &#x60;ACTIVE&#x60;, &#x60;PASSWORD_EXPIRED&#x60;, or &#x60;RECOVERY&#x60; status that have a valid password credential
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param changePasswordRequest  (required)
                * @param strict  (optional)
                * @return UserCredentials
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public UserCredentials changePassword(String userId, ChangePasswordRequest changePasswordRequest, Boolean strict) throws RestClientException {
                return changePasswordWithHttpInfo(userId, changePasswordRequest, strict).getBody();
            }




            /**
            * Change Password
            * Changes a user&#39;s password by validating the user&#39;s current password. This operation can only be performed on users in &#x60;STAGED&#x60;, &#x60;ACTIVE&#x60;, &#x60;PASSWORD_EXPIRED&#x60;, or &#x60;RECOVERY&#x60; status that have a valid password credential
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param userId  (required)
                * @param changePasswordRequest  (required)
                * @param strict  (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T changePassword(Class<?> T, String userId, ChangePasswordRequest changePasswordRequest, Boolean strict) throws RestClientException {
                return (T) getObjectMapper().convertValue(changePasswordWithReturnType(T, userId, changePasswordRequest, strict).getBody(), T);
            }




            /**
            * Change Password
            * Changes a user&#39;s password by validating the user&#39;s current password. This operation can only be performed on users in &#x60;STAGED&#x60;, &#x60;ACTIVE&#x60;, &#x60;PASSWORD_EXPIRED&#x60;, or &#x60;RECOVERY&#x60; status that have a valid password credential
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param changePasswordRequest  (required)
                * @param strict  (optional)
            * @return ResponseEntity&lt;UserCredentials&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<UserCredentials> changePasswordWithHttpInfo(String userId, ChangePasswordRequest changePasswordRequest, Boolean strict) throws RestClientException {
            Object localVarPostBody = changePasswordRequest;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling changePassword");
                }
        
                // verify the required parameter 'changePasswordRequest' is set ''
                if (changePasswordRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'changePasswordRequest' when calling changePassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "strict", strict));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserCredentials> localReturnType = new ParameterizedTypeReference<UserCredentials>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/credentials/change_password", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Change Password
            * Changes a user&#39;s password by validating the user&#39;s current password. This operation can only be performed on users in &#x60;STAGED&#x60;, &#x60;ACTIVE&#x60;, &#x60;PASSWORD_EXPIRED&#x60;, or &#x60;RECOVERY&#x60; status that have a valid password credential
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param changePasswordRequest  (required)
                * @param strict  (optional)
            * @return ResponseEntity&lt;UserCredentials&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> changePasswordWithReturnType(Class<?> T, String userId,ChangePasswordRequest changePasswordRequest,Boolean strict) throws RestClientException {
            Object localVarPostBody = changePasswordRequest;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling changePassword");
                }
        
                // verify the required parameter 'changePasswordRequest' is set
                if (changePasswordRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'changePasswordRequest' when calling changePassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "strict", strict));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/credentials/change_password", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Change Password
            * Changes a user&#39;s password by validating the user&#39;s current password. This operation can only be performed on users in &#x60;STAGED&#x60;, &#x60;ACTIVE&#x60;, &#x60;PASSWORD_EXPIRED&#x60;, or &#x60;RECOVERY&#x60; status that have a valid password credential
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param changePasswordRequest  (required)
                * @param strict  (optional)
            * @return ResponseEntity&lt;UserCredentials&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList changePasswordWithPaginationInfo(String userId, ChangePasswordRequest changePasswordRequest, Boolean strict) throws RestClientException {
            Object localVarPostBody = changePasswordRequest;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling changePassword");
                }
        
                // verify the required parameter 'changePasswordRequest' is set
                if (changePasswordRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'changePasswordRequest' when calling changePassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "strict", strict));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserCredentials> localReturnType = new ParameterizedTypeReference<UserCredentials>() {};
            ResponseEntity<UserCredentials> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/credentials/change_password", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Change Recovery Question
        * Changes a user&#39;s recovery question &amp; answer credential by validating the user&#39;s current password.  This operation can only be performed on users in **STAGED**, **ACTIVE** or **RECOVERY** &#x60;status&#x60; that have a valid password credential
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param userCredentials  (required)
                * @return UserCredentials
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public UserCredentials changeRecoveryQuestion(String userId, UserCredentials userCredentials) throws RestClientException {
                return changeRecoveryQuestionWithHttpInfo(userId, userCredentials).getBody();
            }




            /**
            * Change Recovery Question
            * Changes a user&#39;s recovery question &amp; answer credential by validating the user&#39;s current password.  This operation can only be performed on users in **STAGED**, **ACTIVE** or **RECOVERY** &#x60;status&#x60; that have a valid password credential
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param userId  (required)
                * @param userCredentials  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T changeRecoveryQuestion(Class<?> T, String userId, UserCredentials userCredentials) throws RestClientException {
                return (T) getObjectMapper().convertValue(changeRecoveryQuestionWithReturnType(T, userId, userCredentials).getBody(), T);
            }




            /**
            * Change Recovery Question
            * Changes a user&#39;s recovery question &amp; answer credential by validating the user&#39;s current password.  This operation can only be performed on users in **STAGED**, **ACTIVE** or **RECOVERY** &#x60;status&#x60; that have a valid password credential
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param userCredentials  (required)
            * @return ResponseEntity&lt;UserCredentials&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<UserCredentials> changeRecoveryQuestionWithHttpInfo(String userId, UserCredentials userCredentials) throws RestClientException {
            Object localVarPostBody = userCredentials;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling changeRecoveryQuestion");
                }
        
                // verify the required parameter 'userCredentials' is set ''
                if (userCredentials == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userCredentials' when calling changeRecoveryQuestion");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserCredentials> localReturnType = new ParameterizedTypeReference<UserCredentials>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/credentials/change_recovery_question", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Change Recovery Question
            * Changes a user&#39;s recovery question &amp; answer credential by validating the user&#39;s current password.  This operation can only be performed on users in **STAGED**, **ACTIVE** or **RECOVERY** &#x60;status&#x60; that have a valid password credential
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param userCredentials  (required)
            * @return ResponseEntity&lt;UserCredentials&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> changeRecoveryQuestionWithReturnType(Class<?> T, String userId,UserCredentials userCredentials) throws RestClientException {
            Object localVarPostBody = userCredentials;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling changeRecoveryQuestion");
                }
        
                // verify the required parameter 'userCredentials' is set
                if (userCredentials == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userCredentials' when calling changeRecoveryQuestion");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/credentials/change_recovery_question", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Change Recovery Question
            * Changes a user&#39;s recovery question &amp; answer credential by validating the user&#39;s current password.  This operation can only be performed on users in **STAGED**, **ACTIVE** or **RECOVERY** &#x60;status&#x60; that have a valid password credential
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param userCredentials  (required)
            * @return ResponseEntity&lt;UserCredentials&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList changeRecoveryQuestionWithPaginationInfo(String userId, UserCredentials userCredentials) throws RestClientException {
            Object localVarPostBody = userCredentials;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling changeRecoveryQuestion");
                }
        
                // verify the required parameter 'userCredentials' is set
                if (userCredentials == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userCredentials' when calling changeRecoveryQuestion");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserCredentials> localReturnType = new ParameterizedTypeReference<UserCredentials>() {};
            ResponseEntity<UserCredentials> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/credentials/change_recovery_question", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Create a User
        * Creates a new user in your Okta organization with or without credentials
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param body  (required)
                * @param activate Executes activation lifecycle operation when creating the user (optional, default to true)
                * @param provider Indicates whether to create a user with a specified authentication provider (optional, default to false)
                * @param nextLogin With activate&#x3D;true, set nextLogin to \&quot;changePassword\&quot; to have the password be EXPIRED, so user must change it the next time they log in. (optional)
                * @return User
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public User createUser(CreateUserRequest body, Boolean activate, Boolean provider, UserNextLogin nextLogin) throws RestClientException {
                return createUserWithHttpInfo(body, activate, provider, nextLogin).getBody();
            }




            /**
            * Create a User
            * Creates a new user in your Okta organization with or without credentials
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param body  (required)
                * @param activate Executes activation lifecycle operation when creating the user (optional, default to true)
                * @param provider Indicates whether to create a user with a specified authentication provider (optional, default to false)
                * @param nextLogin With activate&#x3D;true, set nextLogin to \&quot;changePassword\&quot; to have the password be EXPIRED, so user must change it the next time they log in. (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createUser(Class<?> T, CreateUserRequest body, Boolean activate, Boolean provider, UserNextLogin nextLogin) throws RestClientException {
                return (T) getObjectMapper().convertValue(createUserWithReturnType(T, body, activate, provider, nextLogin).getBody(), T);
            }




            /**
            * Create a User
            * Creates a new user in your Okta organization with or without credentials
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param body  (required)
                * @param activate Executes activation lifecycle operation when creating the user (optional, default to true)
                * @param provider Indicates whether to create a user with a specified authentication provider (optional, default to false)
                * @param nextLogin With activate&#x3D;true, set nextLogin to \&quot;changePassword\&quot; to have the password be EXPIRED, so user must change it the next time they log in. (optional)
            * @return ResponseEntity&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<User> createUserWithHttpInfo(CreateUserRequest body, Boolean activate, Boolean provider, UserNextLogin nextLogin) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'body' is set ''
                if (body == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling createUser");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "activate", activate));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "provider", provider));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "nextLogin", nextLogin));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<User> localReturnType = new ParameterizedTypeReference<User>() {};
            return apiClient.invokeAPI("/api/v1/users", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a User
            * Creates a new user in your Okta organization with or without credentials
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param body  (required)
                * @param activate Executes activation lifecycle operation when creating the user (optional, default to true)
                * @param provider Indicates whether to create a user with a specified authentication provider (optional, default to false)
                * @param nextLogin With activate&#x3D;true, set nextLogin to \&quot;changePassword\&quot; to have the password be EXPIRED, so user must change it the next time they log in. (optional)
            * @return ResponseEntity&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createUserWithReturnType(Class<?> T, CreateUserRequest body,Boolean activate,Boolean provider,UserNextLogin nextLogin) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'body' is set
                if (body == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling createUser");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "activate", activate));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "provider", provider));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "nextLogin", nextLogin));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/users", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a User
            * Creates a new user in your Okta organization with or without credentials
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param body  (required)
                * @param activate Executes activation lifecycle operation when creating the user (optional, default to true)
                * @param provider Indicates whether to create a user with a specified authentication provider (optional, default to false)
                * @param nextLogin With activate&#x3D;true, set nextLogin to \&quot;changePassword\&quot; to have the password be EXPIRED, so user must change it the next time they log in. (optional)
            * @return ResponseEntity&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createUserWithPaginationInfo(CreateUserRequest body, Boolean activate, Boolean provider, UserNextLogin nextLogin) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'body' is set
                if (body == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling createUser");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "activate", activate));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "provider", provider));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "nextLogin", nextLogin));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<User> localReturnType = new ParameterizedTypeReference<User>() {};
            ResponseEntity<User> responseEntity = apiClient.invokeAPI("/api/v1/users", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Deactivate a User
        * Deactivates a user. This operation can only be performed on users that do not have a &#x60;DEPROVISIONED&#x60; status. While the asynchronous operation (triggered by HTTP header &#x60;Prefer: respond-async&#x60;) is proceeding the user&#39;s &#x60;transitioningToStatus&#x60; property is &#x60;DEPROVISIONED&#x60;. The user&#39;s status is &#x60;DEPROVISIONED&#x60; when the deactivation process is complete.
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail  (optional, default to false)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deactivateUser(String userId, Boolean sendEmail) throws RestClientException {
            deactivateUserWithHttpInfo(userId, sendEmail);
            }






            /**
            * Deactivate a User
            * Deactivates a user. This operation can only be performed on users that do not have a &#x60;DEPROVISIONED&#x60; status. While the asynchronous operation (triggered by HTTP header &#x60;Prefer: respond-async&#x60;) is proceeding the user&#39;s &#x60;transitioningToStatus&#x60; property is &#x60;DEPROVISIONED&#x60;. The user&#39;s status is &#x60;DEPROVISIONED&#x60; when the deactivation process is complete.
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail  (optional, default to false)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deactivateUserWithHttpInfo(String userId, Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling deactivateUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete a Linked Object
        * Deletes linked objects for a user, relationshipName can be ONLY a primary relationship name
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param relationshipName  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteLinkedObjectForUser(String userId, String relationshipName) throws RestClientException {
            deleteLinkedObjectForUserWithHttpInfo(userId, relationshipName);
            }






            /**
            * Delete a Linked Object
            * Deletes linked objects for a user, relationshipName can be ONLY a primary relationship name
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param relationshipName  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteLinkedObjectForUserWithHttpInfo(String userId, String relationshipName) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling deleteLinkedObjectForUser");
                }
        
                // verify the required parameter 'relationshipName' is set ''
                if (relationshipName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'relationshipName' when calling deleteLinkedObjectForUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("relationshipName", relationshipName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/linkedObjects/{relationshipName}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete a User
        * Deletes a user permanently. This operation can only be performed on users that have a &#x60;DEPROVISIONED&#x60; status.  **This action cannot be recovered!**. Calling this on an &#x60;ACTIVE&#x60; user will transition the user to &#x60;DEPROVISIONED&#x60;.
            * <p><b>204</b> - No Content
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail  (optional, default to false)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteUser(String userId, Boolean sendEmail) throws RestClientException {
            deleteUserWithHttpInfo(userId, sendEmail);
            }






            /**
            * Delete a User
            * Deletes a user permanently. This operation can only be performed on users that have a &#x60;DEPROVISIONED&#x60; status.  **This action cannot be recovered!**. Calling this on an &#x60;ACTIVE&#x60; user will transition the user to &#x60;DEPROVISIONED&#x60;.
                * <p><b>204</b> - No Content
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail  (optional, default to false)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteUserWithHttpInfo(String userId, Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling deleteUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Expire Password
        * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; so that the user is required to change their password at their next login
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @return User
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public User expirePassword(String userId) throws RestClientException {
                return expirePasswordWithHttpInfo(userId).getBody();
            }






            /**
            * Expire Password
            * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; so that the user is required to change their password at their next login
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<User> expirePasswordWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling expirePassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<User> localReturnType = new ParameterizedTypeReference<User>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/expire_password", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Expire Password
            * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; so that the user is required to change their password at their next login
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList expirePasswordWithPaginationInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling expirePassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<User> localReturnType = new ParameterizedTypeReference<User>() {};
            ResponseEntity<User> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/expire_password", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Expire Password and Set Temporary Password
        * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; so that the user is required to change their password at their next login, and also sets the user&#39;s password to a temporary password returned in the response
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @return TempPassword
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public TempPassword expirePasswordAndGetTemporaryPassword(String userId) throws RestClientException {
                return expirePasswordAndGetTemporaryPasswordWithHttpInfo(userId).getBody();
            }






            /**
            * Expire Password and Set Temporary Password
            * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; so that the user is required to change their password at their next login, and also sets the user&#39;s password to a temporary password returned in the response
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;TempPassword&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<TempPassword> expirePasswordAndGetTemporaryPasswordWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling expirePasswordAndGetTemporaryPassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<TempPassword> localReturnType = new ParameterizedTypeReference<TempPassword>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/expire_password_with_temp_password", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Expire Password and Set Temporary Password
            * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; so that the user is required to change their password at their next login, and also sets the user&#39;s password to a temporary password returned in the response
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;TempPassword&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList expirePasswordAndGetTemporaryPasswordWithPaginationInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling expirePasswordAndGetTemporaryPassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<TempPassword> localReturnType = new ParameterizedTypeReference<TempPassword>() {};
            ResponseEntity<TempPassword> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/expire_password_with_temp_password", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Initiate Forgot Password
        * Initiate forgot password flow. Generates a one-time token (OTT) that can be used to reset a user&#39;s password.
            * <p><b>200</b> - Reset url
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail  (optional, default to true)
                * @return ForgotPasswordResponse
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ForgotPasswordResponse forgotPassword(String userId, Boolean sendEmail) throws RestClientException {
                return forgotPasswordWithHttpInfo(userId, sendEmail).getBody();
            }






            /**
            * Initiate Forgot Password
            * Initiate forgot password flow. Generates a one-time token (OTT) that can be used to reset a user&#39;s password.
                * <p><b>200</b> - Reset url
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail  (optional, default to true)
            * @return ResponseEntity&lt;ForgotPasswordResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ForgotPasswordResponse> forgotPasswordWithHttpInfo(String userId, Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling forgotPassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ForgotPasswordResponse> localReturnType = new ParameterizedTypeReference<ForgotPasswordResponse>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/credentials/forgot_password", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Initiate Forgot Password
            * Initiate forgot password flow. Generates a one-time token (OTT) that can be used to reset a user&#39;s password.
                * <p><b>200</b> - Reset url
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail  (optional, default to true)
            * @return ResponseEntity&lt;ForgotPasswordResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList forgotPasswordWithPaginationInfo(String userId, Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling forgotPassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ForgotPasswordResponse> localReturnType = new ParameterizedTypeReference<ForgotPasswordResponse>() {};
            ResponseEntity<ForgotPasswordResponse> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/credentials/forgot_password", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Reset Password with Recovery Question
        * Resets the user&#39;s password to the specified password if the provided answer to the recovery question is correct
            * <p><b>200</b> - Credentials
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param userCredentials  (required)
                * @param sendEmail  (optional, default to true)
                * @return UserCredentials
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public UserCredentials forgotPasswordSetNewPassword(String userId, UserCredentials userCredentials, Boolean sendEmail) throws RestClientException {
                return forgotPasswordSetNewPasswordWithHttpInfo(userId, userCredentials, sendEmail).getBody();
            }




            /**
            * Reset Password with Recovery Question
            * Resets the user&#39;s password to the specified password if the provided answer to the recovery question is correct
                * <p><b>200</b> - Credentials
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param userId  (required)
                * @param userCredentials  (required)
                * @param sendEmail  (optional, default to true)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T forgotPasswordSetNewPassword(Class<?> T, String userId, UserCredentials userCredentials, Boolean sendEmail) throws RestClientException {
                return (T) getObjectMapper().convertValue(forgotPasswordSetNewPasswordWithReturnType(T, userId, userCredentials, sendEmail).getBody(), T);
            }




            /**
            * Reset Password with Recovery Question
            * Resets the user&#39;s password to the specified password if the provided answer to the recovery question is correct
                * <p><b>200</b> - Credentials
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param userCredentials  (required)
                * @param sendEmail  (optional, default to true)
            * @return ResponseEntity&lt;UserCredentials&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<UserCredentials> forgotPasswordSetNewPasswordWithHttpInfo(String userId, UserCredentials userCredentials, Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = userCredentials;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling forgotPasswordSetNewPassword");
                }
        
                // verify the required parameter 'userCredentials' is set ''
                if (userCredentials == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userCredentials' when calling forgotPasswordSetNewPassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserCredentials> localReturnType = new ParameterizedTypeReference<UserCredentials>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/credentials/forgot_password_recovery_question", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Reset Password with Recovery Question
            * Resets the user&#39;s password to the specified password if the provided answer to the recovery question is correct
                * <p><b>200</b> - Credentials
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param userCredentials  (required)
                * @param sendEmail  (optional, default to true)
            * @return ResponseEntity&lt;UserCredentials&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> forgotPasswordSetNewPasswordWithReturnType(Class<?> T, String userId,UserCredentials userCredentials,Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = userCredentials;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling forgotPasswordSetNewPassword");
                }
        
                // verify the required parameter 'userCredentials' is set
                if (userCredentials == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userCredentials' when calling forgotPasswordSetNewPassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/credentials/forgot_password_recovery_question", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Reset Password with Recovery Question
            * Resets the user&#39;s password to the specified password if the provided answer to the recovery question is correct
                * <p><b>200</b> - Credentials
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param userCredentials  (required)
                * @param sendEmail  (optional, default to true)
            * @return ResponseEntity&lt;UserCredentials&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList forgotPasswordSetNewPasswordWithPaginationInfo(String userId, UserCredentials userCredentials, Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = userCredentials;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling forgotPasswordSetNewPassword");
                }
        
                // verify the required parameter 'userCredentials' is set
                if (userCredentials == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userCredentials' when calling forgotPasswordSetNewPassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserCredentials> localReturnType = new ParameterizedTypeReference<UserCredentials>() {};
            ResponseEntity<UserCredentials> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/credentials/forgot_password_recovery_question", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Refresh Token for a Client
        * Retrieves a refresh token issued for the specified User and Client
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
                * @param tokenId  (required)
                * @param expand  (optional)
                * @param limit  (optional, default to 20)
                * @param after  (optional)
                * @return OAuth2RefreshToken
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public OAuth2RefreshToken getRefreshTokenForUserAndClient(String userId, String clientId, String tokenId, String expand, Integer limit, String after) throws RestClientException {
                return getRefreshTokenForUserAndClientWithHttpInfo(userId, clientId, tokenId, expand, limit, after).getBody();
            }






            /**
            * Retrieve a Refresh Token for a Client
            * Retrieves a refresh token issued for the specified User and Client
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
                * @param tokenId  (required)
                * @param expand  (optional)
                * @param limit  (optional, default to 20)
                * @param after  (optional)
            * @return ResponseEntity&lt;OAuth2RefreshToken&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<OAuth2RefreshToken> getRefreshTokenForUserAndClientWithHttpInfo(String userId, String clientId, String tokenId, String expand, Integer limit, String after) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getRefreshTokenForUserAndClient");
                }
        
                // verify the required parameter 'clientId' is set ''
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling getRefreshTokenForUserAndClient");
                }
        
                // verify the required parameter 'tokenId' is set ''
                if (tokenId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling getRefreshTokenForUserAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("clientId", clientId);
                    uriVariables.put("tokenId", tokenId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2RefreshToken> localReturnType = new ParameterizedTypeReference<OAuth2RefreshToken>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/clients/{clientId}/tokens/{tokenId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Refresh Token for a Client
            * Retrieves a refresh token issued for the specified User and Client
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
                * @param tokenId  (required)
                * @param expand  (optional)
                * @param limit  (optional, default to 20)
                * @param after  (optional)
            * @return ResponseEntity&lt;OAuth2RefreshToken&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getRefreshTokenForUserAndClientWithPaginationInfo(String userId, String clientId, String tokenId, String expand, Integer limit, String after) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getRefreshTokenForUserAndClient");
                }
        
                // verify the required parameter 'clientId' is set
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling getRefreshTokenForUserAndClient");
                }
        
                // verify the required parameter 'tokenId' is set
                if (tokenId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling getRefreshTokenForUserAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("clientId", clientId);
                    uriVariables.put("tokenId", tokenId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2RefreshToken> localReturnType = new ParameterizedTypeReference<OAuth2RefreshToken>() {};
            ResponseEntity<OAuth2RefreshToken> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/clients/{clientId}/tokens/{tokenId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a User
        * Retrieves a user from your Okta organization
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @return User
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public User getUser(String userId) throws RestClientException {
                return getUserWithHttpInfo(userId).getBody();
            }






            /**
            * Retrieve a User
            * Retrieves a user from your Okta organization
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<User> getUserWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<User> localReturnType = new ParameterizedTypeReference<User>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a User
            * Retrieves a user from your Okta organization
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getUserWithPaginationInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<User> localReturnType = new ParameterizedTypeReference<User>() {};
            ResponseEntity<User> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a User Grant
        * Retrieves a grant for the specified user
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param grantId  (required)
                * @param expand  (optional)
                * @return OAuth2ScopeConsentGrant
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public OAuth2ScopeConsentGrant getUserGrant(String userId, String grantId, String expand) throws RestClientException {
                return getUserGrantWithHttpInfo(userId, grantId, expand).getBody();
            }






            /**
            * Retrieve a User Grant
            * Retrieves a grant for the specified user
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param grantId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;OAuth2ScopeConsentGrant&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<OAuth2ScopeConsentGrant> getUserGrantWithHttpInfo(String userId, String grantId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getUserGrant");
                }
        
                // verify the required parameter 'grantId' is set ''
                if (grantId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'grantId' when calling getUserGrant");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("grantId", grantId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2ScopeConsentGrant> localReturnType = new ParameterizedTypeReference<OAuth2ScopeConsentGrant>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/grants/{grantId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a User Grant
            * Retrieves a grant for the specified user
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param grantId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;OAuth2ScopeConsentGrant&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getUserGrantWithPaginationInfo(String userId, String grantId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getUserGrant");
                }
        
                // verify the required parameter 'grantId' is set
                if (grantId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'grantId' when calling getUserGrant");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("grantId", grantId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2ScopeConsentGrant> localReturnType = new ParameterizedTypeReference<OAuth2ScopeConsentGrant>() {};
            ResponseEntity<OAuth2ScopeConsentGrant> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/grants/{grantId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Assigned Application Links
        * Lists all appLinks for all direct or indirect (via group membership) assigned applications
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @return List&lt;AppLink&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<AppLink> listAppLinks(String userId) throws RestClientException {
                return listAppLinksWithHttpInfo(userId).getBody();
            }






            /**
            * List all Assigned Application Links
            * Lists all appLinks for all direct or indirect (via group membership) assigned applications
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;AppLink&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<AppLink>> listAppLinksWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listAppLinks");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AppLink>> localReturnType = new ParameterizedTypeReference<List<AppLink>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/appLinks", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Assigned Application Links
            * Lists all appLinks for all direct or indirect (via group membership) assigned applications
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;AppLink&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listAppLinksWithPaginationInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listAppLinks");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AppLink>> localReturnType = new ParameterizedTypeReference<List<AppLink>>() {};
            ResponseEntity<List<AppLink>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/appLinks", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Grants for a Client
        * Lists all grants for a specified user and client
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
                * @return List&lt;OAuth2ScopeConsentGrant&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<OAuth2ScopeConsentGrant> listGrantsForUserAndClient(String userId, String clientId, String expand, String after, Integer limit) throws RestClientException {
                return listGrantsForUserAndClientWithHttpInfo(userId, clientId, expand, after, limit).getBody();
            }






            /**
            * List all Grants for a Client
            * Lists all grants for a specified user and client
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;OAuth2ScopeConsentGrant&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<OAuth2ScopeConsentGrant>> listGrantsForUserAndClientWithHttpInfo(String userId, String clientId, String expand, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listGrantsForUserAndClient");
                }
        
                // verify the required parameter 'clientId' is set ''
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling listGrantsForUserAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("clientId", clientId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>> localReturnType = new ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/clients/{clientId}/grants", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Grants for a Client
            * Lists all grants for a specified user and client
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;OAuth2ScopeConsentGrant&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listGrantsForUserAndClientWithPaginationInfo(String userId, String clientId, String expand, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listGrantsForUserAndClient");
                }
        
                // verify the required parameter 'clientId' is set
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling listGrantsForUserAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("clientId", clientId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>> localReturnType = new ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>>() {};
            ResponseEntity<List<OAuth2ScopeConsentGrant>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/clients/{clientId}/grants", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Linked Objects
        * Lists all linked objects for a user, relationshipName can be a primary or associated relationship name
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param relationshipName  (required)
                * @param after  (optional)
                * @param limit  (optional, default to -1)
                * @return List&lt;Object&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<Object> listLinkedObjectsForUser(String userId, String relationshipName, String after, Integer limit) throws RestClientException {
                return listLinkedObjectsForUserWithHttpInfo(userId, relationshipName, after, limit).getBody();
            }






            /**
            * List all Linked Objects
            * Lists all linked objects for a user, relationshipName can be a primary or associated relationship name
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param relationshipName  (required)
                * @param after  (optional)
                * @param limit  (optional, default to -1)
            * @return ResponseEntity&lt;List&lt;Object&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<Object>> listLinkedObjectsForUserWithHttpInfo(String userId, String relationshipName, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listLinkedObjectsForUser");
                }
        
                // verify the required parameter 'relationshipName' is set ''
                if (relationshipName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'relationshipName' when calling listLinkedObjectsForUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("relationshipName", relationshipName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Object>> localReturnType = new ParameterizedTypeReference<List<Object>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/linkedObjects/{relationshipName}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Linked Objects
            * Lists all linked objects for a user, relationshipName can be a primary or associated relationship name
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param relationshipName  (required)
                * @param after  (optional)
                * @param limit  (optional, default to -1)
            * @return ResponseEntity&lt;List&lt;Object&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listLinkedObjectsForUserWithPaginationInfo(String userId, String relationshipName, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listLinkedObjectsForUser");
                }
        
                // verify the required parameter 'relationshipName' is set
                if (relationshipName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'relationshipName' when calling listLinkedObjectsForUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("relationshipName", relationshipName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Object>> localReturnType = new ParameterizedTypeReference<List<Object>>() {};
            ResponseEntity<List<Object>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/linkedObjects/{relationshipName}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Refresh Tokens for a Client
        * Lists all refresh tokens issued for the specified User and Client
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
                * @return List&lt;OAuth2RefreshToken&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<OAuth2RefreshToken> listRefreshTokensForUserAndClient(String userId, String clientId, String expand, String after, Integer limit) throws RestClientException {
                return listRefreshTokensForUserAndClientWithHttpInfo(userId, clientId, expand, after, limit).getBody();
            }






            /**
            * List all Refresh Tokens for a Client
            * Lists all refresh tokens issued for the specified User and Client
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;OAuth2RefreshToken&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<OAuth2RefreshToken>> listRefreshTokensForUserAndClientWithHttpInfo(String userId, String clientId, String expand, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listRefreshTokensForUserAndClient");
                }
        
                // verify the required parameter 'clientId' is set ''
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling listRefreshTokensForUserAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("clientId", clientId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2RefreshToken>> localReturnType = new ParameterizedTypeReference<List<OAuth2RefreshToken>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/clients/{clientId}/tokens", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Refresh Tokens for a Client
            * Lists all refresh tokens issued for the specified User and Client
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;OAuth2RefreshToken&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listRefreshTokensForUserAndClientWithPaginationInfo(String userId, String clientId, String expand, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listRefreshTokensForUserAndClient");
                }
        
                // verify the required parameter 'clientId' is set
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling listRefreshTokensForUserAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("clientId", clientId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2RefreshToken>> localReturnType = new ParameterizedTypeReference<List<OAuth2RefreshToken>>() {};
            ResponseEntity<List<OAuth2RefreshToken>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/clients/{clientId}/tokens", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Clients
        * Lists all client resources for which the specified user has grants or tokens
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @return List&lt;OAuth2Client&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<OAuth2Client> listUserClients(String userId) throws RestClientException {
                return listUserClientsWithHttpInfo(userId).getBody();
            }






            /**
            * List all Clients
            * Lists all client resources for which the specified user has grants or tokens
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;OAuth2Client&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<OAuth2Client>> listUserClientsWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listUserClients");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2Client>> localReturnType = new ParameterizedTypeReference<List<OAuth2Client>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/clients", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Clients
            * Lists all client resources for which the specified user has grants or tokens
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;OAuth2Client&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listUserClientsWithPaginationInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listUserClients");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2Client>> localReturnType = new ParameterizedTypeReference<List<OAuth2Client>>() {};
            ResponseEntity<List<OAuth2Client>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/clients", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all User Grants
        * Lists all grants for the specified user
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param scopeId  (optional)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
                * @return List&lt;OAuth2ScopeConsentGrant&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<OAuth2ScopeConsentGrant> listUserGrants(String userId, String scopeId, String expand, String after, Integer limit) throws RestClientException {
                return listUserGrantsWithHttpInfo(userId, scopeId, expand, after, limit).getBody();
            }






            /**
            * List all User Grants
            * Lists all grants for the specified user
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param scopeId  (optional)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;OAuth2ScopeConsentGrant&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<OAuth2ScopeConsentGrant>> listUserGrantsWithHttpInfo(String userId, String scopeId, String expand, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listUserGrants");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "scopeId", scopeId));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>> localReturnType = new ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/grants", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all User Grants
            * Lists all grants for the specified user
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param scopeId  (optional)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;OAuth2ScopeConsentGrant&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listUserGrantsWithPaginationInfo(String userId, String scopeId, String expand, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listUserGrants");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "scopeId", scopeId));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>> localReturnType = new ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>>() {};
            ResponseEntity<List<OAuth2ScopeConsentGrant>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/grants", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Groups
        * Lists all groups of which the user is a member
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @return List&lt;Group&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<Group> listUserGroups(String userId) throws RestClientException {
                return listUserGroupsWithHttpInfo(userId).getBody();
            }






            /**
            * List all Groups
            * Lists all groups of which the user is a member
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;Group&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<Group>> listUserGroupsWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listUserGroups");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Group>> localReturnType = new ParameterizedTypeReference<List<Group>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/groups", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Groups
            * Lists all groups of which the user is a member
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;Group&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listUserGroupsWithPaginationInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listUserGroups");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Group>> localReturnType = new ParameterizedTypeReference<List<Group>>() {};
            ResponseEntity<List<Group>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/groups", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Identity Providers
        * Lists the IdPs associated with the user
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @return List&lt;IdentityProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<IdentityProvider> listUserIdentityProviders(String userId) throws RestClientException {
                return listUserIdentityProvidersWithHttpInfo(userId).getBody();
            }






            /**
            * List all Identity Providers
            * Lists the IdPs associated with the user
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;IdentityProvider&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<IdentityProvider>> listUserIdentityProvidersWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listUserIdentityProviders");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<IdentityProvider>> localReturnType = new ParameterizedTypeReference<List<IdentityProvider>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/idps", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Identity Providers
            * Lists the IdPs associated with the user
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;List&lt;IdentityProvider&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listUserIdentityProvidersWithPaginationInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listUserIdentityProviders");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<IdentityProvider>> localReturnType = new ParameterizedTypeReference<List<IdentityProvider>>() {};
            ResponseEntity<List<IdentityProvider>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/idps", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Users
        * Lists all users with pagination.  A subset of users can be returned that match a supported filter expression or search criteria.
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param q Finds a user that matches firstName, lastName, and email properties (optional)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @param limit Specifies the number of results returned. Defaults to 10 if &#x60;q&#x60; is provided. (optional, default to 200)
                * @param filter Filters users with a supported expression for a subset of properties (optional)
                * @param search Searches for users with a supported filtering expression for most properties. Okta recommends using this parameter for search for best performance. (optional)
                * @param sortBy  (optional)
                * @param sortOrder  (optional)
                * @return List&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<User> listUsers(String q, String after, Integer limit, String filter, String search, String sortBy, String sortOrder) throws RestClientException {
                return listUsersWithHttpInfo(q, after, limit, filter, search, sortBy, sortOrder).getBody();
            }






            /**
            * List all Users
            * Lists all users with pagination.  A subset of users can be returned that match a supported filter expression or search criteria.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param q Finds a user that matches firstName, lastName, and email properties (optional)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @param limit Specifies the number of results returned. Defaults to 10 if &#x60;q&#x60; is provided. (optional, default to 200)
                * @param filter Filters users with a supported expression for a subset of properties (optional)
                * @param search Searches for users with a supported filtering expression for most properties. Okta recommends using this parameter for search for best performance. (optional)
                * @param sortBy  (optional)
                * @param sortOrder  (optional)
            * @return ResponseEntity&lt;List&lt;User&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<User>> listUsersWithHttpInfo(String q, String after, Integer limit, String filter, String search, String sortBy, String sortOrder) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "filter", filter));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "search", search));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sortBy", sortBy));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sortOrder", sortOrder));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<User>> localReturnType = new ParameterizedTypeReference<List<User>>() {};
            return apiClient.invokeAPI("/api/v1/users", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Users
            * Lists all users with pagination.  A subset of users can be returned that match a supported filter expression or search criteria.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param q Finds a user that matches firstName, lastName, and email properties (optional)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @param limit Specifies the number of results returned. Defaults to 10 if &#x60;q&#x60; is provided. (optional, default to 200)
                * @param filter Filters users with a supported expression for a subset of properties (optional)
                * @param search Searches for users with a supported filtering expression for most properties. Okta recommends using this parameter for search for best performance. (optional)
                * @param sortBy  (optional)
                * @param sortOrder  (optional)
            * @return ResponseEntity&lt;List&lt;User&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listUsersWithPaginationInfo(String q, String after, Integer limit, String filter, String search, String sortBy, String sortOrder) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "filter", filter));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "search", search));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sortBy", sortBy));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sortOrder", sortOrder));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<User>> localReturnType = new ParameterizedTypeReference<List<User>>() {};
            ResponseEntity<List<User>> responseEntity = apiClient.invokeAPI("/api/v1/users", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Reactivate a User
        * Reactivates a user.  This operation can only be performed on users with a &#x60;PROVISIONED&#x60; status.  This operation restarts the activation workflow if for some reason the user activation was not completed when using the activationToken from [Activate User](#activate-user).
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail Sends an activation email to the user if true (optional, default to false)
                * @return UserActivationToken
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public UserActivationToken reactivateUser(String userId, Boolean sendEmail) throws RestClientException {
                return reactivateUserWithHttpInfo(userId, sendEmail).getBody();
            }






            /**
            * Reactivate a User
            * Reactivates a user.  This operation can only be performed on users with a &#x60;PROVISIONED&#x60; status.  This operation restarts the activation workflow if for some reason the user activation was not completed when using the activationToken from [Activate User](#activate-user).
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail Sends an activation email to the user if true (optional, default to false)
            * @return ResponseEntity&lt;UserActivationToken&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<UserActivationToken> reactivateUserWithHttpInfo(String userId, Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling reactivateUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserActivationToken> localReturnType = new ParameterizedTypeReference<UserActivationToken>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/reactivate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Reactivate a User
            * Reactivates a user.  This operation can only be performed on users with a &#x60;PROVISIONED&#x60; status.  This operation restarts the activation workflow if for some reason the user activation was not completed when using the activationToken from [Activate User](#activate-user).
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail Sends an activation email to the user if true (optional, default to false)
            * @return ResponseEntity&lt;UserActivationToken&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList reactivateUserWithPaginationInfo(String userId, Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling reactivateUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserActivationToken> localReturnType = new ParameterizedTypeReference<UserActivationToken>() {};
            ResponseEntity<UserActivationToken> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/reactivate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace a User
        * Replaces a user&#39;s profile and/or credentials using strict-update semantics
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param user  (required)
                * @param strict  (optional)
                * @return User
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public User replaceUser(String userId, UpdateUserRequest user, Boolean strict) throws RestClientException {
                return replaceUserWithHttpInfo(userId, user, strict).getBody();
            }




            /**
            * Replace a User
            * Replaces a user&#39;s profile and/or credentials using strict-update semantics
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param userId  (required)
                * @param user  (required)
                * @param strict  (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceUser(Class<?> T, String userId, UpdateUserRequest user, Boolean strict) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceUserWithReturnType(T, userId, user, strict).getBody(), T);
            }




            /**
            * Replace a User
            * Replaces a user&#39;s profile and/or credentials using strict-update semantics
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param user  (required)
                * @param strict  (optional)
            * @return ResponseEntity&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<User> replaceUserWithHttpInfo(String userId, UpdateUserRequest user, Boolean strict) throws RestClientException {
            Object localVarPostBody = user;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling replaceUser");
                }
        
                // verify the required parameter 'user' is set ''
                if (user == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'user' when calling replaceUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "strict", strict));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<User> localReturnType = new ParameterizedTypeReference<User>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a User
            * Replaces a user&#39;s profile and/or credentials using strict-update semantics
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param user  (required)
                * @param strict  (optional)
            * @return ResponseEntity&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceUserWithReturnType(Class<?> T, String userId,UpdateUserRequest user,Boolean strict) throws RestClientException {
            Object localVarPostBody = user;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling replaceUser");
                }
        
                // verify the required parameter 'user' is set
                if (user == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'user' when calling replaceUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "strict", strict));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a User
            * Replaces a user&#39;s profile and/or credentials using strict-update semantics
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param user  (required)
                * @param strict  (optional)
            * @return ResponseEntity&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceUserWithPaginationInfo(String userId, UpdateUserRequest user, Boolean strict) throws RestClientException {
            Object localVarPostBody = user;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling replaceUser");
                }
        
                // verify the required parameter 'user' is set
                if (user == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'user' when calling replaceUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "strict", strict));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<User> localReturnType = new ParameterizedTypeReference<User>() {};
            ResponseEntity<User> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Reset all Factors
        * This operation resets all factors for the specified user. All MFA factor enrollments returned to the unenrolled state. The user&#39;s status remains ACTIVE. This link is present only if the user is currently enrolled in one or more MFA factors.
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void resetFactors(String userId) throws RestClientException {
            resetFactorsWithHttpInfo(userId);
            }






            /**
            * Reset all Factors
            * This operation resets all factors for the specified user. All MFA factor enrollments returned to the unenrolled state. The user&#39;s status remains ACTIVE. This link is present only if the user is currently enrolled in one or more MFA factors.
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> resetFactorsWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling resetFactors");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/reset_factors", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Reset Password
        * Generates a one-time token (OTT) that can be used to reset a user&#39;s password.  The OTT link can be automatically emailed to the user or returned to the API caller and distributed using a custom flow.
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail  (required)
                * @return ResetPasswordToken
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ResetPasswordToken resetPassword(String userId, Boolean sendEmail) throws RestClientException {
                return resetPasswordWithHttpInfo(userId, sendEmail).getBody();
            }






            /**
            * Reset Password
            * Generates a one-time token (OTT) that can be used to reset a user&#39;s password.  The OTT link can be automatically emailed to the user or returned to the API caller and distributed using a custom flow.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail  (required)
            * @return ResponseEntity&lt;ResetPasswordToken&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ResetPasswordToken> resetPasswordWithHttpInfo(String userId, Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling resetPassword");
                }
        
                // verify the required parameter 'sendEmail' is set ''
                if (sendEmail == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sendEmail' when calling resetPassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResetPasswordToken> localReturnType = new ParameterizedTypeReference<ResetPasswordToken>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/reset_password", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Reset Password
            * Generates a one-time token (OTT) that can be used to reset a user&#39;s password.  The OTT link can be automatically emailed to the user or returned to the API caller and distributed using a custom flow.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param sendEmail  (required)
            * @return ResponseEntity&lt;ResetPasswordToken&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList resetPasswordWithPaginationInfo(String userId, Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling resetPassword");
                }
        
                // verify the required parameter 'sendEmail' is set
                if (sendEmail == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sendEmail' when calling resetPassword");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ResetPasswordToken> localReturnType = new ParameterizedTypeReference<ResetPasswordToken>() {};
            ResponseEntity<ResetPasswordToken> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/reset_password", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Revoke all Grants for a Client
        * Revokes all grants for the specified user and client
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeGrantsForUserAndClient(String userId, String clientId) throws RestClientException {
            revokeGrantsForUserAndClientWithHttpInfo(userId, clientId);
            }






            /**
            * Revoke all Grants for a Client
            * Revokes all grants for the specified user and client
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeGrantsForUserAndClientWithHttpInfo(String userId, String clientId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling revokeGrantsForUserAndClient");
                }
        
                // verify the required parameter 'clientId' is set ''
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling revokeGrantsForUserAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("clientId", clientId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/clients/{clientId}/grants", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Revoke a Token for a Client
        * Revokes the specified refresh token
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
                * @param tokenId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeTokenForUserAndClient(String userId, String clientId, String tokenId) throws RestClientException {
            revokeTokenForUserAndClientWithHttpInfo(userId, clientId, tokenId);
            }






            /**
            * Revoke a Token for a Client
            * Revokes the specified refresh token
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
                * @param tokenId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeTokenForUserAndClientWithHttpInfo(String userId, String clientId, String tokenId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling revokeTokenForUserAndClient");
                }
        
                // verify the required parameter 'clientId' is set ''
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling revokeTokenForUserAndClient");
                }
        
                // verify the required parameter 'tokenId' is set ''
                if (tokenId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling revokeTokenForUserAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("clientId", clientId);
                    uriVariables.put("tokenId", tokenId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/clients/{clientId}/tokens/{tokenId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Revoke all Refresh Tokens for a Client
        * Revokes all refresh tokens issued for the specified User and Client
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeTokensForUserAndClient(String userId, String clientId) throws RestClientException {
            revokeTokensForUserAndClientWithHttpInfo(userId, clientId);
            }






            /**
            * Revoke all Refresh Tokens for a Client
            * Revokes all refresh tokens issued for the specified User and Client
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param clientId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeTokensForUserAndClientWithHttpInfo(String userId, String clientId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling revokeTokensForUserAndClient");
                }
        
                // verify the required parameter 'clientId' is set ''
                if (clientId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientId' when calling revokeTokensForUserAndClient");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("clientId", clientId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/clients/{clientId}/tokens", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Revoke a User Grant
        * Revokes one grant for a specified user
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param grantId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeUserGrant(String userId, String grantId) throws RestClientException {
            revokeUserGrantWithHttpInfo(userId, grantId);
            }






            /**
            * Revoke a User Grant
            * Revokes one grant for a specified user
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param grantId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeUserGrantWithHttpInfo(String userId, String grantId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling revokeUserGrant");
                }
        
                // verify the required parameter 'grantId' is set ''
                if (grantId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'grantId' when calling revokeUserGrant");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("grantId", grantId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/grants/{grantId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Revoke all User Grants
        * Revokes all grants for a specified user
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeUserGrants(String userId) throws RestClientException {
            revokeUserGrantsWithHttpInfo(userId);
            }






            /**
            * Revoke all User Grants
            * Revokes all grants for a specified user
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeUserGrantsWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling revokeUserGrants");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/grants", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Revoke all User Sessions
        * Revokes all active identity provider sessions of the user. This forces the user to authenticate on the next operation. Optionally revokes OpenID Connect and OAuth refresh and access tokens issued to the user.
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param oauthTokens Revoke issued OpenID Connect and OAuth refresh and access tokens (optional, default to false)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeUserSessions(String userId, Boolean oauthTokens) throws RestClientException {
            revokeUserSessionsWithHttpInfo(userId, oauthTokens);
            }






            /**
            * Revoke all User Sessions
            * Revokes all active identity provider sessions of the user. This forces the user to authenticate on the next operation. Optionally revokes OpenID Connect and OAuth refresh and access tokens issued to the user.
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param oauthTokens Revoke issued OpenID Connect and OAuth refresh and access tokens (optional, default to false)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeUserSessionsWithHttpInfo(String userId, Boolean oauthTokens) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling revokeUserSessions");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "oauthTokens", oauthTokens));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/sessions", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Create a Linked Object for two User
        * Creates a linked object for two users
            * <p><b>204</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param associatedUserId  (required)
                * @param primaryRelationshipName  (required)
                * @param primaryUserId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void setLinkedObjectForUser(String associatedUserId, String primaryRelationshipName, String primaryUserId) throws RestClientException {
            setLinkedObjectForUserWithHttpInfo(associatedUserId, primaryRelationshipName, primaryUserId);
            }






            /**
            * Create a Linked Object for two User
            * Creates a linked object for two users
                * <p><b>204</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param associatedUserId  (required)
                * @param primaryRelationshipName  (required)
                * @param primaryUserId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> setLinkedObjectForUserWithHttpInfo(String associatedUserId, String primaryRelationshipName, String primaryUserId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'associatedUserId' is set ''
                if (associatedUserId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'associatedUserId' when calling setLinkedObjectForUser");
                }
        
                // verify the required parameter 'primaryRelationshipName' is set ''
                if (primaryRelationshipName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'primaryRelationshipName' when calling setLinkedObjectForUser");
                }
        
                // verify the required parameter 'primaryUserId' is set ''
                if (primaryUserId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'primaryUserId' when calling setLinkedObjectForUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("associatedUserId", associatedUserId);
                    uriVariables.put("primaryRelationshipName", primaryRelationshipName);
                    uriVariables.put("primaryUserId", primaryUserId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{associatedUserId}/linkedObjects/{primaryRelationshipName}/{primaryUserId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Suspend a User
        * Suspends a user.  This operation can only be performed on users with an &#x60;ACTIVE&#x60; status.  The user will have a status of &#x60;SUSPENDED&#x60; when the process is complete.
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void suspendUser(String userId) throws RestClientException {
            suspendUserWithHttpInfo(userId);
            }






            /**
            * Suspend a User
            * Suspends a user.  This operation can only be performed on users with an &#x60;ACTIVE&#x60; status.  The user will have a status of &#x60;SUSPENDED&#x60; when the process is complete.
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> suspendUserWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling suspendUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/suspend", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Unlock a User
        * Unlocks a user with a &#x60;LOCKED_OUT&#x60; status and returns them to &#x60;ACTIVE&#x60; status.  Users will be able to login with their current password.
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unlockUser(String userId) throws RestClientException {
            unlockUserWithHttpInfo(userId);
            }






            /**
            * Unlock a User
            * Unlocks a user with a &#x60;LOCKED_OUT&#x60; status and returns them to &#x60;ACTIVE&#x60; status.  Users will be able to login with their current password.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unlockUserWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling unlockUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/unlock", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Unsuspend a User
        * Unsuspends a user and returns them to the &#x60;ACTIVE&#x60; state.  This operation can only be performed on users that have a &#x60;SUSPENDED&#x60; status.
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unsuspendUser(String userId) throws RestClientException {
            unsuspendUserWithHttpInfo(userId);
            }






            /**
            * Unsuspend a User
            * Unsuspends a user and returns them to the &#x60;ACTIVE&#x60; state.  This operation can only be performed on users that have a &#x60;SUSPENDED&#x60; status.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unsuspendUserWithHttpInfo(String userId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling unsuspendUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/lifecycle/unsuspend", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Update a User
        * Updates a user partially determined by the request parameters
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param user  (required)
                * @param strict  (optional)
                * @return User
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public User updateUser(String userId, UpdateUserRequest user, Boolean strict) throws RestClientException {
                return updateUserWithHttpInfo(userId, user, strict).getBody();
            }




            /**
            * Update a User
            * Updates a user partially determined by the request parameters
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param userId  (required)
                * @param user  (required)
                * @param strict  (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T updateUser(Class<?> T, String userId, UpdateUserRequest user, Boolean strict) throws RestClientException {
                return (T) getObjectMapper().convertValue(updateUserWithReturnType(T, userId, user, strict).getBody(), T);
            }




            /**
            * Update a User
            * Updates a user partially determined by the request parameters
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param user  (required)
                * @param strict  (optional)
            * @return ResponseEntity&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<User> updateUserWithHttpInfo(String userId, UpdateUserRequest user, Boolean strict) throws RestClientException {
            Object localVarPostBody = user;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling updateUser");
                }
        
                // verify the required parameter 'user' is set ''
                if (user == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'user' when calling updateUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "strict", strict));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<User> localReturnType = new ParameterizedTypeReference<User>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update a User
            * Updates a user partially determined by the request parameters
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param user  (required)
                * @param strict  (optional)
            * @return ResponseEntity&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> updateUserWithReturnType(Class<?> T, String userId,UpdateUserRequest user,Boolean strict) throws RestClientException {
            Object localVarPostBody = user;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling updateUser");
                }
        
                // verify the required parameter 'user' is set
                if (user == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'user' when calling updateUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "strict", strict));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update a User
            * Updates a user partially determined by the request parameters
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param user  (required)
                * @param strict  (optional)
            * @return ResponseEntity&lt;User&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList updateUserWithPaginationInfo(String userId, UpdateUserRequest user, Boolean strict) throws RestClientException {
            Object localVarPostBody = user;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling updateUser");
                }
        
                // verify the required parameter 'user' is set
                if (user == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'user' when calling updateUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "strict", strict));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<User> localReturnType = new ParameterizedTypeReference<User>() {};
            ResponseEntity<User> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }


    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
