package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.Error;
import org.openapitools.client.model.SmsTemplate;
import org.openapitools.client.model.SmsTemplateType;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.TemplateApi")
    public class TemplateApi {
    private ApiClient apiClient;

    public TemplateApi() {
    this(new ApiClient());
    }

    @Autowired
    public TemplateApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Create an SMS Template
        * Creates a new custom SMS template
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param smsTemplate  (required)
                * @return SmsTemplate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public SmsTemplate createSmsTemplate(SmsTemplate smsTemplate) throws RestClientException {
                return createSmsTemplateWithHttpInfo(smsTemplate).getBody();
            }




            /**
            * Create an SMS Template
            * Creates a new custom SMS template
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param smsTemplate  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createSmsTemplate(Class<?> T, SmsTemplate smsTemplate) throws RestClientException {
                return (T) getObjectMapper().convertValue(createSmsTemplateWithReturnType(T, smsTemplate).getBody(), T);
            }




            /**
            * Create an SMS Template
            * Creates a new custom SMS template
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param smsTemplate  (required)
            * @return ResponseEntity&lt;SmsTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<SmsTemplate> createSmsTemplateWithHttpInfo(SmsTemplate smsTemplate) throws RestClientException {
            Object localVarPostBody = smsTemplate;
        
                // verify the required parameter 'smsTemplate' is set ''
                if (smsTemplate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling createSmsTemplate");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>() {};
            return apiClient.invokeAPI("/api/v1/templates/sms", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an SMS Template
            * Creates a new custom SMS template
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param smsTemplate  (required)
            * @return ResponseEntity&lt;SmsTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createSmsTemplateWithReturnType(Class<?> T, SmsTemplate smsTemplate) throws RestClientException {
            Object localVarPostBody = smsTemplate;
        
                // verify the required parameter 'smsTemplate' is set
                if (smsTemplate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling createSmsTemplate");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/templates/sms", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an SMS Template
            * Creates a new custom SMS template
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param smsTemplate  (required)
            * @return ResponseEntity&lt;SmsTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createSmsTemplateWithPaginationInfo(SmsTemplate smsTemplate) throws RestClientException {
            Object localVarPostBody = smsTemplate;
        
                // verify the required parameter 'smsTemplate' is set
                if (smsTemplate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling createSmsTemplate");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>() {};
            ResponseEntity<SmsTemplate> responseEntity = apiClient.invokeAPI("/api/v1/templates/sms", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Delete an SMS Template
        * Deletes an SMS template
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param templateId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteSmsTemplate(String templateId) throws RestClientException {
            deleteSmsTemplateWithHttpInfo(templateId);
            }






            /**
            * Delete an SMS Template
            * Deletes an SMS template
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param templateId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteSmsTemplateWithHttpInfo(String templateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'templateId' is set ''
                if (templateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling deleteSmsTemplate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("templateId", templateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Retrieve an SMS Template
        * Retrieves a specific template by &#x60;id&#x60;
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param templateId  (required)
                * @return SmsTemplate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public SmsTemplate getSmsTemplate(String templateId) throws RestClientException {
                return getSmsTemplateWithHttpInfo(templateId).getBody();
            }






            /**
            * Retrieve an SMS Template
            * Retrieves a specific template by &#x60;id&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param templateId  (required)
            * @return ResponseEntity&lt;SmsTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<SmsTemplate> getSmsTemplateWithHttpInfo(String templateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'templateId' is set ''
                if (templateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling getSmsTemplate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("templateId", templateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>() {};
            return apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve an SMS Template
            * Retrieves a specific template by &#x60;id&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param templateId  (required)
            * @return ResponseEntity&lt;SmsTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getSmsTemplateWithPaginationInfo(String templateId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'templateId' is set
                if (templateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling getSmsTemplate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("templateId", templateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>() {};
            ResponseEntity<SmsTemplate> responseEntity = apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all SMS Templates
        * Lists all custom SMS templates. A subset of templates can be returned that match a template type.
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param templateType  (optional)
                * @return List&lt;SmsTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<SmsTemplate> listSmsTemplates(SmsTemplateType templateType) throws RestClientException {
                return listSmsTemplatesWithHttpInfo(templateType).getBody();
            }






            /**
            * List all SMS Templates
            * Lists all custom SMS templates. A subset of templates can be returned that match a template type.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param templateType  (optional)
            * @return ResponseEntity&lt;List&lt;SmsTemplate&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<SmsTemplate>> listSmsTemplatesWithHttpInfo(SmsTemplateType templateType) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "templateType", templateType));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<SmsTemplate>> localReturnType = new ParameterizedTypeReference<List<SmsTemplate>>() {};
            return apiClient.invokeAPI("/api/v1/templates/sms", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all SMS Templates
            * Lists all custom SMS templates. A subset of templates can be returned that match a template type.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param templateType  (optional)
            * @return ResponseEntity&lt;List&lt;SmsTemplate&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listSmsTemplatesWithPaginationInfo(SmsTemplateType templateType) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "templateType", templateType));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<SmsTemplate>> localReturnType = new ParameterizedTypeReference<List<SmsTemplate>>() {};
            ResponseEntity<List<SmsTemplate>> responseEntity = apiClient.invokeAPI("/api/v1/templates/sms", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace an SMS Template
        * Replaces the SMS template
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param templateId  (required)
                * @param smsTemplate  (required)
                * @return SmsTemplate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public SmsTemplate replaceSmsTemplate(String templateId, SmsTemplate smsTemplate) throws RestClientException {
                return replaceSmsTemplateWithHttpInfo(templateId, smsTemplate).getBody();
            }




            /**
            * Replace an SMS Template
            * Replaces the SMS template
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param templateId  (required)
                * @param smsTemplate  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceSmsTemplate(Class<?> T, String templateId, SmsTemplate smsTemplate) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceSmsTemplateWithReturnType(T, templateId, smsTemplate).getBody(), T);
            }




            /**
            * Replace an SMS Template
            * Replaces the SMS template
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param templateId  (required)
                * @param smsTemplate  (required)
            * @return ResponseEntity&lt;SmsTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<SmsTemplate> replaceSmsTemplateWithHttpInfo(String templateId, SmsTemplate smsTemplate) throws RestClientException {
            Object localVarPostBody = smsTemplate;
        
                // verify the required parameter 'templateId' is set ''
                if (templateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling replaceSmsTemplate");
                }
        
                // verify the required parameter 'smsTemplate' is set ''
                if (smsTemplate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling replaceSmsTemplate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("templateId", templateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>() {};
            return apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace an SMS Template
            * Replaces the SMS template
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param templateId  (required)
                * @param smsTemplate  (required)
            * @return ResponseEntity&lt;SmsTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceSmsTemplateWithReturnType(Class<?> T, String templateId,SmsTemplate smsTemplate) throws RestClientException {
            Object localVarPostBody = smsTemplate;
        
                // verify the required parameter 'templateId' is set
                if (templateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling replaceSmsTemplate");
                }
        
                // verify the required parameter 'smsTemplate' is set
                if (smsTemplate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling replaceSmsTemplate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("templateId", templateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace an SMS Template
            * Replaces the SMS template
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param templateId  (required)
                * @param smsTemplate  (required)
            * @return ResponseEntity&lt;SmsTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceSmsTemplateWithPaginationInfo(String templateId, SmsTemplate smsTemplate) throws RestClientException {
            Object localVarPostBody = smsTemplate;
        
                // verify the required parameter 'templateId' is set
                if (templateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling replaceSmsTemplate");
                }
        
                // verify the required parameter 'smsTemplate' is set
                if (smsTemplate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling replaceSmsTemplate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("templateId", templateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>() {};
            ResponseEntity<SmsTemplate> responseEntity = apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Update an SMS Template
        * Updates an SMS template
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param templateId  (required)
                * @param smsTemplate  (required)
                * @return SmsTemplate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public SmsTemplate updateSmsTemplate(String templateId, SmsTemplate smsTemplate) throws RestClientException {
                return updateSmsTemplateWithHttpInfo(templateId, smsTemplate).getBody();
            }




            /**
            * Update an SMS Template
            * Updates an SMS template
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param templateId  (required)
                * @param smsTemplate  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T updateSmsTemplate(Class<?> T, String templateId, SmsTemplate smsTemplate) throws RestClientException {
                return (T) getObjectMapper().convertValue(updateSmsTemplateWithReturnType(T, templateId, smsTemplate).getBody(), T);
            }




            /**
            * Update an SMS Template
            * Updates an SMS template
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param templateId  (required)
                * @param smsTemplate  (required)
            * @return ResponseEntity&lt;SmsTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<SmsTemplate> updateSmsTemplateWithHttpInfo(String templateId, SmsTemplate smsTemplate) throws RestClientException {
            Object localVarPostBody = smsTemplate;
        
                // verify the required parameter 'templateId' is set ''
                if (templateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling updateSmsTemplate");
                }
        
                // verify the required parameter 'smsTemplate' is set ''
                if (smsTemplate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling updateSmsTemplate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("templateId", templateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>() {};
            return apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update an SMS Template
            * Updates an SMS template
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param templateId  (required)
                * @param smsTemplate  (required)
            * @return ResponseEntity&lt;SmsTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> updateSmsTemplateWithReturnType(Class<?> T, String templateId,SmsTemplate smsTemplate) throws RestClientException {
            Object localVarPostBody = smsTemplate;
        
                // verify the required parameter 'templateId' is set
                if (templateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling updateSmsTemplate");
                }
        
                // verify the required parameter 'smsTemplate' is set
                if (smsTemplate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling updateSmsTemplate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("templateId", templateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update an SMS Template
            * Updates an SMS template
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param templateId  (required)
                * @param smsTemplate  (required)
            * @return ResponseEntity&lt;SmsTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList updateSmsTemplateWithPaginationInfo(String templateId, SmsTemplate smsTemplate) throws RestClientException {
            Object localVarPostBody = smsTemplate;
        
                // verify the required parameter 'templateId' is set
                if (templateId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateId' when calling updateSmsTemplate");
                }
        
                // verify the required parameter 'smsTemplate' is set
                if (smsTemplate == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'smsTemplate' when calling updateSmsTemplate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("templateId", templateId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SmsTemplate> localReturnType = new ParameterizedTypeReference<SmsTemplate>() {};
            ResponseEntity<SmsTemplate> responseEntity = apiClient.invokeAPI("/api/v1/templates/sms/{templateId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }


    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
