package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.Error;
import org.openapitools.client.model.LogEvent;
import java.time.OffsetDateTime;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.SystemLogApi")
    public class SystemLogApi {
    private ApiClient apiClient;

    public SystemLogApi() {
    this(new ApiClient());
    }

    @Autowired
    public SystemLogApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * List all System Log Events
        * The Okta System Log API provides read access to your organization’s system log. This API provides more functionality than the Events API
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param since  (optional)
                * @param until  (optional)
                * @param filter  (optional)
                * @param q  (optional)
                * @param limit  (optional, default to 100)
                * @param sortOrder  (optional, default to ASCENDING)
                * @param after  (optional)
                * @return List&lt;LogEvent&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<LogEvent> listLogEvents(OffsetDateTime since, OffsetDateTime until, String filter, String q, Integer limit, String sortOrder, String after) throws RestClientException {
                return listLogEventsWithHttpInfo(since, until, filter, q, limit, sortOrder, after).getBody();
            }






            /**
            * List all System Log Events
            * The Okta System Log API provides read access to your organization’s system log. This API provides more functionality than the Events API
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param since  (optional)
                * @param until  (optional)
                * @param filter  (optional)
                * @param q  (optional)
                * @param limit  (optional, default to 100)
                * @param sortOrder  (optional, default to ASCENDING)
                * @param after  (optional)
            * @return ResponseEntity&lt;List&lt;LogEvent&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<LogEvent>> listLogEventsWithHttpInfo(OffsetDateTime since, OffsetDateTime until, String filter, String q, Integer limit, String sortOrder, String after) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "since", since));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "until", until));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "filter", filter));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sortOrder", sortOrder));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<LogEvent>> localReturnType = new ParameterizedTypeReference<List<LogEvent>>() {};
            return apiClient.invokeAPI("/api/v1/logs", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all System Log Events
            * The Okta System Log API provides read access to your organization’s system log. This API provides more functionality than the Events API
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param since  (optional)
                * @param until  (optional)
                * @param filter  (optional)
                * @param q  (optional)
                * @param limit  (optional, default to 100)
                * @param sortOrder  (optional, default to ASCENDING)
                * @param after  (optional)
            * @return ResponseEntity&lt;List&lt;LogEvent&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listLogEventsWithPaginationInfo(OffsetDateTime since, OffsetDateTime until, String filter, String q, Integer limit, String sortOrder, String after) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "since", since));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "until", until));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "filter", filter));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sortOrder", sortOrder));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<LogEvent>> localReturnType = new ParameterizedTypeReference<List<LogEvent>>() {};
            ResponseEntity<List<LogEvent>> responseEntity = apiClient.invokeAPI("/api/v1/logs", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }


    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
