package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.CreateSessionRequest;
import org.openapitools.client.model.Error;
import org.openapitools.client.model.Session;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.SessionApi")
    public class SessionApi {
    private ApiClient apiClient;

    public SessionApi() {
    this(new ApiClient());
    }

    @Autowired
    public SessionApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Create a Session with Session Token
        * Creates a new session for a user with a valid session token. Use this API if, for example, you want to set the session cookie yourself instead of allowing Okta to set it, or want to hold the session ID in order to delete a session via the API instead of visiting the logout URL.
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param createSessionRequest  (required)
                * @return Session
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Session createSession(CreateSessionRequest createSessionRequest) throws RestClientException {
                return createSessionWithHttpInfo(createSessionRequest).getBody();
            }




            /**
            * Create a Session with Session Token
            * Creates a new session for a user with a valid session token. Use this API if, for example, you want to set the session cookie yourself instead of allowing Okta to set it, or want to hold the session ID in order to delete a session via the API instead of visiting the logout URL.
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param createSessionRequest  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createSession(Class<?> T, CreateSessionRequest createSessionRequest) throws RestClientException {
                return (T) getObjectMapper().convertValue(createSessionWithReturnType(T, createSessionRequest).getBody(), T);
            }




            /**
            * Create a Session with Session Token
            * Creates a new session for a user with a valid session token. Use this API if, for example, you want to set the session cookie yourself instead of allowing Okta to set it, or want to hold the session ID in order to delete a session via the API instead of visiting the logout URL.
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param createSessionRequest  (required)
            * @return ResponseEntity&lt;Session&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Session> createSessionWithHttpInfo(CreateSessionRequest createSessionRequest) throws RestClientException {
            Object localVarPostBody = createSessionRequest;
        
                // verify the required parameter 'createSessionRequest' is set ''
                if (createSessionRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'createSessionRequest' when calling createSession");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken" };

        ParameterizedTypeReference<Session> localReturnType = new ParameterizedTypeReference<Session>() {};
            return apiClient.invokeAPI("/api/v1/sessions", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Session with Session Token
            * Creates a new session for a user with a valid session token. Use this API if, for example, you want to set the session cookie yourself instead of allowing Okta to set it, or want to hold the session ID in order to delete a session via the API instead of visiting the logout URL.
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param createSessionRequest  (required)
            * @return ResponseEntity&lt;Session&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createSessionWithReturnType(Class<?> T, CreateSessionRequest createSessionRequest) throws RestClientException {
            Object localVarPostBody = createSessionRequest;
        
                // verify the required parameter 'createSessionRequest' is set
                if (createSessionRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'createSessionRequest' when calling createSession");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/sessions", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Session with Session Token
            * Creates a new session for a user with a valid session token. Use this API if, for example, you want to set the session cookie yourself instead of allowing Okta to set it, or want to hold the session ID in order to delete a session via the API instead of visiting the logout URL.
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param createSessionRequest  (required)
            * @return ResponseEntity&lt;Session&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createSessionWithPaginationInfo(CreateSessionRequest createSessionRequest) throws RestClientException {
            Object localVarPostBody = createSessionRequest;
        
                // verify the required parameter 'createSessionRequest' is set
                if (createSessionRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'createSessionRequest' when calling createSession");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken" };

        ParameterizedTypeReference<Session> localReturnType = new ParameterizedTypeReference<Session>() {};
            ResponseEntity<Session> responseEntity = apiClient.invokeAPI("/api/v1/sessions", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Session
        * Retrieves the details about a session
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param sessionId  (required)
                * @return Session
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Session getSession(String sessionId) throws RestClientException {
                return getSessionWithHttpInfo(sessionId).getBody();
            }






            /**
            * Retrieve a Session
            * Retrieves the details about a session
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param sessionId  (required)
            * @return ResponseEntity&lt;Session&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Session> getSessionWithHttpInfo(String sessionId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'sessionId' is set ''
                if (sessionId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sessionId' when calling getSession");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("sessionId", sessionId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Session> localReturnType = new ParameterizedTypeReference<Session>() {};
            return apiClient.invokeAPI("/api/v1/sessions/{sessionId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Session
            * Retrieves the details about a session
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param sessionId  (required)
            * @return ResponseEntity&lt;Session&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getSessionWithPaginationInfo(String sessionId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'sessionId' is set
                if (sessionId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sessionId' when calling getSession");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("sessionId", sessionId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Session> localReturnType = new ParameterizedTypeReference<Session>() {};
            ResponseEntity<Session> responseEntity = apiClient.invokeAPI("/api/v1/sessions/{sessionId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Refresh a Session
        * Refresh a session
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param sessionId  (required)
                * @return Session
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Session refreshSession(String sessionId) throws RestClientException {
                return refreshSessionWithHttpInfo(sessionId).getBody();
            }






            /**
            * Refresh a Session
            * Refresh a session
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param sessionId  (required)
            * @return ResponseEntity&lt;Session&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Session> refreshSessionWithHttpInfo(String sessionId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'sessionId' is set ''
                if (sessionId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sessionId' when calling refreshSession");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("sessionId", sessionId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Session> localReturnType = new ParameterizedTypeReference<Session>() {};
            return apiClient.invokeAPI("/api/v1/sessions/{sessionId}/lifecycle/refresh", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Refresh a Session
            * Refresh a session
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param sessionId  (required)
            * @return ResponseEntity&lt;Session&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList refreshSessionWithPaginationInfo(String sessionId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'sessionId' is set
                if (sessionId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sessionId' when calling refreshSession");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("sessionId", sessionId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Session> localReturnType = new ParameterizedTypeReference<Session>() {};
            ResponseEntity<Session> responseEntity = apiClient.invokeAPI("/api/v1/sessions/{sessionId}/lifecycle/refresh", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Revoke a Session
        * Revokes a session
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param sessionId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeSession(String sessionId) throws RestClientException {
            revokeSessionWithHttpInfo(sessionId);
            }






            /**
            * Revoke a Session
            * Revokes a session
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param sessionId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeSessionWithHttpInfo(String sessionId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'sessionId' is set ''
                if (sessionId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sessionId' when calling revokeSession");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("sessionId", sessionId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/sessions/{sessionId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }








    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
