package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.ApplicationLayout;
import org.openapitools.client.model.Error;
import org.openapitools.client.model.GroupSchema;
import org.openapitools.client.model.LogStreamSchema;
import org.openapitools.client.model.LogStreamType;
import org.openapitools.client.model.UserSchema;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.SchemaApi")
    public class SchemaApi {
    private ApiClient apiClient;

    public SchemaApi() {
    this(new ApiClient());
    }

    @Autowired
    public SchemaApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Retrieve the UI Layout for an Application
        * Takes an Application name as an input parameter and retrieves the App Instance page Layout for that Application
            * <p><b>200</b> - successful operation
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appName  (required)
                * @return ApplicationLayout
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ApplicationLayout getApplicationLayout(String appName) throws RestClientException {
                return getApplicationLayoutWithHttpInfo(appName).getBody();
            }






            /**
            * Retrieve the UI Layout for an Application
            * Takes an Application name as an input parameter and retrieves the App Instance page Layout for that Application
                * <p><b>200</b> - successful operation
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appName  (required)
            * @return ResponseEntity&lt;ApplicationLayout&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ApplicationLayout> getApplicationLayoutWithHttpInfo(String appName) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appName' is set ''
                if (appName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling getApplicationLayout");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appName", appName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ApplicationLayout> localReturnType = new ParameterizedTypeReference<ApplicationLayout>() {};
            return apiClient.invokeAPI("/api/v1/meta/layouts/apps/{appName}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the UI Layout for an Application
            * Takes an Application name as an input parameter and retrieves the App Instance page Layout for that Application
                * <p><b>200</b> - successful operation
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appName  (required)
            * @return ResponseEntity&lt;ApplicationLayout&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getApplicationLayoutWithPaginationInfo(String appName) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appName' is set
                if (appName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling getApplicationLayout");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appName", appName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ApplicationLayout> localReturnType = new ParameterizedTypeReference<ApplicationLayout>() {};
            ResponseEntity<ApplicationLayout> responseEntity = apiClient.invokeAPI("/api/v1/meta/layouts/apps/{appName}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the default Application User Schema for an Application
        * Retrieves the Schema for an App User
            * <p><b>200</b> - successful operation
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appInstanceId  (required)
                * @return UserSchema
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public UserSchema getApplicationUserSchema(String appInstanceId) throws RestClientException {
                return getApplicationUserSchemaWithHttpInfo(appInstanceId).getBody();
            }






            /**
            * Retrieve the default Application User Schema for an Application
            * Retrieves the Schema for an App User
                * <p><b>200</b> - successful operation
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appInstanceId  (required)
            * @return ResponseEntity&lt;UserSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<UserSchema> getApplicationUserSchemaWithHttpInfo(String appInstanceId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appInstanceId' is set ''
                if (appInstanceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appInstanceId' when calling getApplicationUserSchema");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appInstanceId", appInstanceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>() {};
            return apiClient.invokeAPI("/api/v1/meta/schemas/apps/{appInstanceId}/default", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the default Application User Schema for an Application
            * Retrieves the Schema for an App User
                * <p><b>200</b> - successful operation
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appInstanceId  (required)
            * @return ResponseEntity&lt;UserSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getApplicationUserSchemaWithPaginationInfo(String appInstanceId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appInstanceId' is set
                if (appInstanceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appInstanceId' when calling getApplicationUserSchema");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appInstanceId", appInstanceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>() {};
            ResponseEntity<UserSchema> responseEntity = apiClient.invokeAPI("/api/v1/meta/schemas/apps/{appInstanceId}/default", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the default Group Schema
        * Retrieves the group schema
            * <p><b>200</b> - successful operation
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @return GroupSchema
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public GroupSchema getGroupSchema() throws RestClientException {
                return getGroupSchemaWithHttpInfo().getBody();
            }






            /**
            * Retrieve the default Group Schema
            * Retrieves the group schema
                * <p><b>200</b> - successful operation
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;GroupSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<GroupSchema> getGroupSchemaWithHttpInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<GroupSchema> localReturnType = new ParameterizedTypeReference<GroupSchema>() {};
            return apiClient.invokeAPI("/api/v1/meta/schemas/group/default", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the default Group Schema
            * Retrieves the group schema
                * <p><b>200</b> - successful operation
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;GroupSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getGroupSchemaWithPaginationInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<GroupSchema> localReturnType = new ParameterizedTypeReference<GroupSchema>() {};
            ResponseEntity<GroupSchema> responseEntity = apiClient.invokeAPI("/api/v1/meta/schemas/group/default", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the Log Stream Schema for the schema type
        * Retrieves the schema for a Log Stream type. The &#x60;logStreamType&#x60; element in the URL specifies the Log Stream type, which is either &#x60;aws_eventbridge&#x60; or &#x60;splunk_cloud_logstreaming&#x60;. Use the &#x60;aws_eventbridge&#x60; literal to retrieve the AWS EventBridge type schema, and use the &#x60;splunk_cloud_logstreaming&#x60; literal retrieve the Splunk Cloud type schema.
            * <p><b>200</b> - successful operation
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param logStreamType  (required)
                * @return LogStreamSchema
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public LogStreamSchema getLogStreamSchema(LogStreamType logStreamType) throws RestClientException {
                return getLogStreamSchemaWithHttpInfo(logStreamType).getBody();
            }






            /**
            * Retrieve the Log Stream Schema for the schema type
            * Retrieves the schema for a Log Stream type. The &#x60;logStreamType&#x60; element in the URL specifies the Log Stream type, which is either &#x60;aws_eventbridge&#x60; or &#x60;splunk_cloud_logstreaming&#x60;. Use the &#x60;aws_eventbridge&#x60; literal to retrieve the AWS EventBridge type schema, and use the &#x60;splunk_cloud_logstreaming&#x60; literal retrieve the Splunk Cloud type schema.
                * <p><b>200</b> - successful operation
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param logStreamType  (required)
            * @return ResponseEntity&lt;LogStreamSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<LogStreamSchema> getLogStreamSchemaWithHttpInfo(LogStreamType logStreamType) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'logStreamType' is set ''
                if (logStreamType == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'logStreamType' when calling getLogStreamSchema");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("logStreamType", logStreamType);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<LogStreamSchema> localReturnType = new ParameterizedTypeReference<LogStreamSchema>() {};
            return apiClient.invokeAPI("/api/v1/meta/schemas/logStream/{logStreamType}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the Log Stream Schema for the schema type
            * Retrieves the schema for a Log Stream type. The &#x60;logStreamType&#x60; element in the URL specifies the Log Stream type, which is either &#x60;aws_eventbridge&#x60; or &#x60;splunk_cloud_logstreaming&#x60;. Use the &#x60;aws_eventbridge&#x60; literal to retrieve the AWS EventBridge type schema, and use the &#x60;splunk_cloud_logstreaming&#x60; literal retrieve the Splunk Cloud type schema.
                * <p><b>200</b> - successful operation
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param logStreamType  (required)
            * @return ResponseEntity&lt;LogStreamSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getLogStreamSchemaWithPaginationInfo(LogStreamType logStreamType) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'logStreamType' is set
                if (logStreamType == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'logStreamType' when calling getLogStreamSchema");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("logStreamType", logStreamType);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<LogStreamSchema> localReturnType = new ParameterizedTypeReference<LogStreamSchema>() {};
            ResponseEntity<LogStreamSchema> responseEntity = apiClient.invokeAPI("/api/v1/meta/schemas/logStream/{logStreamType}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a User Schema
        * Retrieves the schema for a Schema Id
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param schemaId  (required)
                * @return UserSchema
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public UserSchema getUserSchema(String schemaId) throws RestClientException {
                return getUserSchemaWithHttpInfo(schemaId).getBody();
            }






            /**
            * Retrieve a User Schema
            * Retrieves the schema for a Schema Id
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param schemaId  (required)
            * @return ResponseEntity&lt;UserSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<UserSchema> getUserSchemaWithHttpInfo(String schemaId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'schemaId' is set ''
                if (schemaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'schemaId' when calling getUserSchema");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("schemaId", schemaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>() {};
            return apiClient.invokeAPI("/api/v1/meta/schemas/user/{schemaId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a User Schema
            * Retrieves the schema for a Schema Id
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param schemaId  (required)
            * @return ResponseEntity&lt;UserSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getUserSchemaWithPaginationInfo(String schemaId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'schemaId' is set
                if (schemaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'schemaId' when calling getUserSchema");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("schemaId", schemaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>() {};
            ResponseEntity<UserSchema> responseEntity = apiClient.invokeAPI("/api/v1/meta/schemas/user/{schemaId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List the Log Stream Schemas
        * Lists the schema for all log stream types visible for this org
            * <p><b>200</b> - successful operation
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @return List&lt;LogStreamSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<LogStreamSchema> listLogStreamSchemas() throws RestClientException {
                return listLogStreamSchemasWithHttpInfo().getBody();
            }






            /**
            * List the Log Stream Schemas
            * Lists the schema for all log stream types visible for this org
                * <p><b>200</b> - successful operation
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;List&lt;LogStreamSchema&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<LogStreamSchema>> listLogStreamSchemasWithHttpInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<LogStreamSchema>> localReturnType = new ParameterizedTypeReference<List<LogStreamSchema>>() {};
            return apiClient.invokeAPI("/api/v1/meta/schemas/logStream", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List the Log Stream Schemas
            * Lists the schema for all log stream types visible for this org
                * <p><b>200</b> - successful operation
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;List&lt;LogStreamSchema&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listLogStreamSchemasWithPaginationInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<LogStreamSchema>> localReturnType = new ParameterizedTypeReference<List<LogStreamSchema>>() {};
            ResponseEntity<List<LogStreamSchema>> responseEntity = apiClient.invokeAPI("/api/v1/meta/schemas/logStream", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Update the default Application User Schema for an Application
        * Partial updates on the User Profile properties of the Application User Schema
            * <p><b>200</b> - successful operation
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appInstanceId  (required)
                * @param body  (optional)
                * @return UserSchema
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public UserSchema updateApplicationUserProfile(String appInstanceId, UserSchema body) throws RestClientException {
                return updateApplicationUserProfileWithHttpInfo(appInstanceId, body).getBody();
            }




            /**
            * Update the default Application User Schema for an Application
            * Partial updates on the User Profile properties of the Application User Schema
                * <p><b>200</b> - successful operation
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param appInstanceId  (required)
                * @param body  (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T updateApplicationUserProfile(Class<?> T, String appInstanceId, UserSchema body) throws RestClientException {
                return (T) getObjectMapper().convertValue(updateApplicationUserProfileWithReturnType(T, appInstanceId, body).getBody(), T);
            }




            /**
            * Update the default Application User Schema for an Application
            * Partial updates on the User Profile properties of the Application User Schema
                * <p><b>200</b> - successful operation
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appInstanceId  (required)
                * @param body  (optional)
            * @return ResponseEntity&lt;UserSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<UserSchema> updateApplicationUserProfileWithHttpInfo(String appInstanceId, UserSchema body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'appInstanceId' is set ''
                if (appInstanceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appInstanceId' when calling updateApplicationUserProfile");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appInstanceId", appInstanceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>() {};
            return apiClient.invokeAPI("/api/v1/meta/schemas/apps/{appInstanceId}/default", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update the default Application User Schema for an Application
            * Partial updates on the User Profile properties of the Application User Schema
                * <p><b>200</b> - successful operation
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appInstanceId  (required)
                * @param body  (optional)
            * @return ResponseEntity&lt;UserSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> updateApplicationUserProfileWithReturnType(Class<?> T, String appInstanceId,UserSchema body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'appInstanceId' is set
                if (appInstanceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appInstanceId' when calling updateApplicationUserProfile");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appInstanceId", appInstanceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/meta/schemas/apps/{appInstanceId}/default", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update the default Application User Schema for an Application
            * Partial updates on the User Profile properties of the Application User Schema
                * <p><b>200</b> - successful operation
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appInstanceId  (required)
                * @param body  (optional)
            * @return ResponseEntity&lt;UserSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList updateApplicationUserProfileWithPaginationInfo(String appInstanceId, UserSchema body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'appInstanceId' is set
                if (appInstanceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appInstanceId' when calling updateApplicationUserProfile");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appInstanceId", appInstanceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>() {};
            ResponseEntity<UserSchema> responseEntity = apiClient.invokeAPI("/api/v1/meta/schemas/apps/{appInstanceId}/default", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Update the default Group Schema
        * Updates, adds or removes one or more custom Group Profile properties in the schema
            * <p><b>200</b> - successful operation
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param groupSchema  (optional)
                * @return GroupSchema
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public GroupSchema updateGroupSchema(GroupSchema groupSchema) throws RestClientException {
                return updateGroupSchemaWithHttpInfo(groupSchema).getBody();
            }




            /**
            * Update the default Group Schema
            * Updates, adds or removes one or more custom Group Profile properties in the schema
                * <p><b>200</b> - successful operation
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param groupSchema  (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T updateGroupSchema(Class<?> T, GroupSchema groupSchema) throws RestClientException {
                return (T) getObjectMapper().convertValue(updateGroupSchemaWithReturnType(T, groupSchema).getBody(), T);
            }




            /**
            * Update the default Group Schema
            * Updates, adds or removes one or more custom Group Profile properties in the schema
                * <p><b>200</b> - successful operation
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param groupSchema  (optional)
            * @return ResponseEntity&lt;GroupSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<GroupSchema> updateGroupSchemaWithHttpInfo(GroupSchema groupSchema) throws RestClientException {
            Object localVarPostBody = groupSchema;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<GroupSchema> localReturnType = new ParameterizedTypeReference<GroupSchema>() {};
            return apiClient.invokeAPI("/api/v1/meta/schemas/group/default", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update the default Group Schema
            * Updates, adds or removes one or more custom Group Profile properties in the schema
                * <p><b>200</b> - successful operation
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param groupSchema  (optional)
            * @return ResponseEntity&lt;GroupSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> updateGroupSchemaWithReturnType(Class<?> T, GroupSchema groupSchema) throws RestClientException {
            Object localVarPostBody = groupSchema;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/meta/schemas/group/default", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update the default Group Schema
            * Updates, adds or removes one or more custom Group Profile properties in the schema
                * <p><b>200</b> - successful operation
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param groupSchema  (optional)
            * @return ResponseEntity&lt;GroupSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList updateGroupSchemaWithPaginationInfo(GroupSchema groupSchema) throws RestClientException {
            Object localVarPostBody = groupSchema;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<GroupSchema> localReturnType = new ParameterizedTypeReference<GroupSchema>() {};
            ResponseEntity<GroupSchema> responseEntity = apiClient.invokeAPI("/api/v1/meta/schemas/group/default", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Update a User Schema
        * Partial updates on the User Profile properties of the user schema
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param schemaId  (required)
                * @param userSchema  (required)
                * @return UserSchema
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public UserSchema updateUserProfile(String schemaId, UserSchema userSchema) throws RestClientException {
                return updateUserProfileWithHttpInfo(schemaId, userSchema).getBody();
            }




            /**
            * Update a User Schema
            * Partial updates on the User Profile properties of the user schema
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param schemaId  (required)
                * @param userSchema  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T updateUserProfile(Class<?> T, String schemaId, UserSchema userSchema) throws RestClientException {
                return (T) getObjectMapper().convertValue(updateUserProfileWithReturnType(T, schemaId, userSchema).getBody(), T);
            }




            /**
            * Update a User Schema
            * Partial updates on the User Profile properties of the user schema
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param schemaId  (required)
                * @param userSchema  (required)
            * @return ResponseEntity&lt;UserSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<UserSchema> updateUserProfileWithHttpInfo(String schemaId, UserSchema userSchema) throws RestClientException {
            Object localVarPostBody = userSchema;
        
                // verify the required parameter 'schemaId' is set ''
                if (schemaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'schemaId' when calling updateUserProfile");
                }
        
                // verify the required parameter 'userSchema' is set ''
                if (userSchema == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userSchema' when calling updateUserProfile");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("schemaId", schemaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>() {};
            return apiClient.invokeAPI("/api/v1/meta/schemas/user/{schemaId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update a User Schema
            * Partial updates on the User Profile properties of the user schema
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param schemaId  (required)
                * @param userSchema  (required)
            * @return ResponseEntity&lt;UserSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> updateUserProfileWithReturnType(Class<?> T, String schemaId,UserSchema userSchema) throws RestClientException {
            Object localVarPostBody = userSchema;
        
                // verify the required parameter 'schemaId' is set
                if (schemaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'schemaId' when calling updateUserProfile");
                }
        
                // verify the required parameter 'userSchema' is set
                if (userSchema == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userSchema' when calling updateUserProfile");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("schemaId", schemaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/meta/schemas/user/{schemaId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update a User Schema
            * Partial updates on the User Profile properties of the user schema
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param schemaId  (required)
                * @param userSchema  (required)
            * @return ResponseEntity&lt;UserSchema&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList updateUserProfileWithPaginationInfo(String schemaId, UserSchema userSchema) throws RestClientException {
            Object localVarPostBody = userSchema;
        
                // verify the required parameter 'schemaId' is set
                if (schemaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'schemaId' when calling updateUserProfile");
                }
        
                // verify the required parameter 'userSchema' is set
                if (userSchema == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userSchema' when calling updateUserProfile");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("schemaId", schemaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<UserSchema> localReturnType = new ParameterizedTypeReference<UserSchema>() {};
            ResponseEntity<UserSchema> responseEntity = apiClient.invokeAPI("/api/v1/meta/schemas/user/{schemaId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }


    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
