package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.CatalogApplication;
import org.openapitools.client.model.Error;
import org.openapitools.client.model.Group;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.RoleTargetApi")
    public class RoleTargetApi {
    private ApiClient apiClient;

    public RoleTargetApi() {
    this(new ApiClient());
    }

    @Autowired
    public RoleTargetApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Assign all Apps as Target to Role
        * Assigns all Apps as Target to Role
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void assignAllAppsAsTargetToRoleForUser(String userId, String roleId) throws RestClientException {
            assignAllAppsAsTargetToRoleForUserWithHttpInfo(userId, roleId);
            }






            /**
            * Assign all Apps as Target to Role
            * Assigns all Apps as Target to Role
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> assignAllAppsAsTargetToRoleForUserWithHttpInfo(String userId, String roleId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling assignAllAppsAsTargetToRoleForUser");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignAllAppsAsTargetToRoleForUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Assign an Application Instance Target to Application Administrator Role
        * Assigns App Instance Target to App Administrator Role given to a Group
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param appName  (required)
                * @param applicationId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void assignAppInstanceTargetToAppAdminRoleForGroup(String groupId, String roleId, String appName, String applicationId) throws RestClientException {
            assignAppInstanceTargetToAppAdminRoleForGroupWithHttpInfo(groupId, roleId, appName, applicationId);
            }






            /**
            * Assign an Application Instance Target to Application Administrator Role
            * Assigns App Instance Target to App Administrator Role given to a Group
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param appName  (required)
                * @param applicationId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> assignAppInstanceTargetToAppAdminRoleForGroupWithHttpInfo(String groupId, String roleId, String appName, String applicationId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
                }
        
                // verify the required parameter 'appName' is set ''
                if (appName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
                }
        
                // verify the required parameter 'applicationId' is set ''
                if (applicationId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'applicationId' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);
                    uriVariables.put("roleId", roleId);
                    uriVariables.put("appName", appName);
                    uriVariables.put("applicationId", applicationId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Assign an Application Instance Target to an Application Administrator Role
        * Assigns anapplication instance target to appplication administrator role
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param appName  (required)
                * @param applicationId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void assignAppInstanceTargetToAppAdminRoleForUser(String userId, String roleId, String appName, String applicationId) throws RestClientException {
            assignAppInstanceTargetToAppAdminRoleForUserWithHttpInfo(userId, roleId, appName, applicationId);
            }






            /**
            * Assign an Application Instance Target to an Application Administrator Role
            * Assigns anapplication instance target to appplication administrator role
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param appName  (required)
                * @param applicationId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> assignAppInstanceTargetToAppAdminRoleForUserWithHttpInfo(String userId, String roleId, String appName, String applicationId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
                }
        
                // verify the required parameter 'appName' is set ''
                if (appName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling assignAppInstanceTargetToAppAdminRoleForUser");
                }
        
                // verify the required parameter 'applicationId' is set ''
                if (applicationId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'applicationId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);
                    uriVariables.put("appName", appName);
                    uriVariables.put("applicationId", applicationId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Assign an Application Target to Administrator Role
        * Assigns an application target to administrator role
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param appName  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void assignAppTargetToAdminRoleForGroup(String groupId, String roleId, String appName) throws RestClientException {
            assignAppTargetToAdminRoleForGroupWithHttpInfo(groupId, roleId, appName);
            }






            /**
            * Assign an Application Target to Administrator Role
            * Assigns an application target to administrator role
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param appName  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> assignAppTargetToAdminRoleForGroupWithHttpInfo(String groupId, String roleId, String appName) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignAppTargetToAdminRoleForGroup");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignAppTargetToAdminRoleForGroup");
                }
        
                // verify the required parameter 'appName' is set ''
                if (appName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling assignAppTargetToAdminRoleForGroup");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);
                    uriVariables.put("roleId", roleId);
                    uriVariables.put("appName", appName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Assign an Application Target to Administrator Role
        * Assigns an application target to administrator role
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param appName  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void assignAppTargetToAdminRoleForUser(String userId, String roleId, String appName) throws RestClientException {
            assignAppTargetToAdminRoleForUserWithHttpInfo(userId, roleId, appName);
            }






            /**
            * Assign an Application Target to Administrator Role
            * Assigns an application target to administrator role
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param appName  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> assignAppTargetToAdminRoleForUserWithHttpInfo(String userId, String roleId, String appName) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling assignAppTargetToAdminRoleForUser");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignAppTargetToAdminRoleForUser");
                }
        
                // verify the required parameter 'appName' is set ''
                if (appName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling assignAppTargetToAdminRoleForUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);
                    uriVariables.put("appName", appName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Assign a Group Target to a Group Role
        * Assigns a group target to a group role
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param targetGroupId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void assignGroupTargetToGroupAdminRole(String groupId, String roleId, String targetGroupId) throws RestClientException {
            assignGroupTargetToGroupAdminRoleWithHttpInfo(groupId, roleId, targetGroupId);
            }






            /**
            * Assign a Group Target to a Group Role
            * Assigns a group target to a group role
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param targetGroupId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> assignGroupTargetToGroupAdminRoleWithHttpInfo(String groupId, String roleId, String targetGroupId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignGroupTargetToGroupAdminRole");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignGroupTargetToGroupAdminRole");
                }
        
                // verify the required parameter 'targetGroupId' is set ''
                if (targetGroupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'targetGroupId' when calling assignGroupTargetToGroupAdminRole");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);
                    uriVariables.put("roleId", roleId);
                    uriVariables.put("targetGroupId", targetGroupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/groups/{targetGroupId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Assign a Group Target to Role
        * Assigns a Group Target to Role
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param groupId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void assignGroupTargetToUserRole(String userId, String roleId, String groupId) throws RestClientException {
            assignGroupTargetToUserRoleWithHttpInfo(userId, roleId, groupId);
            }






            /**
            * Assign a Group Target to Role
            * Assigns a Group Target to Role
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param groupId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> assignGroupTargetToUserRoleWithHttpInfo(String userId, String roleId, String groupId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling assignGroupTargetToUserRole");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling assignGroupTargetToUserRole");
                }
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignGroupTargetToUserRole");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);
                    uriVariables.put("groupId", groupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * List all Application Targets for an Application Administrator Role
        * Lists all App targets for an &#x60;APP_ADMIN&#x60; Role assigned to a Group. This methods return list may include full Applications or Instances. The response for an instance will have an &#x60;ID&#x60; value, while Application will not have an ID.
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
                * @return List&lt;CatalogApplication&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForGroup(String groupId, String roleId, String after, Integer limit) throws RestClientException {
                return listApplicationTargetsForApplicationAdministratorRoleForGroupWithHttpInfo(groupId, roleId, after, limit).getBody();
            }






            /**
            * List all Application Targets for an Application Administrator Role
            * Lists all App targets for an &#x60;APP_ADMIN&#x60; Role assigned to a Group. This methods return list may include full Applications or Instances. The response for an instance will have an &#x60;ID&#x60; value, while Application will not have an ID.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;CatalogApplication&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<CatalogApplication>> listApplicationTargetsForApplicationAdministratorRoleForGroupWithHttpInfo(String groupId, String roleId, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling listApplicationTargetsForApplicationAdministratorRoleForGroup");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listApplicationTargetsForApplicationAdministratorRoleForGroup");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<CatalogApplication>> localReturnType = new ParameterizedTypeReference<List<CatalogApplication>>() {};
            return apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Application Targets for an Application Administrator Role
            * Lists all App targets for an &#x60;APP_ADMIN&#x60; Role assigned to a Group. This methods return list may include full Applications or Instances. The response for an instance will have an &#x60;ID&#x60; value, while Application will not have an ID.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;CatalogApplication&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listApplicationTargetsForApplicationAdministratorRoleForGroupWithPaginationInfo(String groupId, String roleId, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling listApplicationTargetsForApplicationAdministratorRoleForGroup");
                }
        
                // verify the required parameter 'roleId' is set
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listApplicationTargetsForApplicationAdministratorRoleForGroup");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<CatalogApplication>> localReturnType = new ParameterizedTypeReference<List<CatalogApplication>>() {};
            ResponseEntity<List<CatalogApplication>> responseEntity = apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Application Targets for Application Administrator Role
        * Lists all App targets for an &#x60;APP_ADMIN&#x60; Role assigned to a User. This methods return list may include full Applications or Instances. The response for an instance will have an &#x60;ID&#x60; value, while Application will not have an ID.
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
                * @return List&lt;CatalogApplication&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForUser(String userId, String roleId, String after, Integer limit) throws RestClientException {
                return listApplicationTargetsForApplicationAdministratorRoleForUserWithHttpInfo(userId, roleId, after, limit).getBody();
            }






            /**
            * List all Application Targets for Application Administrator Role
            * Lists all App targets for an &#x60;APP_ADMIN&#x60; Role assigned to a User. This methods return list may include full Applications or Instances. The response for an instance will have an &#x60;ID&#x60; value, while Application will not have an ID.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;CatalogApplication&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<CatalogApplication>> listApplicationTargetsForApplicationAdministratorRoleForUserWithHttpInfo(String userId, String roleId, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<CatalogApplication>> localReturnType = new ParameterizedTypeReference<List<CatalogApplication>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Application Targets for Application Administrator Role
            * Lists all App targets for an &#x60;APP_ADMIN&#x60; Role assigned to a User. This methods return list may include full Applications or Instances. The response for an instance will have an &#x60;ID&#x60; value, while Application will not have an ID.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;CatalogApplication&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listApplicationTargetsForApplicationAdministratorRoleForUserWithPaginationInfo(String userId, String roleId, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
                }
        
                // verify the required parameter 'roleId' is set
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<CatalogApplication>> localReturnType = new ParameterizedTypeReference<List<CatalogApplication>>() {};
            ResponseEntity<List<CatalogApplication>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Group Targets for a Group Role
        * Lists all group targets for a group role
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
                * @return List&lt;Group&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<Group> listGroupTargetsForGroupRole(String groupId, String roleId, String after, Integer limit) throws RestClientException {
                return listGroupTargetsForGroupRoleWithHttpInfo(groupId, roleId, after, limit).getBody();
            }






            /**
            * List all Group Targets for a Group Role
            * Lists all group targets for a group role
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;Group&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<Group>> listGroupTargetsForGroupRoleWithHttpInfo(String groupId, String roleId, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling listGroupTargetsForGroupRole");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listGroupTargetsForGroupRole");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Group>> localReturnType = new ParameterizedTypeReference<List<Group>>() {};
            return apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/groups", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Group Targets for a Group Role
            * Lists all group targets for a group role
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;Group&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listGroupTargetsForGroupRoleWithPaginationInfo(String groupId, String roleId, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling listGroupTargetsForGroupRole");
                }
        
                // verify the required parameter 'roleId' is set
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listGroupTargetsForGroupRole");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Group>> localReturnType = new ParameterizedTypeReference<List<Group>>() {};
            ResponseEntity<List<Group>> responseEntity = apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/groups", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Group Targets for Role
        * Lists all group targets for role
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
                * @return List&lt;Group&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<Group> listGroupTargetsForRole(String userId, String roleId, String after, Integer limit) throws RestClientException {
                return listGroupTargetsForRoleWithHttpInfo(userId, roleId, after, limit).getBody();
            }






            /**
            * List all Group Targets for Role
            * Lists all group targets for role
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;Group&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<Group>> listGroupTargetsForRoleWithHttpInfo(String userId, String roleId, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listGroupTargetsForRole");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listGroupTargetsForRole");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Group>> localReturnType = new ParameterizedTypeReference<List<Group>>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/groups", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Group Targets for Role
            * Lists all group targets for role
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;Group&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listGroupTargetsForRoleWithPaginationInfo(String userId, String roleId, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling listGroupTargetsForRole");
                }
        
                // verify the required parameter 'roleId' is set
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling listGroupTargetsForRole");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Group>> localReturnType = new ParameterizedTypeReference<List<Group>>() {};
            ResponseEntity<List<Group>> responseEntity = apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/groups", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Unassign an Application Instance Target from an Application Administrator Role
        * Unassigns an application instance target from an application administrator role
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param appName  (required)
                * @param applicationId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unassignAppInstanceTargetFromAdminRoleForUser(String userId, String roleId, String appName, String applicationId) throws RestClientException {
            unassignAppInstanceTargetFromAdminRoleForUserWithHttpInfo(userId, roleId, appName, applicationId);
            }






            /**
            * Unassign an Application Instance Target from an Application Administrator Role
            * Unassigns an application instance target from an application administrator role
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param appName  (required)
                * @param applicationId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unassignAppInstanceTargetFromAdminRoleForUserWithHttpInfo(String userId, String roleId, String appName, String applicationId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
                }
        
                // verify the required parameter 'appName' is set ''
                if (appName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling unassignAppInstanceTargetFromAdminRoleForUser");
                }
        
                // verify the required parameter 'applicationId' is set ''
                if (applicationId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'applicationId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);
                    uriVariables.put("appName", appName);
                    uriVariables.put("applicationId", applicationId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Unassign an Application Instance Target from an Application Administrator Role
        * Unassigns an application instance target from application administrator role
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param appName  (required)
                * @param applicationId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unassignAppInstanceTargetToAppAdminRoleForGroup(String groupId, String roleId, String appName, String applicationId) throws RestClientException {
            unassignAppInstanceTargetToAppAdminRoleForGroupWithHttpInfo(groupId, roleId, appName, applicationId);
            }






            /**
            * Unassign an Application Instance Target from an Application Administrator Role
            * Unassigns an application instance target from application administrator role
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param appName  (required)
                * @param applicationId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unassignAppInstanceTargetToAppAdminRoleForGroupWithHttpInfo(String groupId, String roleId, String appName, String applicationId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
                }
        
                // verify the required parameter 'appName' is set ''
                if (appName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
                }
        
                // verify the required parameter 'applicationId' is set ''
                if (applicationId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'applicationId' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);
                    uriVariables.put("roleId", roleId);
                    uriVariables.put("appName", appName);
                    uriVariables.put("applicationId", applicationId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}/{applicationId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Unassign an Application Target from an Application Administrator Role
        * Unassigns an application target from application administrator role
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param appName  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unassignAppTargetFromAppAdminRoleForUser(String userId, String roleId, String appName) throws RestClientException {
            unassignAppTargetFromAppAdminRoleForUserWithHttpInfo(userId, roleId, appName);
            }






            /**
            * Unassign an Application Target from an Application Administrator Role
            * Unassigns an application target from application administrator role
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param appName  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unassignAppTargetFromAppAdminRoleForUserWithHttpInfo(String userId, String roleId, String appName) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling unassignAppTargetFromAppAdminRoleForUser");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignAppTargetFromAppAdminRoleForUser");
                }
        
                // verify the required parameter 'appName' is set ''
                if (appName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling unassignAppTargetFromAppAdminRoleForUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);
                    uriVariables.put("appName", appName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Unassign an Application Target from Application Administrator Role
        * Unassigns an application target from application administrator role
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param appName  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unassignAppTargetToAdminRoleForGroup(String groupId, String roleId, String appName) throws RestClientException {
            unassignAppTargetToAdminRoleForGroupWithHttpInfo(groupId, roleId, appName);
            }






            /**
            * Unassign an Application Target from Application Administrator Role
            * Unassigns an application target from application administrator role
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param appName  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unassignAppTargetToAdminRoleForGroupWithHttpInfo(String groupId, String roleId, String appName) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling unassignAppTargetToAdminRoleForGroup");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignAppTargetToAdminRoleForGroup");
                }
        
                // verify the required parameter 'appName' is set ''
                if (appName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appName' when calling unassignAppTargetToAdminRoleForGroup");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);
                    uriVariables.put("roleId", roleId);
                    uriVariables.put("appName", appName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Unassign a Group Target from a Group Role
        * Unassigns a group target from a group role
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param targetGroupId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unassignGroupTargetFromGroupAdminRole(String groupId, String roleId, String targetGroupId) throws RestClientException {
            unassignGroupTargetFromGroupAdminRoleWithHttpInfo(groupId, roleId, targetGroupId);
            }






            /**
            * Unassign a Group Target from a Group Role
            * Unassigns a group target from a group role
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param groupId  (required)
                * @param roleId  (required)
                * @param targetGroupId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unassignGroupTargetFromGroupAdminRoleWithHttpInfo(String groupId, String roleId, String targetGroupId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling unassignGroupTargetFromGroupAdminRole");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignGroupTargetFromGroupAdminRole");
                }
        
                // verify the required parameter 'targetGroupId' is set ''
                if (targetGroupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'targetGroupId' when calling unassignGroupTargetFromGroupAdminRole");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("groupId", groupId);
                    uriVariables.put("roleId", roleId);
                    uriVariables.put("targetGroupId", targetGroupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/groups/{groupId}/roles/{roleId}/targets/groups/{targetGroupId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Unassign a Group Target from Role
        * Unassigns a Group Target from Role
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param groupId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unassignGroupTargetFromUserAdminRole(String userId, String roleId, String groupId) throws RestClientException {
            unassignGroupTargetFromUserAdminRoleWithHttpInfo(userId, roleId, groupId);
            }






            /**
            * Unassign a Group Target from Role
            * Unassigns a Group Target from Role
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param userId  (required)
                * @param roleId  (required)
                * @param groupId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unassignGroupTargetFromUserAdminRoleWithHttpInfo(String userId, String roleId, String groupId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling unassignGroupTargetFromUserAdminRole");
                }
        
                // verify the required parameter 'roleId' is set ''
                if (roleId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'roleId' when calling unassignGroupTargetFromUserAdminRole");
                }
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling unassignGroupTargetFromUserAdminRole");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("userId", userId);
                    uriVariables.put("roleId", roleId);
                    uriVariables.put("groupId", groupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }








    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
