package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.Error;
import org.openapitools.client.model.ProviderType;
import org.openapitools.client.model.PushProvider;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.PushProviderApi")
    public class PushProviderApi {
    private ApiClient apiClient;

    public PushProviderApi() {
    this(new ApiClient());
    }

    @Autowired
    public PushProviderApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Create a Push Provider
        * Creates a new push provider
            * <p><b>200</b> - OK
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param pushProvider  (required)
                * @return PushProvider
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PushProvider createPushProvider(PushProvider pushProvider) throws RestClientException {
                return createPushProviderWithHttpInfo(pushProvider).getBody();
            }




            /**
            * Create a Push Provider
            * Creates a new push provider
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param pushProvider  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createPushProvider(Class<?> T, PushProvider pushProvider) throws RestClientException {
                return (T) getObjectMapper().convertValue(createPushProviderWithReturnType(T, pushProvider).getBody(), T);
            }




            /**
            * Create a Push Provider
            * Creates a new push provider
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param pushProvider  (required)
            * @return ResponseEntity&lt;PushProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<PushProvider> createPushProviderWithHttpInfo(PushProvider pushProvider) throws RestClientException {
            Object localVarPostBody = pushProvider;
        
                // verify the required parameter 'pushProvider' is set ''
                if (pushProvider == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pushProvider' when calling createPushProvider");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PushProvider> localReturnType = new ParameterizedTypeReference<PushProvider>() {};
            return apiClient.invokeAPI("/api/v1/push-providers", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Push Provider
            * Creates a new push provider
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param pushProvider  (required)
            * @return ResponseEntity&lt;PushProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createPushProviderWithReturnType(Class<?> T, PushProvider pushProvider) throws RestClientException {
            Object localVarPostBody = pushProvider;
        
                // verify the required parameter 'pushProvider' is set
                if (pushProvider == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pushProvider' when calling createPushProvider");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/push-providers", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Push Provider
            * Creates a new push provider
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param pushProvider  (required)
            * @return ResponseEntity&lt;PushProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createPushProviderWithPaginationInfo(PushProvider pushProvider) throws RestClientException {
            Object localVarPostBody = pushProvider;
        
                // verify the required parameter 'pushProvider' is set
                if (pushProvider == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pushProvider' when calling createPushProvider");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PushProvider> localReturnType = new ParameterizedTypeReference<PushProvider>() {};
            ResponseEntity<PushProvider> responseEntity = apiClient.invokeAPI("/api/v1/push-providers", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Delete a Push Provider
        * Deletes a push provider by &#x60;pushProviderId&#x60;. If the push provider is currently being used in the org by a custom authenticator, the delete will not be allowed.
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>409</b> - Conflict
            * <p><b>429</b> - Too Many Requests
                * @param pushProviderId Id of the push provider (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deletePushProvider(String pushProviderId) throws RestClientException {
            deletePushProviderWithHttpInfo(pushProviderId);
            }






            /**
            * Delete a Push Provider
            * Deletes a push provider by &#x60;pushProviderId&#x60;. If the push provider is currently being used in the org by a custom authenticator, the delete will not be allowed.
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Conflict
                * <p><b>429</b> - Too Many Requests
                * @param pushProviderId Id of the push provider (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deletePushProviderWithHttpInfo(String pushProviderId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'pushProviderId' is set ''
                if (pushProviderId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pushProviderId' when calling deletePushProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("pushProviderId", pushProviderId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/push-providers/{pushProviderId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Retrieve a Push Provider
        * Retrieves a push provider by &#x60;pushProviderId&#x60;
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param pushProviderId Id of the push provider (required)
                * @return PushProvider
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PushProvider getPushProvider(String pushProviderId) throws RestClientException {
                return getPushProviderWithHttpInfo(pushProviderId).getBody();
            }






            /**
            * Retrieve a Push Provider
            * Retrieves a push provider by &#x60;pushProviderId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param pushProviderId Id of the push provider (required)
            * @return ResponseEntity&lt;PushProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<PushProvider> getPushProviderWithHttpInfo(String pushProviderId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'pushProviderId' is set ''
                if (pushProviderId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pushProviderId' when calling getPushProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("pushProviderId", pushProviderId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PushProvider> localReturnType = new ParameterizedTypeReference<PushProvider>() {};
            return apiClient.invokeAPI("/api/v1/push-providers/{pushProviderId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Push Provider
            * Retrieves a push provider by &#x60;pushProviderId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param pushProviderId Id of the push provider (required)
            * @return ResponseEntity&lt;PushProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getPushProviderWithPaginationInfo(String pushProviderId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'pushProviderId' is set
                if (pushProviderId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pushProviderId' when calling getPushProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("pushProviderId", pushProviderId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PushProvider> localReturnType = new ParameterizedTypeReference<PushProvider>() {};
            ResponseEntity<PushProvider> responseEntity = apiClient.invokeAPI("/api/v1/push-providers/{pushProviderId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Push Providers
        * Lists all push providers
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param type Filters push providers by &#x60;providerType&#x60; (optional)
                * @return List&lt;PushProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<PushProvider> listPushProviders(ProviderType type) throws RestClientException {
                return listPushProvidersWithHttpInfo(type).getBody();
            }






            /**
            * List all Push Providers
            * Lists all push providers
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param type Filters push providers by &#x60;providerType&#x60; (optional)
            * @return ResponseEntity&lt;List&lt;PushProvider&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<PushProvider>> listPushProvidersWithHttpInfo(ProviderType type) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<PushProvider>> localReturnType = new ParameterizedTypeReference<List<PushProvider>>() {};
            return apiClient.invokeAPI("/api/v1/push-providers", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Push Providers
            * Lists all push providers
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param type Filters push providers by &#x60;providerType&#x60; (optional)
            * @return ResponseEntity&lt;List&lt;PushProvider&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listPushProvidersWithPaginationInfo(ProviderType type) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "type", type));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<PushProvider>> localReturnType = new ParameterizedTypeReference<List<PushProvider>>() {};
            ResponseEntity<List<PushProvider>> responseEntity = apiClient.invokeAPI("/api/v1/push-providers", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace a Push Provider
        * Replaces a push provider by &#x60;pushProviderId&#x60;
            * <p><b>200</b> - OK
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param pushProviderId Id of the push provider (required)
                * @param pushProvider  (required)
                * @return PushProvider
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PushProvider replacePushProvider(String pushProviderId, PushProvider pushProvider) throws RestClientException {
                return replacePushProviderWithHttpInfo(pushProviderId, pushProvider).getBody();
            }




            /**
            * Replace a Push Provider
            * Replaces a push provider by &#x60;pushProviderId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param pushProviderId Id of the push provider (required)
                * @param pushProvider  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replacePushProvider(Class<?> T, String pushProviderId, PushProvider pushProvider) throws RestClientException {
                return (T) getObjectMapper().convertValue(replacePushProviderWithReturnType(T, pushProviderId, pushProvider).getBody(), T);
            }




            /**
            * Replace a Push Provider
            * Replaces a push provider by &#x60;pushProviderId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param pushProviderId Id of the push provider (required)
                * @param pushProvider  (required)
            * @return ResponseEntity&lt;PushProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<PushProvider> replacePushProviderWithHttpInfo(String pushProviderId, PushProvider pushProvider) throws RestClientException {
            Object localVarPostBody = pushProvider;
        
                // verify the required parameter 'pushProviderId' is set ''
                if (pushProviderId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pushProviderId' when calling replacePushProvider");
                }
        
                // verify the required parameter 'pushProvider' is set ''
                if (pushProvider == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pushProvider' when calling replacePushProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("pushProviderId", pushProviderId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PushProvider> localReturnType = new ParameterizedTypeReference<PushProvider>() {};
            return apiClient.invokeAPI("/api/v1/push-providers/{pushProviderId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Push Provider
            * Replaces a push provider by &#x60;pushProviderId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param pushProviderId Id of the push provider (required)
                * @param pushProvider  (required)
            * @return ResponseEntity&lt;PushProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replacePushProviderWithReturnType(Class<?> T, String pushProviderId,PushProvider pushProvider) throws RestClientException {
            Object localVarPostBody = pushProvider;
        
                // verify the required parameter 'pushProviderId' is set
                if (pushProviderId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pushProviderId' when calling replacePushProvider");
                }
        
                // verify the required parameter 'pushProvider' is set
                if (pushProvider == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pushProvider' when calling replacePushProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("pushProviderId", pushProviderId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/push-providers/{pushProviderId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Push Provider
            * Replaces a push provider by &#x60;pushProviderId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param pushProviderId Id of the push provider (required)
                * @param pushProvider  (required)
            * @return ResponseEntity&lt;PushProvider&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replacePushProviderWithPaginationInfo(String pushProviderId, PushProvider pushProvider) throws RestClientException {
            Object localVarPostBody = pushProvider;
        
                // verify the required parameter 'pushProviderId' is set
                if (pushProviderId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pushProviderId' when calling replacePushProvider");
                }
        
                // verify the required parameter 'pushProvider' is set
                if (pushProvider == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'pushProvider' when calling replacePushProvider");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("pushProviderId", pushProviderId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PushProvider> localReturnType = new ParameterizedTypeReference<PushProvider>() {};
            ResponseEntity<PushProvider> responseEntity = apiClient.invokeAPI("/api/v1/push-providers/{pushProviderId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }


    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
