package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.Error;
import org.openapitools.client.model.PrincipalRateLimitEntity;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.PrincipalRateLimitApi")
    public class PrincipalRateLimitApi {
    private ApiClient apiClient;

    public PrincipalRateLimitApi() {
    this(new ApiClient());
    }

    @Autowired
    public PrincipalRateLimitApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Create a Principal Rate Limit
        * Creates a new Principal Rate Limit entity. In the current release, we only allow one Principal Rate Limit entity per org and principal.
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param entity  (required)
                * @return PrincipalRateLimitEntity
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PrincipalRateLimitEntity createPrincipalRateLimitEntity(PrincipalRateLimitEntity entity) throws RestClientException {
                return createPrincipalRateLimitEntityWithHttpInfo(entity).getBody();
            }




            /**
            * Create a Principal Rate Limit
            * Creates a new Principal Rate Limit entity. In the current release, we only allow one Principal Rate Limit entity per org and principal.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param entity  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createPrincipalRateLimitEntity(Class<?> T, PrincipalRateLimitEntity entity) throws RestClientException {
                return (T) getObjectMapper().convertValue(createPrincipalRateLimitEntityWithReturnType(T, entity).getBody(), T);
            }




            /**
            * Create a Principal Rate Limit
            * Creates a new Principal Rate Limit entity. In the current release, we only allow one Principal Rate Limit entity per org and principal.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param entity  (required)
            * @return ResponseEntity&lt;PrincipalRateLimitEntity&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<PrincipalRateLimitEntity> createPrincipalRateLimitEntityWithHttpInfo(PrincipalRateLimitEntity entity) throws RestClientException {
            Object localVarPostBody = entity;
        
                // verify the required parameter 'entity' is set ''
                if (entity == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'entity' when calling createPrincipalRateLimitEntity");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PrincipalRateLimitEntity> localReturnType = new ParameterizedTypeReference<PrincipalRateLimitEntity>() {};
            return apiClient.invokeAPI("/api/v1/principal-rate-limits", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Principal Rate Limit
            * Creates a new Principal Rate Limit entity. In the current release, we only allow one Principal Rate Limit entity per org and principal.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param entity  (required)
            * @return ResponseEntity&lt;PrincipalRateLimitEntity&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createPrincipalRateLimitEntityWithReturnType(Class<?> T, PrincipalRateLimitEntity entity) throws RestClientException {
            Object localVarPostBody = entity;
        
                // verify the required parameter 'entity' is set
                if (entity == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'entity' when calling createPrincipalRateLimitEntity");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/principal-rate-limits", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Principal Rate Limit
            * Creates a new Principal Rate Limit entity. In the current release, we only allow one Principal Rate Limit entity per org and principal.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param entity  (required)
            * @return ResponseEntity&lt;PrincipalRateLimitEntity&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createPrincipalRateLimitEntityWithPaginationInfo(PrincipalRateLimitEntity entity) throws RestClientException {
            Object localVarPostBody = entity;
        
                // verify the required parameter 'entity' is set
                if (entity == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'entity' when calling createPrincipalRateLimitEntity");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PrincipalRateLimitEntity> localReturnType = new ParameterizedTypeReference<PrincipalRateLimitEntity>() {};
            ResponseEntity<PrincipalRateLimitEntity> responseEntity = apiClient.invokeAPI("/api/v1/principal-rate-limits", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Principal Rate Limit
        * Retrieves a Principal Rate Limit entity by &#x60;principalRateLimitId&#x60;
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param principalRateLimitId id of the Principal Rate Limit (required)
                * @return PrincipalRateLimitEntity
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PrincipalRateLimitEntity getPrincipalRateLimitEntity(String principalRateLimitId) throws RestClientException {
                return getPrincipalRateLimitEntityWithHttpInfo(principalRateLimitId).getBody();
            }






            /**
            * Retrieve a Principal Rate Limit
            * Retrieves a Principal Rate Limit entity by &#x60;principalRateLimitId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param principalRateLimitId id of the Principal Rate Limit (required)
            * @return ResponseEntity&lt;PrincipalRateLimitEntity&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<PrincipalRateLimitEntity> getPrincipalRateLimitEntityWithHttpInfo(String principalRateLimitId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'principalRateLimitId' is set ''
                if (principalRateLimitId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'principalRateLimitId' when calling getPrincipalRateLimitEntity");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("principalRateLimitId", principalRateLimitId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PrincipalRateLimitEntity> localReturnType = new ParameterizedTypeReference<PrincipalRateLimitEntity>() {};
            return apiClient.invokeAPI("/api/v1/principal-rate-limits/{principalRateLimitId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Principal Rate Limit
            * Retrieves a Principal Rate Limit entity by &#x60;principalRateLimitId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param principalRateLimitId id of the Principal Rate Limit (required)
            * @return ResponseEntity&lt;PrincipalRateLimitEntity&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getPrincipalRateLimitEntityWithPaginationInfo(String principalRateLimitId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'principalRateLimitId' is set
                if (principalRateLimitId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'principalRateLimitId' when calling getPrincipalRateLimitEntity");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("principalRateLimitId", principalRateLimitId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PrincipalRateLimitEntity> localReturnType = new ParameterizedTypeReference<PrincipalRateLimitEntity>() {};
            ResponseEntity<PrincipalRateLimitEntity> responseEntity = apiClient.invokeAPI("/api/v1/principal-rate-limits/{principalRateLimitId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Principal Rate Limits
        * Lists all Principal Rate Limit entities considering the provided parameters
            * <p><b>200</b> - OK
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param filter  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
                * @return List&lt;PrincipalRateLimitEntity&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<PrincipalRateLimitEntity> listPrincipalRateLimitEntities(String filter, String after, Integer limit) throws RestClientException {
                return listPrincipalRateLimitEntitiesWithHttpInfo(filter, after, limit).getBody();
            }






            /**
            * List all Principal Rate Limits
            * Lists all Principal Rate Limit entities considering the provided parameters
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param filter  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;PrincipalRateLimitEntity&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<PrincipalRateLimitEntity>> listPrincipalRateLimitEntitiesWithHttpInfo(String filter, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "filter", filter));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<PrincipalRateLimitEntity>> localReturnType = new ParameterizedTypeReference<List<PrincipalRateLimitEntity>>() {};
            return apiClient.invokeAPI("/api/v1/principal-rate-limits", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Principal Rate Limits
            * Lists all Principal Rate Limit entities considering the provided parameters
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param filter  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;PrincipalRateLimitEntity&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listPrincipalRateLimitEntitiesWithPaginationInfo(String filter, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "filter", filter));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<PrincipalRateLimitEntity>> localReturnType = new ParameterizedTypeReference<List<PrincipalRateLimitEntity>>() {};
            ResponseEntity<List<PrincipalRateLimitEntity>> responseEntity = apiClient.invokeAPI("/api/v1/principal-rate-limits", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace a Principal Rate Limit
        * Replaces a principal rate limit entity by &#x60;principalRateLimitId&#x60;
            * <p><b>200</b> - OK
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param principalRateLimitId id of the Principal Rate Limit (required)
                * @param entity  (required)
                * @return PrincipalRateLimitEntity
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PrincipalRateLimitEntity replacePrincipalRateLimitEntity(String principalRateLimitId, PrincipalRateLimitEntity entity) throws RestClientException {
                return replacePrincipalRateLimitEntityWithHttpInfo(principalRateLimitId, entity).getBody();
            }




            /**
            * Replace a Principal Rate Limit
            * Replaces a principal rate limit entity by &#x60;principalRateLimitId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param principalRateLimitId id of the Principal Rate Limit (required)
                * @param entity  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replacePrincipalRateLimitEntity(Class<?> T, String principalRateLimitId, PrincipalRateLimitEntity entity) throws RestClientException {
                return (T) getObjectMapper().convertValue(replacePrincipalRateLimitEntityWithReturnType(T, principalRateLimitId, entity).getBody(), T);
            }




            /**
            * Replace a Principal Rate Limit
            * Replaces a principal rate limit entity by &#x60;principalRateLimitId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param principalRateLimitId id of the Principal Rate Limit (required)
                * @param entity  (required)
            * @return ResponseEntity&lt;PrincipalRateLimitEntity&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<PrincipalRateLimitEntity> replacePrincipalRateLimitEntityWithHttpInfo(String principalRateLimitId, PrincipalRateLimitEntity entity) throws RestClientException {
            Object localVarPostBody = entity;
        
                // verify the required parameter 'principalRateLimitId' is set ''
                if (principalRateLimitId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'principalRateLimitId' when calling replacePrincipalRateLimitEntity");
                }
        
                // verify the required parameter 'entity' is set ''
                if (entity == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'entity' when calling replacePrincipalRateLimitEntity");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("principalRateLimitId", principalRateLimitId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PrincipalRateLimitEntity> localReturnType = new ParameterizedTypeReference<PrincipalRateLimitEntity>() {};
            return apiClient.invokeAPI("/api/v1/principal-rate-limits/{principalRateLimitId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Principal Rate Limit
            * Replaces a principal rate limit entity by &#x60;principalRateLimitId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param principalRateLimitId id of the Principal Rate Limit (required)
                * @param entity  (required)
            * @return ResponseEntity&lt;PrincipalRateLimitEntity&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replacePrincipalRateLimitEntityWithReturnType(Class<?> T, String principalRateLimitId,PrincipalRateLimitEntity entity) throws RestClientException {
            Object localVarPostBody = entity;
        
                // verify the required parameter 'principalRateLimitId' is set
                if (principalRateLimitId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'principalRateLimitId' when calling replacePrincipalRateLimitEntity");
                }
        
                // verify the required parameter 'entity' is set
                if (entity == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'entity' when calling replacePrincipalRateLimitEntity");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("principalRateLimitId", principalRateLimitId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/principal-rate-limits/{principalRateLimitId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Principal Rate Limit
            * Replaces a principal rate limit entity by &#x60;principalRateLimitId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param principalRateLimitId id of the Principal Rate Limit (required)
                * @param entity  (required)
            * @return ResponseEntity&lt;PrincipalRateLimitEntity&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replacePrincipalRateLimitEntityWithPaginationInfo(String principalRateLimitId, PrincipalRateLimitEntity entity) throws RestClientException {
            Object localVarPostBody = entity;
        
                // verify the required parameter 'principalRateLimitId' is set
                if (principalRateLimitId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'principalRateLimitId' when calling replacePrincipalRateLimitEntity");
                }
        
                // verify the required parameter 'entity' is set
                if (entity == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'entity' when calling replacePrincipalRateLimitEntity");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("principalRateLimitId", principalRateLimitId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PrincipalRateLimitEntity> localReturnType = new ParameterizedTypeReference<PrincipalRateLimitEntity>() {};
            ResponseEntity<PrincipalRateLimitEntity> responseEntity = apiClient.invokeAPI("/api/v1/principal-rate-limits/{principalRateLimitId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }


    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
