package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.DeviceAssurance;
import org.openapitools.client.model.Error;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.DeviceAssuranceApi")
    public class DeviceAssuranceApi {
    private ApiClient apiClient;

    public DeviceAssuranceApi() {
    this(new ApiClient());
    }

    @Autowired
    public DeviceAssuranceApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Create a Device Assurance Policy
        * Creates a new Device Assurance Policy
            * <p><b>200</b> - OK
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param deviceAssurance  (required)
                * @return DeviceAssurance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public DeviceAssurance createDeviceAssurancePolicy(DeviceAssurance deviceAssurance) throws RestClientException {
                return createDeviceAssurancePolicyWithHttpInfo(deviceAssurance).getBody();
            }




            /**
            * Create a Device Assurance Policy
            * Creates a new Device Assurance Policy
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param deviceAssurance  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createDeviceAssurancePolicy(Class<?> T, DeviceAssurance deviceAssurance) throws RestClientException {
                return (T) getObjectMapper().convertValue(createDeviceAssurancePolicyWithReturnType(T, deviceAssurance).getBody(), T);
            }




            /**
            * Create a Device Assurance Policy
            * Creates a new Device Assurance Policy
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param deviceAssurance  (required)
            * @return ResponseEntity&lt;DeviceAssurance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<DeviceAssurance> createDeviceAssurancePolicyWithHttpInfo(DeviceAssurance deviceAssurance) throws RestClientException {
            Object localVarPostBody = deviceAssurance;
        
                // verify the required parameter 'deviceAssurance' is set ''
                if (deviceAssurance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceAssurance' when calling createDeviceAssurancePolicy");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<DeviceAssurance> localReturnType = new ParameterizedTypeReference<DeviceAssurance>() {};
            return apiClient.invokeAPI("/api/v1/device-assurances", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Device Assurance Policy
            * Creates a new Device Assurance Policy
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param deviceAssurance  (required)
            * @return ResponseEntity&lt;DeviceAssurance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createDeviceAssurancePolicyWithReturnType(Class<?> T, DeviceAssurance deviceAssurance) throws RestClientException {
            Object localVarPostBody = deviceAssurance;
        
                // verify the required parameter 'deviceAssurance' is set
                if (deviceAssurance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceAssurance' when calling createDeviceAssurancePolicy");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/device-assurances", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Device Assurance Policy
            * Creates a new Device Assurance Policy
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param deviceAssurance  (required)
            * @return ResponseEntity&lt;DeviceAssurance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createDeviceAssurancePolicyWithPaginationInfo(DeviceAssurance deviceAssurance) throws RestClientException {
            Object localVarPostBody = deviceAssurance;
        
                // verify the required parameter 'deviceAssurance' is set
                if (deviceAssurance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceAssurance' when calling createDeviceAssurancePolicy");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<DeviceAssurance> localReturnType = new ParameterizedTypeReference<DeviceAssurance>() {};
            ResponseEntity<DeviceAssurance> responseEntity = apiClient.invokeAPI("/api/v1/device-assurances", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Delete a Device Assurance Policy
        * Deletes a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;. If the Device Assurance Policy is currently being used in the org Authentication Policies, the delete will not be allowed.
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>409</b> - Conflict
            * <p><b>429</b> - Too Many Requests
                * @param deviceAssuranceId Id of the Device Assurance Policy (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteDeviceAssurancePolicy(String deviceAssuranceId) throws RestClientException {
            deleteDeviceAssurancePolicyWithHttpInfo(deviceAssuranceId);
            }






            /**
            * Delete a Device Assurance Policy
            * Deletes a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;. If the Device Assurance Policy is currently being used in the org Authentication Policies, the delete will not be allowed.
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Conflict
                * <p><b>429</b> - Too Many Requests
                * @param deviceAssuranceId Id of the Device Assurance Policy (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteDeviceAssurancePolicyWithHttpInfo(String deviceAssuranceId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'deviceAssuranceId' is set ''
                if (deviceAssuranceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceAssuranceId' when calling deleteDeviceAssurancePolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("deviceAssuranceId", deviceAssuranceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/device-assurances/{deviceAssuranceId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Retrieve a Device Assurance Policy
        * Retrieves a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param deviceAssuranceId Id of the Device Assurance Policy (required)
                * @return DeviceAssurance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public DeviceAssurance getDeviceAssurancePolicy(String deviceAssuranceId) throws RestClientException {
                return getDeviceAssurancePolicyWithHttpInfo(deviceAssuranceId).getBody();
            }






            /**
            * Retrieve a Device Assurance Policy
            * Retrieves a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param deviceAssuranceId Id of the Device Assurance Policy (required)
            * @return ResponseEntity&lt;DeviceAssurance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<DeviceAssurance> getDeviceAssurancePolicyWithHttpInfo(String deviceAssuranceId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'deviceAssuranceId' is set ''
                if (deviceAssuranceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceAssuranceId' when calling getDeviceAssurancePolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("deviceAssuranceId", deviceAssuranceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<DeviceAssurance> localReturnType = new ParameterizedTypeReference<DeviceAssurance>() {};
            return apiClient.invokeAPI("/api/v1/device-assurances/{deviceAssuranceId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Device Assurance Policy
            * Retrieves a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param deviceAssuranceId Id of the Device Assurance Policy (required)
            * @return ResponseEntity&lt;DeviceAssurance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getDeviceAssurancePolicyWithPaginationInfo(String deviceAssuranceId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'deviceAssuranceId' is set
                if (deviceAssuranceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceAssuranceId' when calling getDeviceAssurancePolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("deviceAssuranceId", deviceAssuranceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<DeviceAssurance> localReturnType = new ParameterizedTypeReference<DeviceAssurance>() {};
            ResponseEntity<DeviceAssurance> responseEntity = apiClient.invokeAPI("/api/v1/device-assurances/{deviceAssuranceId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Device Assurance Policies
        * Lists all device assurance policies
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @return List&lt;DeviceAssurance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<DeviceAssurance> listDeviceAssurancePolicies() throws RestClientException {
                return listDeviceAssurancePoliciesWithHttpInfo().getBody();
            }






            /**
            * List all Device Assurance Policies
            * Lists all device assurance policies
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;List&lt;DeviceAssurance&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<DeviceAssurance>> listDeviceAssurancePoliciesWithHttpInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<DeviceAssurance>> localReturnType = new ParameterizedTypeReference<List<DeviceAssurance>>() {};
            return apiClient.invokeAPI("/api/v1/device-assurances", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Device Assurance Policies
            * Lists all device assurance policies
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;List&lt;DeviceAssurance&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listDeviceAssurancePoliciesWithPaginationInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<DeviceAssurance>> localReturnType = new ParameterizedTypeReference<List<DeviceAssurance>>() {};
            ResponseEntity<List<DeviceAssurance>> responseEntity = apiClient.invokeAPI("/api/v1/device-assurances", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace a Device Assurance Policy
        * Replaces a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;
            * <p><b>200</b> - OK
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param deviceAssuranceId Id of the Device Assurance Policy (required)
                * @param deviceAssurance  (required)
                * @return DeviceAssurance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public DeviceAssurance replaceDeviceAssurancePolicy(String deviceAssuranceId, DeviceAssurance deviceAssurance) throws RestClientException {
                return replaceDeviceAssurancePolicyWithHttpInfo(deviceAssuranceId, deviceAssurance).getBody();
            }




            /**
            * Replace a Device Assurance Policy
            * Replaces a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param deviceAssuranceId Id of the Device Assurance Policy (required)
                * @param deviceAssurance  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceDeviceAssurancePolicy(Class<?> T, String deviceAssuranceId, DeviceAssurance deviceAssurance) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceDeviceAssurancePolicyWithReturnType(T, deviceAssuranceId, deviceAssurance).getBody(), T);
            }




            /**
            * Replace a Device Assurance Policy
            * Replaces a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param deviceAssuranceId Id of the Device Assurance Policy (required)
                * @param deviceAssurance  (required)
            * @return ResponseEntity&lt;DeviceAssurance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<DeviceAssurance> replaceDeviceAssurancePolicyWithHttpInfo(String deviceAssuranceId, DeviceAssurance deviceAssurance) throws RestClientException {
            Object localVarPostBody = deviceAssurance;
        
                // verify the required parameter 'deviceAssuranceId' is set ''
                if (deviceAssuranceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceAssuranceId' when calling replaceDeviceAssurancePolicy");
                }
        
                // verify the required parameter 'deviceAssurance' is set ''
                if (deviceAssurance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceAssurance' when calling replaceDeviceAssurancePolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("deviceAssuranceId", deviceAssuranceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<DeviceAssurance> localReturnType = new ParameterizedTypeReference<DeviceAssurance>() {};
            return apiClient.invokeAPI("/api/v1/device-assurances/{deviceAssuranceId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Device Assurance Policy
            * Replaces a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param deviceAssuranceId Id of the Device Assurance Policy (required)
                * @param deviceAssurance  (required)
            * @return ResponseEntity&lt;DeviceAssurance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceDeviceAssurancePolicyWithReturnType(Class<?> T, String deviceAssuranceId,DeviceAssurance deviceAssurance) throws RestClientException {
            Object localVarPostBody = deviceAssurance;
        
                // verify the required parameter 'deviceAssuranceId' is set
                if (deviceAssuranceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceAssuranceId' when calling replaceDeviceAssurancePolicy");
                }
        
                // verify the required parameter 'deviceAssurance' is set
                if (deviceAssurance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceAssurance' when calling replaceDeviceAssurancePolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("deviceAssuranceId", deviceAssuranceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/device-assurances/{deviceAssuranceId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Device Assurance Policy
            * Replaces a Device Assurance Policy by &#x60;deviceAssuranceId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param deviceAssuranceId Id of the Device Assurance Policy (required)
                * @param deviceAssurance  (required)
            * @return ResponseEntity&lt;DeviceAssurance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceDeviceAssurancePolicyWithPaginationInfo(String deviceAssuranceId, DeviceAssurance deviceAssurance) throws RestClientException {
            Object localVarPostBody = deviceAssurance;
        
                // verify the required parameter 'deviceAssuranceId' is set
                if (deviceAssuranceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceAssuranceId' when calling replaceDeviceAssurancePolicy");
                }
        
                // verify the required parameter 'deviceAssurance' is set
                if (deviceAssurance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceAssurance' when calling replaceDeviceAssurancePolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("deviceAssuranceId", deviceAssuranceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<DeviceAssurance> localReturnType = new ParameterizedTypeReference<DeviceAssurance>() {};
            ResponseEntity<DeviceAssurance> responseEntity = apiClient.invokeAPI("/api/v1/device-assurances/{deviceAssuranceId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }


    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
