package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.Device;
import org.openapitools.client.model.Error;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.DeviceApi")
    public class DeviceApi {
    private ApiClient apiClient;

    public DeviceApi() {
    this(new ApiClient());
    }

    @Autowired
    public DeviceApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Activate a Device
        * Activates a device by &#x60;deviceId&#x60;
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param deviceId &#x60;id&#x60; of the device (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void activateDevice(String deviceId) throws RestClientException {
            activateDeviceWithHttpInfo(deviceId);
            }






            /**
            * Activate a Device
            * Activates a device by &#x60;deviceId&#x60;
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param deviceId &#x60;id&#x60; of the device (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> activateDeviceWithHttpInfo(String deviceId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'deviceId' is set ''
                if (deviceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceId' when calling activateDevice");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("deviceId", deviceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/devices/{deviceId}/lifecycle/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Deactivate a Device
        * Deactivates a device by &#x60;deviceId&#x60;
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param deviceId &#x60;id&#x60; of the device (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deactivateDevice(String deviceId) throws RestClientException {
            deactivateDeviceWithHttpInfo(deviceId);
            }






            /**
            * Deactivate a Device
            * Deactivates a device by &#x60;deviceId&#x60;
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param deviceId &#x60;id&#x60; of the device (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deactivateDeviceWithHttpInfo(String deviceId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'deviceId' is set ''
                if (deviceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceId' when calling deactivateDevice");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("deviceId", deviceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/devices/{deviceId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete a Device
        * Deletes a device by &#x60;deviceId&#x60;
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param deviceId &#x60;id&#x60; of the device (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteDevice(String deviceId) throws RestClientException {
            deleteDeviceWithHttpInfo(deviceId);
            }






            /**
            * Delete a Device
            * Deletes a device by &#x60;deviceId&#x60;
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param deviceId &#x60;id&#x60; of the device (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteDeviceWithHttpInfo(String deviceId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'deviceId' is set ''
                if (deviceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceId' when calling deleteDevice");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("deviceId", deviceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/devices/{deviceId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Retrieve a Device
        * Retrieves a device by &#x60;deviceId&#x60;
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param deviceId &#x60;id&#x60; of the device (required)
                * @return Device
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Device getDevice(String deviceId) throws RestClientException {
                return getDeviceWithHttpInfo(deviceId).getBody();
            }






            /**
            * Retrieve a Device
            * Retrieves a device by &#x60;deviceId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param deviceId &#x60;id&#x60; of the device (required)
            * @return ResponseEntity&lt;Device&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Device> getDeviceWithHttpInfo(String deviceId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'deviceId' is set ''
                if (deviceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceId' when calling getDevice");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("deviceId", deviceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Device> localReturnType = new ParameterizedTypeReference<Device>() {};
            return apiClient.invokeAPI("/api/v1/devices/{deviceId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Device
            * Retrieves a device by &#x60;deviceId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param deviceId &#x60;id&#x60; of the device (required)
            * @return ResponseEntity&lt;Device&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getDeviceWithPaginationInfo(String deviceId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'deviceId' is set
                if (deviceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceId' when calling getDevice");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("deviceId", deviceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Device> localReturnType = new ParameterizedTypeReference<Device>() {};
            ResponseEntity<Device> responseEntity = apiClient.invokeAPI("/api/v1/devices/{deviceId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Devices
        * Lists all devices with pagination support.  A subset of Devices can be returned that match a supported search criteria using the &#x60;search&#x60; query parameter.  Searches for devices based on the properties specified in the &#x60;search&#x60; parameter conforming SCIM filter specifications (case-insensitive). This data is eventually consistent. The API returns different results depending on specified queries in the request. Empty list is returned if no objects match &#x60;search&#x60; request.  &gt; **Note:** Listing devices with &#x60;search&#x60; should not be used as a part of any critical flows—such as authentication or updates—to prevent potential data loss. &#x60;search&#x60; results may not reflect the latest information, as this endpoint uses a search index which may not be up-to-date with recent updates to the object. &lt;br&gt; Don&#39;t use search results directly for record updates, as the data might be stale and therefore overwrite newer data, resulting in data loss. &lt;br&gt; Use an &#x60;id&#x60; lookup for records that you update to ensure your results contain the latest data.  This operation equires [URL encoding](http://en.wikipedia.org/wiki/Percent-encoding). For example, &#x60;search&#x3D;profile.displayName eq \&quot;Bob\&quot;&#x60; is encoded as &#x60;search&#x3D;profile.displayName%20eq%20%22Bob%22&#x60;.
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @param limit A limit on the number of objects to return. (optional, default to 20)
                * @param search SCIM filter expression that filters the results. Searches include all Device &#x60;profile&#x60; properties, as well as the Device &#x60;id&#x60;, &#x60;status&#x60; and &#x60;lastUpdated&#x60; properties. (optional)
                * @return List&lt;Device&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<Device> listDevices(String after, Integer limit, String search) throws RestClientException {
                return listDevicesWithHttpInfo(after, limit, search).getBody();
            }






            /**
            * List all Devices
            * Lists all devices with pagination support.  A subset of Devices can be returned that match a supported search criteria using the &#x60;search&#x60; query parameter.  Searches for devices based on the properties specified in the &#x60;search&#x60; parameter conforming SCIM filter specifications (case-insensitive). This data is eventually consistent. The API returns different results depending on specified queries in the request. Empty list is returned if no objects match &#x60;search&#x60; request.  &gt; **Note:** Listing devices with &#x60;search&#x60; should not be used as a part of any critical flows—such as authentication or updates—to prevent potential data loss. &#x60;search&#x60; results may not reflect the latest information, as this endpoint uses a search index which may not be up-to-date with recent updates to the object. &lt;br&gt; Don&#39;t use search results directly for record updates, as the data might be stale and therefore overwrite newer data, resulting in data loss. &lt;br&gt; Use an &#x60;id&#x60; lookup for records that you update to ensure your results contain the latest data.  This operation equires [URL encoding](http://en.wikipedia.org/wiki/Percent-encoding). For example, &#x60;search&#x3D;profile.displayName eq \&quot;Bob\&quot;&#x60; is encoded as &#x60;search&#x3D;profile.displayName%20eq%20%22Bob%22&#x60;.
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @param limit A limit on the number of objects to return. (optional, default to 20)
                * @param search SCIM filter expression that filters the results. Searches include all Device &#x60;profile&#x60; properties, as well as the Device &#x60;id&#x60;, &#x60;status&#x60; and &#x60;lastUpdated&#x60; properties. (optional)
            * @return ResponseEntity&lt;List&lt;Device&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<Device>> listDevicesWithHttpInfo(String after, Integer limit, String search) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "search", search));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Device>> localReturnType = new ParameterizedTypeReference<List<Device>>() {};
            return apiClient.invokeAPI("/api/v1/devices", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Devices
            * Lists all devices with pagination support.  A subset of Devices can be returned that match a supported search criteria using the &#x60;search&#x60; query parameter.  Searches for devices based on the properties specified in the &#x60;search&#x60; parameter conforming SCIM filter specifications (case-insensitive). This data is eventually consistent. The API returns different results depending on specified queries in the request. Empty list is returned if no objects match &#x60;search&#x60; request.  &gt; **Note:** Listing devices with &#x60;search&#x60; should not be used as a part of any critical flows—such as authentication or updates—to prevent potential data loss. &#x60;search&#x60; results may not reflect the latest information, as this endpoint uses a search index which may not be up-to-date with recent updates to the object. &lt;br&gt; Don&#39;t use search results directly for record updates, as the data might be stale and therefore overwrite newer data, resulting in data loss. &lt;br&gt; Use an &#x60;id&#x60; lookup for records that you update to ensure your results contain the latest data.  This operation equires [URL encoding](http://en.wikipedia.org/wiki/Percent-encoding). For example, &#x60;search&#x3D;profile.displayName eq \&quot;Bob\&quot;&#x60; is encoded as &#x60;search&#x3D;profile.displayName%20eq%20%22Bob%22&#x60;.
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @param limit A limit on the number of objects to return. (optional, default to 20)
                * @param search SCIM filter expression that filters the results. Searches include all Device &#x60;profile&#x60; properties, as well as the Device &#x60;id&#x60;, &#x60;status&#x60; and &#x60;lastUpdated&#x60; properties. (optional)
            * @return ResponseEntity&lt;List&lt;Device&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listDevicesWithPaginationInfo(String after, Integer limit, String search) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "search", search));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Device>> localReturnType = new ParameterizedTypeReference<List<Device>>() {};
            ResponseEntity<List<Device>> responseEntity = apiClient.invokeAPI("/api/v1/devices", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Suspend a Device
        * Suspends a device by &#x60;deviceId&#x60;
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param deviceId &#x60;id&#x60; of the device (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void suspendDevice(String deviceId) throws RestClientException {
            suspendDeviceWithHttpInfo(deviceId);
            }






            /**
            * Suspend a Device
            * Suspends a device by &#x60;deviceId&#x60;
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param deviceId &#x60;id&#x60; of the device (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> suspendDeviceWithHttpInfo(String deviceId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'deviceId' is set ''
                if (deviceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceId' when calling suspendDevice");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("deviceId", deviceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/devices/{deviceId}/lifecycle/suspend", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Unsuspend a Device
        * Unsuspends a device by &#x60;deviceId&#x60;
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param deviceId &#x60;id&#x60; of the device (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unsuspendDevice(String deviceId) throws RestClientException {
            unsuspendDeviceWithHttpInfo(deviceId);
            }






            /**
            * Unsuspend a Device
            * Unsuspends a device by &#x60;deviceId&#x60;
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param deviceId &#x60;id&#x60; of the device (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unsuspendDeviceWithHttpInfo(String deviceId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'deviceId' is set ''
                if (deviceId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'deviceId' when calling unsuspendDevice");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("deviceId", deviceId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/devices/{deviceId}/lifecycle/unsuspend", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }








    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
