package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.Brand;
import org.openapitools.client.model.BrandDomain;
import org.openapitools.client.model.BrandRequest;
import org.openapitools.client.model.CreateBrandDomainRequest;
import org.openapitools.client.model.CreateBrandRequest;
import org.openapitools.client.model.CustomizablePage;
import org.openapitools.client.model.DomainResponse;
import org.openapitools.client.model.EmailCustomization;
import org.openapitools.client.model.EmailDefaultContent;
import org.openapitools.client.model.EmailPreview;
import org.openapitools.client.model.EmailSettings;
import org.openapitools.client.model.EmailTemplate;
import org.openapitools.client.model.Error;
import java.io.File;
import org.openapitools.client.model.HostedPage;
import org.openapitools.client.model.ImageUploadResponse;
import org.openapitools.client.model.PageRoot;
import org.openapitools.client.model.SignInPage;
import org.openapitools.client.model.Theme;
import org.openapitools.client.model.ThemeResponse;
import java.net.URI;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.CustomizationApi")
    public class CustomizationApi {
    private ApiClient apiClient;

    public CustomizationApi() {
    this(new ApiClient());
    }

    @Autowired
    public CustomizationApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Create a Brand
        * Creates new brand in your org
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param createBrandRequest  (optional)
                * @return Brand
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Brand createBrand(CreateBrandRequest createBrandRequest) throws RestClientException {
                return createBrandWithHttpInfo(createBrandRequest).getBody();
            }




            /**
            * Create a Brand
            * Creates new brand in your org
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param createBrandRequest  (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createBrand(Class<?> T, CreateBrandRequest createBrandRequest) throws RestClientException {
                return (T) getObjectMapper().convertValue(createBrandWithReturnType(T, createBrandRequest).getBody(), T);
            }




            /**
            * Create a Brand
            * Creates new brand in your org
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param createBrandRequest  (optional)
            * @return ResponseEntity&lt;Brand&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Brand> createBrandWithHttpInfo(CreateBrandRequest createBrandRequest) throws RestClientException {
            Object localVarPostBody = createBrandRequest;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Brand> localReturnType = new ParameterizedTypeReference<Brand>() {};
            return apiClient.invokeAPI("/api/v1/brands", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Brand
            * Creates new brand in your org
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param createBrandRequest  (optional)
            * @return ResponseEntity&lt;Brand&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createBrandWithReturnType(Class<?> T, CreateBrandRequest createBrandRequest) throws RestClientException {
            Object localVarPostBody = createBrandRequest;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/brands", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a Brand
            * Creates new brand in your org
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param createBrandRequest  (optional)
            * @return ResponseEntity&lt;Brand&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createBrandWithPaginationInfo(CreateBrandRequest createBrandRequest) throws RestClientException {
            Object localVarPostBody = createBrandRequest;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Brand> localReturnType = new ParameterizedTypeReference<Brand>() {};
            ResponseEntity<Brand> responseEntity = apiClient.invokeAPI("/api/v1/brands", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Create an Email Customization
        * Creates a new email customization
            * <p><b>201</b> - Successfully created the email customization.
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>409</b> - Could not create the email customization because it conflicts with an existing email customization.
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param instance  (optional)
                * @return EmailCustomization
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public EmailCustomization createEmailCustomization(String brandId, String templateName, EmailCustomization instance) throws RestClientException {
                return createEmailCustomizationWithHttpInfo(brandId, templateName, instance).getBody();
            }




            /**
            * Create an Email Customization
            * Creates a new email customization
                * <p><b>201</b> - Successfully created the email customization.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Could not create the email customization because it conflicts with an existing email customization.
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param instance  (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createEmailCustomization(Class<?> T, String brandId, String templateName, EmailCustomization instance) throws RestClientException {
                return (T) getObjectMapper().convertValue(createEmailCustomizationWithReturnType(T, brandId, templateName, instance).getBody(), T);
            }




            /**
            * Create an Email Customization
            * Creates a new email customization
                * <p><b>201</b> - Successfully created the email customization.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Could not create the email customization because it conflicts with an existing email customization.
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param instance  (optional)
            * @return ResponseEntity&lt;EmailCustomization&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<EmailCustomization> createEmailCustomizationWithHttpInfo(String brandId, String templateName, EmailCustomization instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling createEmailCustomization");
                }
        
                // verify the required parameter 'templateName' is set ''
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling createEmailCustomization");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailCustomization> localReturnType = new ParameterizedTypeReference<EmailCustomization>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an Email Customization
            * Creates a new email customization
                * <p><b>201</b> - Successfully created the email customization.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Could not create the email customization because it conflicts with an existing email customization.
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param instance  (optional)
            * @return ResponseEntity&lt;EmailCustomization&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createEmailCustomizationWithReturnType(Class<?> T, String brandId,String templateName,EmailCustomization instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling createEmailCustomization");
                }
        
                // verify the required parameter 'templateName' is set
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling createEmailCustomization");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an Email Customization
            * Creates a new email customization
                * <p><b>201</b> - Successfully created the email customization.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Could not create the email customization because it conflicts with an existing email customization.
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param instance  (optional)
            * @return ResponseEntity&lt;EmailCustomization&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createEmailCustomizationWithPaginationInfo(String brandId, String templateName, EmailCustomization instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling createEmailCustomization");
                }
        
                // verify the required parameter 'templateName' is set
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling createEmailCustomization");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailCustomization> localReturnType = new ParameterizedTypeReference<EmailCustomization>() {};
            ResponseEntity<EmailCustomization> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Delete all Email Customizations
        * Deletes all customizations for an email template
            * <p><b>204</b> - Successfully deleted all customizations for the email template.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteAllCustomizations(String brandId, String templateName) throws RestClientException {
            deleteAllCustomizationsWithHttpInfo(brandId, templateName);
            }






            /**
            * Delete all Email Customizations
            * Deletes all customizations for an email template
                * <p><b>204</b> - Successfully deleted all customizations for the email template.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteAllCustomizationsWithHttpInfo(String brandId, String templateName) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling deleteAllCustomizations");
                }
        
                // verify the required parameter 'templateName' is set ''
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling deleteAllCustomizations");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete a brand
        * Deletes a brand by its unique identifier
            * <p><b>204</b> - Successfully deleted the brand.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>409</b> - Conflict
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteBrand(String brandId) throws RestClientException {
            deleteBrandWithHttpInfo(brandId);
            }






            /**
            * Delete a brand
            * Deletes a brand by its unique identifier
                * <p><b>204</b> - Successfully deleted the brand.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Conflict
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteBrandWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling deleteBrand");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete the Background Image
        * Deletes a Theme background image
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteBrandThemeBackgroundImage(String brandId, String themeId) throws RestClientException {
            deleteBrandThemeBackgroundImageWithHttpInfo(brandId, themeId);
            }






            /**
            * Delete the Background Image
            * Deletes a Theme background image
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteBrandThemeBackgroundImageWithHttpInfo(String brandId, String themeId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling deleteBrandThemeBackgroundImage");
                }
        
                // verify the required parameter 'themeId' is set ''
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling deleteBrandThemeBackgroundImage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}/background-image", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete the Favicon
        * Deletes a Theme favicon. The theme will use the default Okta favicon.
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteBrandThemeFavicon(String brandId, String themeId) throws RestClientException {
            deleteBrandThemeFaviconWithHttpInfo(brandId, themeId);
            }






            /**
            * Delete the Favicon
            * Deletes a Theme favicon. The theme will use the default Okta favicon.
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteBrandThemeFaviconWithHttpInfo(String brandId, String themeId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling deleteBrandThemeFavicon");
                }
        
                // verify the required parameter 'themeId' is set ''
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling deleteBrandThemeFavicon");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}/favicon", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete the Logo
        * Deletes a Theme logo. The theme will use the default Okta logo.
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteBrandThemeLogo(String brandId, String themeId) throws RestClientException {
            deleteBrandThemeLogoWithHttpInfo(brandId, themeId);
            }






            /**
            * Delete the Logo
            * Deletes a Theme logo. The theme will use the default Okta logo.
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteBrandThemeLogoWithHttpInfo(String brandId, String themeId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling deleteBrandThemeLogo");
                }
        
                // verify the required parameter 'themeId' is set ''
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling deleteBrandThemeLogo");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}/logo", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete an Email Customization
        * Deletes an email customization by its unique identifier
            * <p><b>204</b> - Successfully deleted the email customization.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>409</b> - Could not delete the email customization deleted because it is the default email customization.
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param customizationId The ID of the email customization. (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteEmailCustomization(String brandId, String templateName, String customizationId) throws RestClientException {
            deleteEmailCustomizationWithHttpInfo(brandId, templateName, customizationId);
            }






            /**
            * Delete an Email Customization
            * Deletes an email customization by its unique identifier
                * <p><b>204</b> - Successfully deleted the email customization.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Could not delete the email customization deleted because it is the default email customization.
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param customizationId The ID of the email customization. (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteEmailCustomizationWithHttpInfo(String brandId, String templateName, String customizationId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling deleteEmailCustomization");
                }
        
                // verify the required parameter 'templateName' is set ''
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling deleteEmailCustomization");
                }
        
                // verify the required parameter 'customizationId' is set ''
                if (customizationId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizationId' when calling deleteEmailCustomization");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);
                    uriVariables.put("customizationId", customizationId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Retrieve a Brand
        * Retrieves a brand by &#x60;brandId&#x60;
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @return Brand
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Brand getBrand(String brandId) throws RestClientException {
                return getBrandWithHttpInfo(brandId).getBody();
            }






            /**
            * Retrieve a Brand
            * Retrieves a brand by &#x60;brandId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;Brand&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Brand> getBrandWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getBrand");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Brand> localReturnType = new ParameterizedTypeReference<Brand>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Brand
            * Retrieves a brand by &#x60;brandId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;Brand&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getBrandWithPaginationInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getBrand");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Brand> localReturnType = new ParameterizedTypeReference<Brand>() {};
            ResponseEntity<Brand> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Theme
        * Retrieves a theme for a brand
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @return ThemeResponse
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ThemeResponse getBrandTheme(String brandId, String themeId) throws RestClientException {
                return getBrandThemeWithHttpInfo(brandId, themeId).getBody();
            }






            /**
            * Retrieve a Theme
            * Retrieves a theme for a brand
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
            * @return ResponseEntity&lt;ThemeResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ThemeResponse> getBrandThemeWithHttpInfo(String brandId, String themeId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getBrandTheme");
                }
        
                // verify the required parameter 'themeId' is set ''
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling getBrandTheme");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ThemeResponse> localReturnType = new ParameterizedTypeReference<ThemeResponse>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Theme
            * Retrieves a theme for a brand
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
            * @return ResponseEntity&lt;ThemeResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getBrandThemeWithPaginationInfo(String brandId, String themeId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getBrandTheme");
                }
        
                // verify the required parameter 'themeId' is set
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling getBrandTheme");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ThemeResponse> localReturnType = new ParameterizedTypeReference<ThemeResponse>() {};
            ResponseEntity<ThemeResponse> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Preview of an Email Customization
        * Generates a preview of an email customization. All variable references (e.g., &#x60;${user.profile.firstName}&#x60;) are populated using the current user&#39;s context.
            * <p><b>200</b> - Successfully generated a preview of the email customization.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param customizationId The ID of the email customization. (required)
                * @return EmailPreview
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public EmailPreview getCustomizationPreview(String brandId, String templateName, String customizationId) throws RestClientException {
                return getCustomizationPreviewWithHttpInfo(brandId, templateName, customizationId).getBody();
            }






            /**
            * Retrieve a Preview of an Email Customization
            * Generates a preview of an email customization. All variable references (e.g., &#x60;${user.profile.firstName}&#x60;) are populated using the current user&#39;s context.
                * <p><b>200</b> - Successfully generated a preview of the email customization.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param customizationId The ID of the email customization. (required)
            * @return ResponseEntity&lt;EmailPreview&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<EmailPreview> getCustomizationPreviewWithHttpInfo(String brandId, String templateName, String customizationId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getCustomizationPreview");
                }
        
                // verify the required parameter 'templateName' is set ''
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling getCustomizationPreview");
                }
        
                // verify the required parameter 'customizationId' is set ''
                if (customizationId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizationId' when calling getCustomizationPreview");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);
                    uriVariables.put("customizationId", customizationId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailPreview> localReturnType = new ParameterizedTypeReference<EmailPreview>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}/preview", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Preview of an Email Customization
            * Generates a preview of an email customization. All variable references (e.g., &#x60;${user.profile.firstName}&#x60;) are populated using the current user&#39;s context.
                * <p><b>200</b> - Successfully generated a preview of the email customization.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param customizationId The ID of the email customization. (required)
            * @return ResponseEntity&lt;EmailPreview&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getCustomizationPreviewWithPaginationInfo(String brandId, String templateName, String customizationId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getCustomizationPreview");
                }
        
                // verify the required parameter 'templateName' is set
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling getCustomizationPreview");
                }
        
                // verify the required parameter 'customizationId' is set
                if (customizationId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizationId' when calling getCustomizationPreview");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);
                    uriVariables.put("customizationId", customizationId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailPreview> localReturnType = new ParameterizedTypeReference<EmailPreview>() {};
            ResponseEntity<EmailPreview> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}/preview", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the Customized Error Page
        * Retrieves the customized error page
            * <p><b>200</b> - Successfully retrieved the customized error page.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @return CustomizablePage
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public CustomizablePage getCustomizedErrorPage(String brandId) throws RestClientException {
                return getCustomizedErrorPageWithHttpInfo(brandId).getBody();
            }






            /**
            * Retrieve the Customized Error Page
            * Retrieves the customized error page
                * <p><b>200</b> - Successfully retrieved the customized error page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;CustomizablePage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<CustomizablePage> getCustomizedErrorPageWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getCustomizedErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CustomizablePage> localReturnType = new ParameterizedTypeReference<CustomizablePage>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/customized", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the Customized Error Page
            * Retrieves the customized error page
                * <p><b>200</b> - Successfully retrieved the customized error page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;CustomizablePage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getCustomizedErrorPageWithPaginationInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getCustomizedErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CustomizablePage> localReturnType = new ParameterizedTypeReference<CustomizablePage>() {};
            ResponseEntity<CustomizablePage> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/customized", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the Customized Sign-in Page
        * Retrieves the customized sign-in page
            * <p><b>200</b> - Successfully retrieved the customized sign-in page.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @return SignInPage
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public SignInPage getCustomizedSignInPage(String brandId) throws RestClientException {
                return getCustomizedSignInPageWithHttpInfo(brandId).getBody();
            }






            /**
            * Retrieve the Customized Sign-in Page
            * Retrieves the customized sign-in page
                * <p><b>200</b> - Successfully retrieved the customized sign-in page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;SignInPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<SignInPage> getCustomizedSignInPageWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getCustomizedSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SignInPage> localReturnType = new ParameterizedTypeReference<SignInPage>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/customized", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the Customized Sign-in Page
            * Retrieves the customized sign-in page
                * <p><b>200</b> - Successfully retrieved the customized sign-in page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;SignInPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getCustomizedSignInPageWithPaginationInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getCustomizedSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SignInPage> localReturnType = new ParameterizedTypeReference<SignInPage>() {};
            ResponseEntity<SignInPage> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/customized", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the Default Error Page
        * Retrieves the default error page
            * <p><b>200</b> - Successfully retrieved the default error page.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @return CustomizablePage
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public CustomizablePage getDefaultErrorPage(String brandId) throws RestClientException {
                return getDefaultErrorPageWithHttpInfo(brandId).getBody();
            }






            /**
            * Retrieve the Default Error Page
            * Retrieves the default error page
                * <p><b>200</b> - Successfully retrieved the default error page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;CustomizablePage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<CustomizablePage> getDefaultErrorPageWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getDefaultErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CustomizablePage> localReturnType = new ParameterizedTypeReference<CustomizablePage>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/default", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the Default Error Page
            * Retrieves the default error page
                * <p><b>200</b> - Successfully retrieved the default error page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;CustomizablePage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getDefaultErrorPageWithPaginationInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getDefaultErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CustomizablePage> localReturnType = new ParameterizedTypeReference<CustomizablePage>() {};
            ResponseEntity<CustomizablePage> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/default", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the Default Sign-in Page
        * Retrieves the default sign-in page
            * <p><b>200</b> - Successfully retrieved the default sign-in page.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @return SignInPage
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public SignInPage getDefaultSignInPage(String brandId) throws RestClientException {
                return getDefaultSignInPageWithHttpInfo(brandId).getBody();
            }






            /**
            * Retrieve the Default Sign-in Page
            * Retrieves the default sign-in page
                * <p><b>200</b> - Successfully retrieved the default sign-in page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;SignInPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<SignInPage> getDefaultSignInPageWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getDefaultSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SignInPage> localReturnType = new ParameterizedTypeReference<SignInPage>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/default", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the Default Sign-in Page
            * Retrieves the default sign-in page
                * <p><b>200</b> - Successfully retrieved the default sign-in page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;SignInPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getDefaultSignInPageWithPaginationInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getDefaultSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SignInPage> localReturnType = new ParameterizedTypeReference<SignInPage>() {};
            ResponseEntity<SignInPage> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/default", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve an Email Customization
        * Retrieves an email customization by its unique identifier
            * <p><b>200</b> - Successfully retrieved the email customization.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param customizationId The ID of the email customization. (required)
                * @return EmailCustomization
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public EmailCustomization getEmailCustomization(String brandId, String templateName, String customizationId) throws RestClientException {
                return getEmailCustomizationWithHttpInfo(brandId, templateName, customizationId).getBody();
            }






            /**
            * Retrieve an Email Customization
            * Retrieves an email customization by its unique identifier
                * <p><b>200</b> - Successfully retrieved the email customization.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param customizationId The ID of the email customization. (required)
            * @return ResponseEntity&lt;EmailCustomization&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<EmailCustomization> getEmailCustomizationWithHttpInfo(String brandId, String templateName, String customizationId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getEmailCustomization");
                }
        
                // verify the required parameter 'templateName' is set ''
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling getEmailCustomization");
                }
        
                // verify the required parameter 'customizationId' is set ''
                if (customizationId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizationId' when calling getEmailCustomization");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);
                    uriVariables.put("customizationId", customizationId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailCustomization> localReturnType = new ParameterizedTypeReference<EmailCustomization>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve an Email Customization
            * Retrieves an email customization by its unique identifier
                * <p><b>200</b> - Successfully retrieved the email customization.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param customizationId The ID of the email customization. (required)
            * @return ResponseEntity&lt;EmailCustomization&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getEmailCustomizationWithPaginationInfo(String brandId, String templateName, String customizationId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getEmailCustomization");
                }
        
                // verify the required parameter 'templateName' is set
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling getEmailCustomization");
                }
        
                // verify the required parameter 'customizationId' is set
                if (customizationId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizationId' when calling getEmailCustomization");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);
                    uriVariables.put("customizationId", customizationId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailCustomization> localReturnType = new ParameterizedTypeReference<EmailCustomization>() {};
            ResponseEntity<EmailCustomization> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve an Email Template Default Content
        * Retrieves an email template&#39;s default content
            * <p><b>200</b> - Successfully retrieved the email template&#39;s default content.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param language The language to use for the email. Defaults to the current user&#39;s language if unspecified. (optional)
                * @return EmailDefaultContent
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public EmailDefaultContent getEmailDefaultContent(String brandId, String templateName, String language) throws RestClientException {
                return getEmailDefaultContentWithHttpInfo(brandId, templateName, language).getBody();
            }






            /**
            * Retrieve an Email Template Default Content
            * Retrieves an email template&#39;s default content
                * <p><b>200</b> - Successfully retrieved the email template&#39;s default content.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param language The language to use for the email. Defaults to the current user&#39;s language if unspecified. (optional)
            * @return ResponseEntity&lt;EmailDefaultContent&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<EmailDefaultContent> getEmailDefaultContentWithHttpInfo(String brandId, String templateName, String language) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getEmailDefaultContent");
                }
        
                // verify the required parameter 'templateName' is set ''
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling getEmailDefaultContent");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailDefaultContent> localReturnType = new ParameterizedTypeReference<EmailDefaultContent>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/default-content", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve an Email Template Default Content
            * Retrieves an email template&#39;s default content
                * <p><b>200</b> - Successfully retrieved the email template&#39;s default content.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param language The language to use for the email. Defaults to the current user&#39;s language if unspecified. (optional)
            * @return ResponseEntity&lt;EmailDefaultContent&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getEmailDefaultContentWithPaginationInfo(String brandId, String templateName, String language) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getEmailDefaultContent");
                }
        
                // verify the required parameter 'templateName' is set
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling getEmailDefaultContent");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailDefaultContent> localReturnType = new ParameterizedTypeReference<EmailDefaultContent>() {};
            ResponseEntity<EmailDefaultContent> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/default-content", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Preview of the Email Template Default Content
        * Generates a preview of an email template&#39;s default content. All variable references (e.g., &#x60;${user.profile.firstName}&#x60;) are populated using the current user&#39;s context.
            * <p><b>200</b> - Successfully generated a preview of the email template&#39;s default content.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param language The language to use for the email. Defaults to the current user&#39;s language if unspecified. (optional)
                * @return EmailPreview
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public EmailPreview getEmailDefaultPreview(String brandId, String templateName, String language) throws RestClientException {
                return getEmailDefaultPreviewWithHttpInfo(brandId, templateName, language).getBody();
            }






            /**
            * Retrieve a Preview of the Email Template Default Content
            * Generates a preview of an email template&#39;s default content. All variable references (e.g., &#x60;${user.profile.firstName}&#x60;) are populated using the current user&#39;s context.
                * <p><b>200</b> - Successfully generated a preview of the email template&#39;s default content.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param language The language to use for the email. Defaults to the current user&#39;s language if unspecified. (optional)
            * @return ResponseEntity&lt;EmailPreview&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<EmailPreview> getEmailDefaultPreviewWithHttpInfo(String brandId, String templateName, String language) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getEmailDefaultPreview");
                }
        
                // verify the required parameter 'templateName' is set ''
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling getEmailDefaultPreview");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailPreview> localReturnType = new ParameterizedTypeReference<EmailPreview>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/default-content/preview", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Preview of the Email Template Default Content
            * Generates a preview of an email template&#39;s default content. All variable references (e.g., &#x60;${user.profile.firstName}&#x60;) are populated using the current user&#39;s context.
                * <p><b>200</b> - Successfully generated a preview of the email template&#39;s default content.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param language The language to use for the email. Defaults to the current user&#39;s language if unspecified. (optional)
            * @return ResponseEntity&lt;EmailPreview&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getEmailDefaultPreviewWithPaginationInfo(String brandId, String templateName, String language) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getEmailDefaultPreview");
                }
        
                // verify the required parameter 'templateName' is set
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling getEmailDefaultPreview");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailPreview> localReturnType = new ParameterizedTypeReference<EmailPreview>() {};
            ResponseEntity<EmailPreview> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/default-content/preview", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the Email Template Settings
        * Retrieves an email template&#39;s settings
            * <p><b>200</b> - Successfully retrieved the email template&#39;s settings.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @return EmailSettings
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public EmailSettings getEmailSettings(String brandId, String templateName) throws RestClientException {
                return getEmailSettingsWithHttpInfo(brandId, templateName).getBody();
            }






            /**
            * Retrieve the Email Template Settings
            * Retrieves an email template&#39;s settings
                * <p><b>200</b> - Successfully retrieved the email template&#39;s settings.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
            * @return ResponseEntity&lt;EmailSettings&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<EmailSettings> getEmailSettingsWithHttpInfo(String brandId, String templateName) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getEmailSettings");
                }
        
                // verify the required parameter 'templateName' is set ''
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling getEmailSettings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailSettings> localReturnType = new ParameterizedTypeReference<EmailSettings>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/settings", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the Email Template Settings
            * Retrieves an email template&#39;s settings
                * <p><b>200</b> - Successfully retrieved the email template&#39;s settings.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
            * @return ResponseEntity&lt;EmailSettings&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getEmailSettingsWithPaginationInfo(String brandId, String templateName) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getEmailSettings");
                }
        
                // verify the required parameter 'templateName' is set
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling getEmailSettings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailSettings> localReturnType = new ParameterizedTypeReference<EmailSettings>() {};
            ResponseEntity<EmailSettings> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/settings", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve an Email Template
        * Retrieves the details of an email template by name
            * <p><b>200</b> - Successfully retrieved the email template.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param expand Specifies additional metadata to be included in the response. (optional)
                * @return EmailTemplate
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public EmailTemplate getEmailTemplate(String brandId, String templateName, List<String> expand) throws RestClientException {
                return getEmailTemplateWithHttpInfo(brandId, templateName, expand).getBody();
            }






            /**
            * Retrieve an Email Template
            * Retrieves the details of an email template by name
                * <p><b>200</b> - Successfully retrieved the email template.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param expand Specifies additional metadata to be included in the response. (optional)
            * @return ResponseEntity&lt;EmailTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<EmailTemplate> getEmailTemplateWithHttpInfo(String brandId, String templateName, List<String> expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getEmailTemplate");
                }
        
                // verify the required parameter 'templateName' is set ''
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling getEmailTemplate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailTemplate> localReturnType = new ParameterizedTypeReference<EmailTemplate>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve an Email Template
            * Retrieves the details of an email template by name
                * <p><b>200</b> - Successfully retrieved the email template.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param expand Specifies additional metadata to be included in the response. (optional)
            * @return ResponseEntity&lt;EmailTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getEmailTemplateWithPaginationInfo(String brandId, String templateName, List<String> expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getEmailTemplate");
                }
        
                // verify the required parameter 'templateName' is set
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling getEmailTemplate");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailTemplate> localReturnType = new ParameterizedTypeReference<EmailTemplate>() {};
            ResponseEntity<EmailTemplate> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the Error Page
        * Retrieves the error page
            * <p><b>200</b> - Successfully retrieved the error page.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param expand Specifies additional metadata to be included in the response. (optional)
                * @return PageRoot
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PageRoot getErrorPage(String brandId, List<String> expand) throws RestClientException {
                return getErrorPageWithHttpInfo(brandId, expand).getBody();
            }






            /**
            * Retrieve the Error Page
            * Retrieves the error page
                * <p><b>200</b> - Successfully retrieved the error page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param expand Specifies additional metadata to be included in the response. (optional)
            * @return ResponseEntity&lt;PageRoot&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<PageRoot> getErrorPageWithHttpInfo(String brandId, List<String> expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PageRoot> localReturnType = new ParameterizedTypeReference<PageRoot>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the Error Page
            * Retrieves the error page
                * <p><b>200</b> - Successfully retrieved the error page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param expand Specifies additional metadata to be included in the response. (optional)
            * @return ResponseEntity&lt;PageRoot&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getErrorPageWithPaginationInfo(String brandId, List<String> expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PageRoot> localReturnType = new ParameterizedTypeReference<PageRoot>() {};
            ResponseEntity<PageRoot> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the Preview Error Page Preview
        * Retrieves the preview error page
            * <p><b>200</b> - Successfully retrieved the preview error page.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @return CustomizablePage
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public CustomizablePage getPreviewErrorPage(String brandId) throws RestClientException {
                return getPreviewErrorPageWithHttpInfo(brandId).getBody();
            }






            /**
            * Retrieve the Preview Error Page Preview
            * Retrieves the preview error page
                * <p><b>200</b> - Successfully retrieved the preview error page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;CustomizablePage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<CustomizablePage> getPreviewErrorPageWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getPreviewErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CustomizablePage> localReturnType = new ParameterizedTypeReference<CustomizablePage>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/preview", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the Preview Error Page Preview
            * Retrieves the preview error page
                * <p><b>200</b> - Successfully retrieved the preview error page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;CustomizablePage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getPreviewErrorPageWithPaginationInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getPreviewErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CustomizablePage> localReturnType = new ParameterizedTypeReference<CustomizablePage>() {};
            ResponseEntity<CustomizablePage> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/preview", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the Preview Sign-in Page Preview
        * Retrieves the preview sign-in page
            * <p><b>200</b> - Successfully retrieved the preview sign-in page.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @return SignInPage
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public SignInPage getPreviewSignInPage(String brandId) throws RestClientException {
                return getPreviewSignInPageWithHttpInfo(brandId).getBody();
            }






            /**
            * Retrieve the Preview Sign-in Page Preview
            * Retrieves the preview sign-in page
                * <p><b>200</b> - Successfully retrieved the preview sign-in page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;SignInPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<SignInPage> getPreviewSignInPageWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getPreviewSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SignInPage> localReturnType = new ParameterizedTypeReference<SignInPage>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/preview", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the Preview Sign-in Page Preview
            * Retrieves the preview sign-in page
                * <p><b>200</b> - Successfully retrieved the preview sign-in page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;SignInPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getPreviewSignInPageWithPaginationInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getPreviewSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SignInPage> localReturnType = new ParameterizedTypeReference<SignInPage>() {};
            ResponseEntity<SignInPage> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/preview", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the Sign-in Page
        * Retrieves the sign-in page
            * <p><b>200</b> - Successfully retrieved the sign-in page.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param expand Specifies additional metadata to be included in the response. (optional)
                * @return PageRoot
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PageRoot getSignInPage(String brandId, List<String> expand) throws RestClientException {
                return getSignInPageWithHttpInfo(brandId, expand).getBody();
            }






            /**
            * Retrieve the Sign-in Page
            * Retrieves the sign-in page
                * <p><b>200</b> - Successfully retrieved the sign-in page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param expand Specifies additional metadata to be included in the response. (optional)
            * @return ResponseEntity&lt;PageRoot&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<PageRoot> getSignInPageWithHttpInfo(String brandId, List<String> expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PageRoot> localReturnType = new ParameterizedTypeReference<PageRoot>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the Sign-in Page
            * Retrieves the sign-in page
                * <p><b>200</b> - Successfully retrieved the sign-in page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param expand Specifies additional metadata to be included in the response. (optional)
            * @return ResponseEntity&lt;PageRoot&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getSignInPageWithPaginationInfo(String brandId, List<String> expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<PageRoot> localReturnType = new ParameterizedTypeReference<PageRoot>() {};
            ResponseEntity<PageRoot> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the Sign-out Page Settings
        * Retrieves the sign-out page settings
            * <p><b>200</b> - Successfully retrieved the sign-out page settings.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @return HostedPage
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public HostedPage getSignOutPageSettings(String brandId) throws RestClientException {
                return getSignOutPageSettingsWithHttpInfo(brandId).getBody();
            }






            /**
            * Retrieve the Sign-out Page Settings
            * Retrieves the sign-out page settings
                * <p><b>200</b> - Successfully retrieved the sign-out page settings.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;HostedPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<HostedPage> getSignOutPageSettingsWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getSignOutPageSettings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<HostedPage> localReturnType = new ParameterizedTypeReference<HostedPage>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-out/customized", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the Sign-out Page Settings
            * Retrieves the sign-out page settings
                * <p><b>200</b> - Successfully retrieved the sign-out page settings.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;HostedPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getSignOutPageSettingsWithPaginationInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling getSignOutPageSettings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<HostedPage> localReturnType = new ParameterizedTypeReference<HostedPage>() {};
            ResponseEntity<HostedPage> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-out/customized", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Link a Brand to a Domain
        * Link a Brand to a Domain by &#x60;domainId&#x60;
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>409</b> - Conflict
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param createBrandDomainRequest  (optional)
                * @return BrandDomain
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public BrandDomain linkBrandDomain(String brandId, CreateBrandDomainRequest createBrandDomainRequest) throws RestClientException {
                return linkBrandDomainWithHttpInfo(brandId, createBrandDomainRequest).getBody();
            }




            /**
            * Link a Brand to a Domain
            * Link a Brand to a Domain by &#x60;domainId&#x60;
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Conflict
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param brandId The ID of the brand. (required)
                * @param createBrandDomainRequest  (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T linkBrandDomain(Class<?> T, String brandId, CreateBrandDomainRequest createBrandDomainRequest) throws RestClientException {
                return (T) getObjectMapper().convertValue(linkBrandDomainWithReturnType(T, brandId, createBrandDomainRequest).getBody(), T);
            }




            /**
            * Link a Brand to a Domain
            * Link a Brand to a Domain by &#x60;domainId&#x60;
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Conflict
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param createBrandDomainRequest  (optional)
            * @return ResponseEntity&lt;BrandDomain&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<BrandDomain> linkBrandDomainWithHttpInfo(String brandId, CreateBrandDomainRequest createBrandDomainRequest) throws RestClientException {
            Object localVarPostBody = createBrandDomainRequest;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling linkBrandDomain");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<BrandDomain> localReturnType = new ParameterizedTypeReference<BrandDomain>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/domains", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Link a Brand to a Domain
            * Link a Brand to a Domain by &#x60;domainId&#x60;
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Conflict
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param createBrandDomainRequest  (optional)
            * @return ResponseEntity&lt;BrandDomain&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> linkBrandDomainWithReturnType(Class<?> T, String brandId,CreateBrandDomainRequest createBrandDomainRequest) throws RestClientException {
            Object localVarPostBody = createBrandDomainRequest;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling linkBrandDomain");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/domains", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Link a Brand to a Domain
            * Link a Brand to a Domain by &#x60;domainId&#x60;
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Conflict
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param createBrandDomainRequest  (optional)
            * @return ResponseEntity&lt;BrandDomain&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList linkBrandDomainWithPaginationInfo(String brandId, CreateBrandDomainRequest createBrandDomainRequest) throws RestClientException {
            Object localVarPostBody = createBrandDomainRequest;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling linkBrandDomain");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<BrandDomain> localReturnType = new ParameterizedTypeReference<BrandDomain>() {};
            ResponseEntity<BrandDomain> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/domains", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Sign-in Widget Versions
        * Lists all sign-in widget versions
            * <p><b>200</b> - Successfully listed the sign-in widget versions.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @return List&lt;String&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<String> listAllSignInWidgetVersions(String brandId) throws RestClientException {
                return listAllSignInWidgetVersionsWithHttpInfo(brandId).getBody();
            }






            /**
            * List all Sign-in Widget Versions
            * Lists all sign-in widget versions
                * <p><b>200</b> - Successfully listed the sign-in widget versions.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;List&lt;String&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<String>> listAllSignInWidgetVersionsWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling listAllSignInWidgetVersions");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<String>> localReturnType = new ParameterizedTypeReference<List<String>>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/widget-versions", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Sign-in Widget Versions
            * Lists all sign-in widget versions
                * <p><b>200</b> - Successfully listed the sign-in widget versions.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;List&lt;String&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listAllSignInWidgetVersionsWithPaginationInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling listAllSignInWidgetVersions");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<String>> localReturnType = new ParameterizedTypeReference<List<String>>() {};
            ResponseEntity<List<String>> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/widget-versions", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Domains associated with a Brand
        * Lists all domains associated with a brand by &#x60;brandId&#x60;
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @return List&lt;DomainResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<DomainResponse> listBrandDomains(String brandId) throws RestClientException {
                return listBrandDomainsWithHttpInfo(brandId).getBody();
            }






            /**
            * List all Domains associated with a Brand
            * Lists all domains associated with a brand by &#x60;brandId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;List&lt;DomainResponse&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<DomainResponse>> listBrandDomainsWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling listBrandDomains");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<DomainResponse>> localReturnType = new ParameterizedTypeReference<List<DomainResponse>>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/domains", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Domains associated with a Brand
            * Lists all domains associated with a brand by &#x60;brandId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;List&lt;DomainResponse&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listBrandDomainsWithPaginationInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling listBrandDomains");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<DomainResponse>> localReturnType = new ParameterizedTypeReference<List<DomainResponse>>() {};
            ResponseEntity<List<DomainResponse>> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/domains", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Themes
        * Lists all the themes in your brand
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @return List&lt;ThemeResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<ThemeResponse> listBrandThemes(String brandId) throws RestClientException {
                return listBrandThemesWithHttpInfo(brandId).getBody();
            }






            /**
            * List all Themes
            * Lists all the themes in your brand
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;List&lt;ThemeResponse&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<ThemeResponse>> listBrandThemesWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling listBrandThemes");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<ThemeResponse>> localReturnType = new ParameterizedTypeReference<List<ThemeResponse>>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/themes", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Themes
            * Lists all the themes in your brand
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;List&lt;ThemeResponse&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listBrandThemesWithPaginationInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling listBrandThemes");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<ThemeResponse>> localReturnType = new ParameterizedTypeReference<List<ThemeResponse>>() {};
            ResponseEntity<List<ThemeResponse>> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/themes", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Brands
        * Lists all the brands in your org
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @return List&lt;Brand&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<Brand> listBrands() throws RestClientException {
                return listBrandsWithHttpInfo().getBody();
            }






            /**
            * List all Brands
            * Lists all the brands in your org
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;List&lt;Brand&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<Brand>> listBrandsWithHttpInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Brand>> localReturnType = new ParameterizedTypeReference<List<Brand>>() {};
            return apiClient.invokeAPI("/api/v1/brands", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Brands
            * Lists all the brands in your org
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;List&lt;Brand&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listBrandsWithPaginationInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Brand>> localReturnType = new ParameterizedTypeReference<List<Brand>>() {};
            ResponseEntity<List<Brand>> responseEntity = apiClient.invokeAPI("/api/v1/brands", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Email Customizations
        * Lists all customizations of an email template
            * <p><b>200</b> - Successfully retrieved all email customizations for the specified email template.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @param limit A limit on the number of objects to return. (optional, default to 20)
                * @return List&lt;EmailCustomization&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<EmailCustomization> listEmailCustomizations(String brandId, String templateName, String after, Integer limit) throws RestClientException {
                return listEmailCustomizationsWithHttpInfo(brandId, templateName, after, limit).getBody();
            }






            /**
            * List all Email Customizations
            * Lists all customizations of an email template
                * <p><b>200</b> - Successfully retrieved all email customizations for the specified email template.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @param limit A limit on the number of objects to return. (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;EmailCustomization&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<EmailCustomization>> listEmailCustomizationsWithHttpInfo(String brandId, String templateName, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling listEmailCustomizations");
                }
        
                // verify the required parameter 'templateName' is set ''
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling listEmailCustomizations");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<EmailCustomization>> localReturnType = new ParameterizedTypeReference<List<EmailCustomization>>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Email Customizations
            * Lists all customizations of an email template
                * <p><b>200</b> - Successfully retrieved all email customizations for the specified email template.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @param limit A limit on the number of objects to return. (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;EmailCustomization&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listEmailCustomizationsWithPaginationInfo(String brandId, String templateName, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling listEmailCustomizations");
                }
        
                // verify the required parameter 'templateName' is set
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling listEmailCustomizations");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<EmailCustomization>> localReturnType = new ParameterizedTypeReference<List<EmailCustomization>>() {};
            ResponseEntity<List<EmailCustomization>> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Email Templates
        * Lists all email templates
            * <p><b>200</b> - Successfully returned the list of email templates.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @param limit A limit on the number of objects to return. (optional, default to 20)
                * @param expand Specifies additional metadata to be included in the response. (optional)
                * @return List&lt;EmailTemplate&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<EmailTemplate> listEmailTemplates(String brandId, String after, Integer limit, List<String> expand) throws RestClientException {
                return listEmailTemplatesWithHttpInfo(brandId, after, limit, expand).getBody();
            }






            /**
            * List all Email Templates
            * Lists all email templates
                * <p><b>200</b> - Successfully returned the list of email templates.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @param limit A limit on the number of objects to return. (optional, default to 20)
                * @param expand Specifies additional metadata to be included in the response. (optional)
            * @return ResponseEntity&lt;List&lt;EmailTemplate&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<EmailTemplate>> listEmailTemplatesWithHttpInfo(String brandId, String after, Integer limit, List<String> expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling listEmailTemplates");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<EmailTemplate>> localReturnType = new ParameterizedTypeReference<List<EmailTemplate>>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Email Templates
            * Lists all email templates
                * <p><b>200</b> - Successfully returned the list of email templates.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param after The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](/#pagination) for more information. (optional)
                * @param limit A limit on the number of objects to return. (optional, default to 20)
                * @param expand Specifies additional metadata to be included in the response. (optional)
            * @return ResponseEntity&lt;List&lt;EmailTemplate&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listEmailTemplatesWithPaginationInfo(String brandId, String after, Integer limit, List<String> expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling listEmailTemplates");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("csv".toUpperCase(Locale.ROOT)), "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<EmailTemplate>> localReturnType = new ParameterizedTypeReference<List<EmailTemplate>>() {};
            ResponseEntity<List<EmailTemplate>> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace a Brand
        * Replaces a brand by &#x60;brandId&#x60;
            * <p><b>200</b> - OK
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param brand  (required)
                * @return Brand
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Brand replaceBrand(String brandId, BrandRequest brand) throws RestClientException {
                return replaceBrandWithHttpInfo(brandId, brand).getBody();
            }




            /**
            * Replace a Brand
            * Replaces a brand by &#x60;brandId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param brandId The ID of the brand. (required)
                * @param brand  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceBrand(Class<?> T, String brandId, BrandRequest brand) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceBrandWithReturnType(T, brandId, brand).getBody(), T);
            }




            /**
            * Replace a Brand
            * Replaces a brand by &#x60;brandId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param brand  (required)
            * @return ResponseEntity&lt;Brand&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Brand> replaceBrandWithHttpInfo(String brandId, BrandRequest brand) throws RestClientException {
            Object localVarPostBody = brand;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceBrand");
                }
        
                // verify the required parameter 'brand' is set ''
                if (brand == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brand' when calling replaceBrand");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Brand> localReturnType = new ParameterizedTypeReference<Brand>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Brand
            * Replaces a brand by &#x60;brandId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param brand  (required)
            * @return ResponseEntity&lt;Brand&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceBrandWithReturnType(Class<?> T, String brandId,BrandRequest brand) throws RestClientException {
            Object localVarPostBody = brand;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceBrand");
                }
        
                // verify the required parameter 'brand' is set
                if (brand == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brand' when calling replaceBrand");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Brand
            * Replaces a brand by &#x60;brandId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param brand  (required)
            * @return ResponseEntity&lt;Brand&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceBrandWithPaginationInfo(String brandId, BrandRequest brand) throws RestClientException {
            Object localVarPostBody = brand;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceBrand");
                }
        
                // verify the required parameter 'brand' is set
                if (brand == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brand' when calling replaceBrand");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Brand> localReturnType = new ParameterizedTypeReference<Brand>() {};
            ResponseEntity<Brand> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace a Theme
        * Replaces a theme for a brand
            * <p><b>200</b> - OK
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param theme  (required)
                * @return ThemeResponse
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ThemeResponse replaceBrandTheme(String brandId, String themeId, Theme theme) throws RestClientException {
                return replaceBrandThemeWithHttpInfo(brandId, themeId, theme).getBody();
            }




            /**
            * Replace a Theme
            * Replaces a theme for a brand
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param theme  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceBrandTheme(Class<?> T, String brandId, String themeId, Theme theme) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceBrandThemeWithReturnType(T, brandId, themeId, theme).getBody(), T);
            }




            /**
            * Replace a Theme
            * Replaces a theme for a brand
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param theme  (required)
            * @return ResponseEntity&lt;ThemeResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ThemeResponse> replaceBrandThemeWithHttpInfo(String brandId, String themeId, Theme theme) throws RestClientException {
            Object localVarPostBody = theme;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceBrandTheme");
                }
        
                // verify the required parameter 'themeId' is set ''
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling replaceBrandTheme");
                }
        
                // verify the required parameter 'theme' is set ''
                if (theme == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'theme' when calling replaceBrandTheme");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ThemeResponse> localReturnType = new ParameterizedTypeReference<ThemeResponse>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Theme
            * Replaces a theme for a brand
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param theme  (required)
            * @return ResponseEntity&lt;ThemeResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceBrandThemeWithReturnType(Class<?> T, String brandId,String themeId,Theme theme) throws RestClientException {
            Object localVarPostBody = theme;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceBrandTheme");
                }
        
                // verify the required parameter 'themeId' is set
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling replaceBrandTheme");
                }
        
                // verify the required parameter 'theme' is set
                if (theme == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'theme' when calling replaceBrandTheme");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a Theme
            * Replaces a theme for a brand
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param theme  (required)
            * @return ResponseEntity&lt;ThemeResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceBrandThemeWithPaginationInfo(String brandId, String themeId, Theme theme) throws RestClientException {
            Object localVarPostBody = theme;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceBrandTheme");
                }
        
                // verify the required parameter 'themeId' is set
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling replaceBrandTheme");
                }
        
                // verify the required parameter 'theme' is set
                if (theme == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'theme' when calling replaceBrandTheme");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ThemeResponse> localReturnType = new ParameterizedTypeReference<ThemeResponse>() {};
            ResponseEntity<ThemeResponse> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace the Customized Error Page
        * Replaces the customized error page
            * <p><b>200</b> - Successfully replaced the customized error page.
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param customizablePage  (required)
                * @return CustomizablePage
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public CustomizablePage replaceCustomizedErrorPage(String brandId, CustomizablePage customizablePage) throws RestClientException {
                return replaceCustomizedErrorPageWithHttpInfo(brandId, customizablePage).getBody();
            }




            /**
            * Replace the Customized Error Page
            * Replaces the customized error page
                * <p><b>200</b> - Successfully replaced the customized error page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param brandId The ID of the brand. (required)
                * @param customizablePage  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceCustomizedErrorPage(Class<?> T, String brandId, CustomizablePage customizablePage) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceCustomizedErrorPageWithReturnType(T, brandId, customizablePage).getBody(), T);
            }




            /**
            * Replace the Customized Error Page
            * Replaces the customized error page
                * <p><b>200</b> - Successfully replaced the customized error page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param customizablePage  (required)
            * @return ResponseEntity&lt;CustomizablePage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<CustomizablePage> replaceCustomizedErrorPageWithHttpInfo(String brandId, CustomizablePage customizablePage) throws RestClientException {
            Object localVarPostBody = customizablePage;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceCustomizedErrorPage");
                }
        
                // verify the required parameter 'customizablePage' is set ''
                if (customizablePage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizablePage' when calling replaceCustomizedErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CustomizablePage> localReturnType = new ParameterizedTypeReference<CustomizablePage>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/customized", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Customized Error Page
            * Replaces the customized error page
                * <p><b>200</b> - Successfully replaced the customized error page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param customizablePage  (required)
            * @return ResponseEntity&lt;CustomizablePage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceCustomizedErrorPageWithReturnType(Class<?> T, String brandId,CustomizablePage customizablePage) throws RestClientException {
            Object localVarPostBody = customizablePage;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceCustomizedErrorPage");
                }
        
                // verify the required parameter 'customizablePage' is set
                if (customizablePage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizablePage' when calling replaceCustomizedErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/customized", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Customized Error Page
            * Replaces the customized error page
                * <p><b>200</b> - Successfully replaced the customized error page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param customizablePage  (required)
            * @return ResponseEntity&lt;CustomizablePage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceCustomizedErrorPageWithPaginationInfo(String brandId, CustomizablePage customizablePage) throws RestClientException {
            Object localVarPostBody = customizablePage;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceCustomizedErrorPage");
                }
        
                // verify the required parameter 'customizablePage' is set
                if (customizablePage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizablePage' when calling replaceCustomizedErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CustomizablePage> localReturnType = new ParameterizedTypeReference<CustomizablePage>() {};
            ResponseEntity<CustomizablePage> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/customized", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace the Customized Sign-in Page
        * Replaces the customized sign-in page
            * <p><b>200</b> - Successfully replaced the customized sign-in page.
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param signInPage  (required)
                * @return SignInPage
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public SignInPage replaceCustomizedSignInPage(String brandId, SignInPage signInPage) throws RestClientException {
                return replaceCustomizedSignInPageWithHttpInfo(brandId, signInPage).getBody();
            }




            /**
            * Replace the Customized Sign-in Page
            * Replaces the customized sign-in page
                * <p><b>200</b> - Successfully replaced the customized sign-in page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param brandId The ID of the brand. (required)
                * @param signInPage  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceCustomizedSignInPage(Class<?> T, String brandId, SignInPage signInPage) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceCustomizedSignInPageWithReturnType(T, brandId, signInPage).getBody(), T);
            }




            /**
            * Replace the Customized Sign-in Page
            * Replaces the customized sign-in page
                * <p><b>200</b> - Successfully replaced the customized sign-in page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param signInPage  (required)
            * @return ResponseEntity&lt;SignInPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<SignInPage> replaceCustomizedSignInPageWithHttpInfo(String brandId, SignInPage signInPage) throws RestClientException {
            Object localVarPostBody = signInPage;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceCustomizedSignInPage");
                }
        
                // verify the required parameter 'signInPage' is set ''
                if (signInPage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'signInPage' when calling replaceCustomizedSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SignInPage> localReturnType = new ParameterizedTypeReference<SignInPage>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/customized", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Customized Sign-in Page
            * Replaces the customized sign-in page
                * <p><b>200</b> - Successfully replaced the customized sign-in page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param signInPage  (required)
            * @return ResponseEntity&lt;SignInPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceCustomizedSignInPageWithReturnType(Class<?> T, String brandId,SignInPage signInPage) throws RestClientException {
            Object localVarPostBody = signInPage;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceCustomizedSignInPage");
                }
        
                // verify the required parameter 'signInPage' is set
                if (signInPage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'signInPage' when calling replaceCustomizedSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/customized", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Customized Sign-in Page
            * Replaces the customized sign-in page
                * <p><b>200</b> - Successfully replaced the customized sign-in page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param signInPage  (required)
            * @return ResponseEntity&lt;SignInPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceCustomizedSignInPageWithPaginationInfo(String brandId, SignInPage signInPage) throws RestClientException {
            Object localVarPostBody = signInPage;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceCustomizedSignInPage");
                }
        
                // verify the required parameter 'signInPage' is set
                if (signInPage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'signInPage' when calling replaceCustomizedSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SignInPage> localReturnType = new ParameterizedTypeReference<SignInPage>() {};
            ResponseEntity<SignInPage> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/customized", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace an Email Customization
        * Replaces an existing email customization using the property values provided
            * <p><b>200</b> - Successfully updated the email customization.
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>409</b> - Could not update the email customization because the update would cause a conflict with an existing email customization.
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param customizationId The ID of the email customization. (required)
                * @param instance Request (optional)
                * @return EmailCustomization
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public EmailCustomization replaceEmailCustomization(String brandId, String templateName, String customizationId, EmailCustomization instance) throws RestClientException {
                return replaceEmailCustomizationWithHttpInfo(brandId, templateName, customizationId, instance).getBody();
            }




            /**
            * Replace an Email Customization
            * Replaces an existing email customization using the property values provided
                * <p><b>200</b> - Successfully updated the email customization.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Could not update the email customization because the update would cause a conflict with an existing email customization.
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param customizationId The ID of the email customization. (required)
                * @param instance Request (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceEmailCustomization(Class<?> T, String brandId, String templateName, String customizationId, EmailCustomization instance) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceEmailCustomizationWithReturnType(T, brandId, templateName, customizationId, instance).getBody(), T);
            }




            /**
            * Replace an Email Customization
            * Replaces an existing email customization using the property values provided
                * <p><b>200</b> - Successfully updated the email customization.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Could not update the email customization because the update would cause a conflict with an existing email customization.
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param customizationId The ID of the email customization. (required)
                * @param instance Request (optional)
            * @return ResponseEntity&lt;EmailCustomization&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<EmailCustomization> replaceEmailCustomizationWithHttpInfo(String brandId, String templateName, String customizationId, EmailCustomization instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceEmailCustomization");
                }
        
                // verify the required parameter 'templateName' is set ''
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling replaceEmailCustomization");
                }
        
                // verify the required parameter 'customizationId' is set ''
                if (customizationId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizationId' when calling replaceEmailCustomization");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);
                    uriVariables.put("customizationId", customizationId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailCustomization> localReturnType = new ParameterizedTypeReference<EmailCustomization>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace an Email Customization
            * Replaces an existing email customization using the property values provided
                * <p><b>200</b> - Successfully updated the email customization.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Could not update the email customization because the update would cause a conflict with an existing email customization.
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param customizationId The ID of the email customization. (required)
                * @param instance Request (optional)
            * @return ResponseEntity&lt;EmailCustomization&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceEmailCustomizationWithReturnType(Class<?> T, String brandId,String templateName,String customizationId,EmailCustomization instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceEmailCustomization");
                }
        
                // verify the required parameter 'templateName' is set
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling replaceEmailCustomization");
                }
        
                // verify the required parameter 'customizationId' is set
                if (customizationId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizationId' when calling replaceEmailCustomization");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);
                    uriVariables.put("customizationId", customizationId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace an Email Customization
            * Replaces an existing email customization using the property values provided
                * <p><b>200</b> - Successfully updated the email customization.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>409</b> - Could not update the email customization because the update would cause a conflict with an existing email customization.
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param customizationId The ID of the email customization. (required)
                * @param instance Request (optional)
            * @return ResponseEntity&lt;EmailCustomization&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceEmailCustomizationWithPaginationInfo(String brandId, String templateName, String customizationId, EmailCustomization instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceEmailCustomization");
                }
        
                // verify the required parameter 'templateName' is set
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling replaceEmailCustomization");
                }
        
                // verify the required parameter 'customizationId' is set
                if (customizationId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizationId' when calling replaceEmailCustomization");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);
                    uriVariables.put("customizationId", customizationId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<EmailCustomization> localReturnType = new ParameterizedTypeReference<EmailCustomization>() {};
            ResponseEntity<EmailCustomization> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace the Email Template Settings
        * Replaces an email template&#39;s settings
            * <p><b>204</b> - Successfully updated the email template&#39;s settings.
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>422</b> - Could not update the email template&#39;s settings due to an invalid setting value.
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param emailSettings  (optional)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void replaceEmailSettings(String brandId, String templateName, EmailSettings emailSettings) throws RestClientException {
            replaceEmailSettingsWithHttpInfo(brandId, templateName, emailSettings);
            }




            /**
            * Replace the Email Template Settings
            * Replaces an email template&#39;s settings
                * <p><b>204</b> - Successfully updated the email template&#39;s settings.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>422</b> - Could not update the email template&#39;s settings due to an invalid setting value.
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param emailSettings  (optional)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void replaceEmailSettings(Class<?> T, String brandId, String templateName, EmailSettings emailSettings) throws RestClientException {
            replaceEmailSettingsWithHttpInfo(brandId, templateName, emailSettings);
            }




            /**
            * Replace the Email Template Settings
            * Replaces an email template&#39;s settings
                * <p><b>204</b> - Successfully updated the email template&#39;s settings.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>422</b> - Could not update the email template&#39;s settings due to an invalid setting value.
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param emailSettings  (optional)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> replaceEmailSettingsWithHttpInfo(String brandId, String templateName, EmailSettings emailSettings) throws RestClientException {
            Object localVarPostBody = emailSettings;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceEmailSettings");
                }
        
                // verify the required parameter 'templateName' is set ''
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling replaceEmailSettings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/settings", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Replace the Preview Error Page
        * Replace the preview error page
            * <p><b>200</b> - Successfully replaced the preview error page.
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param customizablePage  (required)
                * @return CustomizablePage
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public CustomizablePage replacePreviewErrorPage(String brandId, CustomizablePage customizablePage) throws RestClientException {
                return replacePreviewErrorPageWithHttpInfo(brandId, customizablePage).getBody();
            }




            /**
            * Replace the Preview Error Page
            * Replace the preview error page
                * <p><b>200</b> - Successfully replaced the preview error page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param brandId The ID of the brand. (required)
                * @param customizablePage  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replacePreviewErrorPage(Class<?> T, String brandId, CustomizablePage customizablePage) throws RestClientException {
                return (T) getObjectMapper().convertValue(replacePreviewErrorPageWithReturnType(T, brandId, customizablePage).getBody(), T);
            }




            /**
            * Replace the Preview Error Page
            * Replace the preview error page
                * <p><b>200</b> - Successfully replaced the preview error page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param customizablePage  (required)
            * @return ResponseEntity&lt;CustomizablePage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<CustomizablePage> replacePreviewErrorPageWithHttpInfo(String brandId, CustomizablePage customizablePage) throws RestClientException {
            Object localVarPostBody = customizablePage;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replacePreviewErrorPage");
                }
        
                // verify the required parameter 'customizablePage' is set ''
                if (customizablePage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizablePage' when calling replacePreviewErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CustomizablePage> localReturnType = new ParameterizedTypeReference<CustomizablePage>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/preview", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Preview Error Page
            * Replace the preview error page
                * <p><b>200</b> - Successfully replaced the preview error page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param customizablePage  (required)
            * @return ResponseEntity&lt;CustomizablePage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replacePreviewErrorPageWithReturnType(Class<?> T, String brandId,CustomizablePage customizablePage) throws RestClientException {
            Object localVarPostBody = customizablePage;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replacePreviewErrorPage");
                }
        
                // verify the required parameter 'customizablePage' is set
                if (customizablePage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizablePage' when calling replacePreviewErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/preview", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Preview Error Page
            * Replace the preview error page
                * <p><b>200</b> - Successfully replaced the preview error page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param customizablePage  (required)
            * @return ResponseEntity&lt;CustomizablePage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replacePreviewErrorPageWithPaginationInfo(String brandId, CustomizablePage customizablePage) throws RestClientException {
            Object localVarPostBody = customizablePage;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replacePreviewErrorPage");
                }
        
                // verify the required parameter 'customizablePage' is set
                if (customizablePage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'customizablePage' when calling replacePreviewErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CustomizablePage> localReturnType = new ParameterizedTypeReference<CustomizablePage>() {};
            ResponseEntity<CustomizablePage> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/preview", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace the Preview Sign-in Page
        * Replace the preview sign-in page
            * <p><b>200</b> - Successfully replaced the preview sign-in page.
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param signInPage  (required)
                * @return SignInPage
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public SignInPage replacePreviewSignInPage(String brandId, SignInPage signInPage) throws RestClientException {
                return replacePreviewSignInPageWithHttpInfo(brandId, signInPage).getBody();
            }




            /**
            * Replace the Preview Sign-in Page
            * Replace the preview sign-in page
                * <p><b>200</b> - Successfully replaced the preview sign-in page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param brandId The ID of the brand. (required)
                * @param signInPage  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replacePreviewSignInPage(Class<?> T, String brandId, SignInPage signInPage) throws RestClientException {
                return (T) getObjectMapper().convertValue(replacePreviewSignInPageWithReturnType(T, brandId, signInPage).getBody(), T);
            }




            /**
            * Replace the Preview Sign-in Page
            * Replace the preview sign-in page
                * <p><b>200</b> - Successfully replaced the preview sign-in page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param signInPage  (required)
            * @return ResponseEntity&lt;SignInPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<SignInPage> replacePreviewSignInPageWithHttpInfo(String brandId, SignInPage signInPage) throws RestClientException {
            Object localVarPostBody = signInPage;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replacePreviewSignInPage");
                }
        
                // verify the required parameter 'signInPage' is set ''
                if (signInPage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'signInPage' when calling replacePreviewSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SignInPage> localReturnType = new ParameterizedTypeReference<SignInPage>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/preview", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Preview Sign-in Page
            * Replace the preview sign-in page
                * <p><b>200</b> - Successfully replaced the preview sign-in page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param signInPage  (required)
            * @return ResponseEntity&lt;SignInPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replacePreviewSignInPageWithReturnType(Class<?> T, String brandId,SignInPage signInPage) throws RestClientException {
            Object localVarPostBody = signInPage;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replacePreviewSignInPage");
                }
        
                // verify the required parameter 'signInPage' is set
                if (signInPage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'signInPage' when calling replacePreviewSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/preview", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Preview Sign-in Page
            * Replace the preview sign-in page
                * <p><b>200</b> - Successfully replaced the preview sign-in page.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param signInPage  (required)
            * @return ResponseEntity&lt;SignInPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replacePreviewSignInPageWithPaginationInfo(String brandId, SignInPage signInPage) throws RestClientException {
            Object localVarPostBody = signInPage;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replacePreviewSignInPage");
                }
        
                // verify the required parameter 'signInPage' is set
                if (signInPage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'signInPage' when calling replacePreviewSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<SignInPage> localReturnType = new ParameterizedTypeReference<SignInPage>() {};
            ResponseEntity<SignInPage> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/preview", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace the Sign-out Page Settings
        * Replaces the sign-out page settings
            * <p><b>200</b> - Successfully replaced the sign-out page settings.
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param hostedPage  (required)
                * @return HostedPage
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public HostedPage replaceSignOutPageSettings(String brandId, HostedPage hostedPage) throws RestClientException {
                return replaceSignOutPageSettingsWithHttpInfo(brandId, hostedPage).getBody();
            }




            /**
            * Replace the Sign-out Page Settings
            * Replaces the sign-out page settings
                * <p><b>200</b> - Successfully replaced the sign-out page settings.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param brandId The ID of the brand. (required)
                * @param hostedPage  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceSignOutPageSettings(Class<?> T, String brandId, HostedPage hostedPage) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceSignOutPageSettingsWithReturnType(T, brandId, hostedPage).getBody(), T);
            }




            /**
            * Replace the Sign-out Page Settings
            * Replaces the sign-out page settings
                * <p><b>200</b> - Successfully replaced the sign-out page settings.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param hostedPage  (required)
            * @return ResponseEntity&lt;HostedPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<HostedPage> replaceSignOutPageSettingsWithHttpInfo(String brandId, HostedPage hostedPage) throws RestClientException {
            Object localVarPostBody = hostedPage;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceSignOutPageSettings");
                }
        
                // verify the required parameter 'hostedPage' is set ''
                if (hostedPage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'hostedPage' when calling replaceSignOutPageSettings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<HostedPage> localReturnType = new ParameterizedTypeReference<HostedPage>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-out/customized", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Sign-out Page Settings
            * Replaces the sign-out page settings
                * <p><b>200</b> - Successfully replaced the sign-out page settings.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param hostedPage  (required)
            * @return ResponseEntity&lt;HostedPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceSignOutPageSettingsWithReturnType(Class<?> T, String brandId,HostedPage hostedPage) throws RestClientException {
            Object localVarPostBody = hostedPage;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceSignOutPageSettings");
                }
        
                // verify the required parameter 'hostedPage' is set
                if (hostedPage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'hostedPage' when calling replaceSignOutPageSettings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-out/customized", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace the Sign-out Page Settings
            * Replaces the sign-out page settings
                * <p><b>200</b> - Successfully replaced the sign-out page settings.
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param hostedPage  (required)
            * @return ResponseEntity&lt;HostedPage&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceSignOutPageSettingsWithPaginationInfo(String brandId, HostedPage hostedPage) throws RestClientException {
            Object localVarPostBody = hostedPage;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling replaceSignOutPageSettings");
                }
        
                // verify the required parameter 'hostedPage' is set
                if (hostedPage == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'hostedPage' when calling replaceSignOutPageSettings");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<HostedPage> localReturnType = new ParameterizedTypeReference<HostedPage>() {};
            ResponseEntity<HostedPage> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-out/customized", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Reset the Customized Error Page
        * Resets the customized error page
            * <p><b>204</b> - Successfully reset the customized error page.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void resetCustomizedErrorPage(String brandId) throws RestClientException {
            resetCustomizedErrorPageWithHttpInfo(brandId);
            }






            /**
            * Reset the Customized Error Page
            * Resets the customized error page
                * <p><b>204</b> - Successfully reset the customized error page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> resetCustomizedErrorPageWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling resetCustomizedErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/customized", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Reset the Customized Sign-in Page
        * Reset the customized sign-in page
            * <p><b>204</b> - Successfully reset the sign-in page.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void resetCustomizedSignInPage(String brandId) throws RestClientException {
            resetCustomizedSignInPageWithHttpInfo(brandId);
            }






            /**
            * Reset the Customized Sign-in Page
            * Reset the customized sign-in page
                * <p><b>204</b> - Successfully reset the sign-in page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> resetCustomizedSignInPageWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling resetCustomizedSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/customized", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Reset the Preview Error Page
        * Reset the preview error page
            * <p><b>204</b> - Successfully reset the preview error page.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void resetPreviewErrorPage(String brandId) throws RestClientException {
            resetPreviewErrorPageWithHttpInfo(brandId);
            }






            /**
            * Reset the Preview Error Page
            * Reset the preview error page
                * <p><b>204</b> - Successfully reset the preview error page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> resetPreviewErrorPageWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling resetPreviewErrorPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/error/preview", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Reset the Preview Sign-in Page
        * Reset the preview sign-in page
            * <p><b>204</b> - Successfully reset the preview sign-in page.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void resetPreviewSignInPage(String brandId) throws RestClientException {
            resetPreviewSignInPageWithHttpInfo(brandId);
            }






            /**
            * Reset the Preview Sign-in Page
            * Reset the preview sign-in page
                * <p><b>204</b> - Successfully reset the preview sign-in page.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> resetPreviewSignInPageWithHttpInfo(String brandId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling resetPreviewSignInPage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/pages/sign-in/preview", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Send a Test Email
        * Sends a test email to the current user’s primary and secondary email addresses. The email content is selected based on the following priority: 1. The email customization for the language specified in the &#x60;language&#x60; query parameter. 2. The email template&#39;s default customization. 3. The email template’s default content, translated to the current user&#39;s language.
            * <p><b>204</b> - Successfully sent a test email.
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param language The language to use for the email. Defaults to the current user&#39;s language if unspecified. (optional)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void sendTestEmail(String brandId, String templateName, String language) throws RestClientException {
            sendTestEmailWithHttpInfo(brandId, templateName, language);
            }






            /**
            * Send a Test Email
            * Sends a test email to the current user’s primary and secondary email addresses. The email content is selected based on the following priority: 1. The email customization for the language specified in the &#x60;language&#x60; query parameter. 2. The email template&#39;s default customization. 3. The email template’s default content, translated to the current user&#39;s language.
                * <p><b>204</b> - Successfully sent a test email.
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param templateName The name of the email template. (required)
                * @param language The language to use for the email. Defaults to the current user&#39;s language if unspecified. (optional)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> sendTestEmailWithHttpInfo(String brandId, String templateName, String language) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling sendTestEmail");
                }
        
                // verify the required parameter 'templateName' is set ''
                if (templateName == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'templateName' when calling sendTestEmail");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("templateName", templateName);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "language", language));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/templates/email/{templateName}/test", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Unlink a Brand from a Domain
        * Unlink brand and domain by its unique identifier
            * <p><b>204</b> - Successfully unlinked the domain from the brand
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param domainId The ID of the domain. (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unlinkBrandDomain(String brandId, String domainId) throws RestClientException {
            unlinkBrandDomainWithHttpInfo(brandId, domainId);
            }






            /**
            * Unlink a Brand from a Domain
            * Unlink brand and domain by its unique identifier
                * <p><b>204</b> - Successfully unlinked the domain from the brand
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param domainId The ID of the domain. (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unlinkBrandDomainWithHttpInfo(String brandId, String domainId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling unlinkBrandDomain");
                }
        
                // verify the required parameter 'domainId' is set ''
                if (domainId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'domainId' when calling unlinkBrandDomain");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("domainId", domainId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/domains/{domainId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Upload the Background Image
        * Updates the background image for your Theme
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param _file  (required)
                * @return ImageUploadResponse
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ImageUploadResponse uploadBrandThemeBackgroundImage(String brandId, String themeId, File _file) throws RestClientException {
                return uploadBrandThemeBackgroundImageWithHttpInfo(brandId, themeId, _file).getBody();
            }






            /**
            * Upload the Background Image
            * Updates the background image for your Theme
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param _file  (required)
            * @return ResponseEntity&lt;ImageUploadResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ImageUploadResponse> uploadBrandThemeBackgroundImageWithHttpInfo(String brandId, String themeId, File _file) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling uploadBrandThemeBackgroundImage");
                }
        
                // verify the required parameter 'themeId' is set ''
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling uploadBrandThemeBackgroundImage");
                }
        
                // verify the required parameter '_file' is set ''
                if (_file == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter '_file' when calling uploadBrandThemeBackgroundImage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            if (_file != null)
                localVarFormParams.add("file", new FileSystemResource(_file));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "multipart/form-data"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ImageUploadResponse> localReturnType = new ParameterizedTypeReference<ImageUploadResponse>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}/background-image", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Upload the Background Image
            * Updates the background image for your Theme
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param _file  (required)
            * @return ResponseEntity&lt;ImageUploadResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList uploadBrandThemeBackgroundImageWithPaginationInfo(String brandId, String themeId, File _file) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling uploadBrandThemeBackgroundImage");
                }
        
                // verify the required parameter 'themeId' is set
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling uploadBrandThemeBackgroundImage");
                }
        
                // verify the required parameter '_file' is set
                if (_file == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter '_file' when calling uploadBrandThemeBackgroundImage");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            if (_file != null)
                localVarFormParams.add("file", new FileSystemResource(_file));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "multipart/form-data"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ImageUploadResponse> localReturnType = new ParameterizedTypeReference<ImageUploadResponse>() {};
            ResponseEntity<ImageUploadResponse> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}/background-image", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Upload the Favicon
        * Updates the favicon for your theme
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param _file  (required)
                * @return ImageUploadResponse
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ImageUploadResponse uploadBrandThemeFavicon(String brandId, String themeId, File _file) throws RestClientException {
                return uploadBrandThemeFaviconWithHttpInfo(brandId, themeId, _file).getBody();
            }






            /**
            * Upload the Favicon
            * Updates the favicon for your theme
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param _file  (required)
            * @return ResponseEntity&lt;ImageUploadResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ImageUploadResponse> uploadBrandThemeFaviconWithHttpInfo(String brandId, String themeId, File _file) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling uploadBrandThemeFavicon");
                }
        
                // verify the required parameter 'themeId' is set ''
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling uploadBrandThemeFavicon");
                }
        
                // verify the required parameter '_file' is set ''
                if (_file == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter '_file' when calling uploadBrandThemeFavicon");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            if (_file != null)
                localVarFormParams.add("file", new FileSystemResource(_file));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "multipart/form-data"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ImageUploadResponse> localReturnType = new ParameterizedTypeReference<ImageUploadResponse>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}/favicon", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Upload the Favicon
            * Updates the favicon for your theme
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param _file  (required)
            * @return ResponseEntity&lt;ImageUploadResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList uploadBrandThemeFaviconWithPaginationInfo(String brandId, String themeId, File _file) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling uploadBrandThemeFavicon");
                }
        
                // verify the required parameter 'themeId' is set
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling uploadBrandThemeFavicon");
                }
        
                // verify the required parameter '_file' is set
                if (_file == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter '_file' when calling uploadBrandThemeFavicon");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            if (_file != null)
                localVarFormParams.add("file", new FileSystemResource(_file));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "multipart/form-data"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ImageUploadResponse> localReturnType = new ParameterizedTypeReference<ImageUploadResponse>() {};
            ResponseEntity<ImageUploadResponse> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}/favicon", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Upload the Logo
        * Updates the logo for your Theme
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param _file  (required)
                * @return ImageUploadResponse
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ImageUploadResponse uploadBrandThemeLogo(String brandId, String themeId, File _file) throws RestClientException {
                return uploadBrandThemeLogoWithHttpInfo(brandId, themeId, _file).getBody();
            }






            /**
            * Upload the Logo
            * Updates the logo for your Theme
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param _file  (required)
            * @return ResponseEntity&lt;ImageUploadResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ImageUploadResponse> uploadBrandThemeLogoWithHttpInfo(String brandId, String themeId, File _file) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set ''
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling uploadBrandThemeLogo");
                }
        
                // verify the required parameter 'themeId' is set ''
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling uploadBrandThemeLogo");
                }
        
                // verify the required parameter '_file' is set ''
                if (_file == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter '_file' when calling uploadBrandThemeLogo");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            if (_file != null)
                localVarFormParams.add("file", new FileSystemResource(_file));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "multipart/form-data"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ImageUploadResponse> localReturnType = new ParameterizedTypeReference<ImageUploadResponse>() {};
            return apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}/logo", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Upload the Logo
            * Updates the logo for your Theme
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param brandId The ID of the brand. (required)
                * @param themeId The ID of the theme. (required)
                * @param _file  (required)
            * @return ResponseEntity&lt;ImageUploadResponse&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList uploadBrandThemeLogoWithPaginationInfo(String brandId, String themeId, File _file) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'brandId' is set
                if (brandId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'brandId' when calling uploadBrandThemeLogo");
                }
        
                // verify the required parameter 'themeId' is set
                if (themeId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'themeId' when calling uploadBrandThemeLogo");
                }
        
                // verify the required parameter '_file' is set
                if (_file == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter '_file' when calling uploadBrandThemeLogo");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("brandId", brandId);
                    uriVariables.put("themeId", themeId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            if (_file != null)
                localVarFormParams.add("file", new FileSystemResource(_file));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "multipart/form-data"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ImageUploadResponse> localReturnType = new ParameterizedTypeReference<ImageUploadResponse>() {};
            ResponseEntity<ImageUploadResponse> responseEntity = apiClient.invokeAPI("/api/v1/brands/{brandId}/themes/{themeId}/logo", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }


    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
