package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.CAPTCHAInstance;
import org.openapitools.client.model.Error;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.CaptchaApi")
    public class CaptchaApi {
    private ApiClient apiClient;

    public CaptchaApi() {
    this(new ApiClient());
    }

    @Autowired
    public CaptchaApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Create a CAPTCHA instance
        * Creates a new CAPTCHA instance. In the current release, we only allow one CAPTCHA instance per org.
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param instance  (required)
                * @return CAPTCHAInstance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public CAPTCHAInstance createCaptchaInstance(CAPTCHAInstance instance) throws RestClientException {
                return createCaptchaInstanceWithHttpInfo(instance).getBody();
            }




            /**
            * Create a CAPTCHA instance
            * Creates a new CAPTCHA instance. In the current release, we only allow one CAPTCHA instance per org.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param instance  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createCaptchaInstance(Class<?> T, CAPTCHAInstance instance) throws RestClientException {
                return (T) getObjectMapper().convertValue(createCaptchaInstanceWithReturnType(T, instance).getBody(), T);
            }




            /**
            * Create a CAPTCHA instance
            * Creates a new CAPTCHA instance. In the current release, we only allow one CAPTCHA instance per org.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param instance  (required)
            * @return ResponseEntity&lt;CAPTCHAInstance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<CAPTCHAInstance> createCaptchaInstanceWithHttpInfo(CAPTCHAInstance instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'instance' is set ''
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createCaptchaInstance");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CAPTCHAInstance> localReturnType = new ParameterizedTypeReference<CAPTCHAInstance>() {};
            return apiClient.invokeAPI("/api/v1/captchas", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a CAPTCHA instance
            * Creates a new CAPTCHA instance. In the current release, we only allow one CAPTCHA instance per org.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param instance  (required)
            * @return ResponseEntity&lt;CAPTCHAInstance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createCaptchaInstanceWithReturnType(Class<?> T, CAPTCHAInstance instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createCaptchaInstance");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/captchas", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create a CAPTCHA instance
            * Creates a new CAPTCHA instance. In the current release, we only allow one CAPTCHA instance per org.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param instance  (required)
            * @return ResponseEntity&lt;CAPTCHAInstance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createCaptchaInstanceWithPaginationInfo(CAPTCHAInstance instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling createCaptchaInstance");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CAPTCHAInstance> localReturnType = new ParameterizedTypeReference<CAPTCHAInstance>() {};
            ResponseEntity<CAPTCHAInstance> responseEntity = apiClient.invokeAPI("/api/v1/captchas", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Delete a CAPTCHA Instance
        * Deletes a CAPTCHA instance by &#x60;captchaId&#x60;. If the CAPTCHA instance is currently being used in the org, the delete will not be allowed.
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param captchaId id of the CAPTCHA (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteCaptchaInstance(String captchaId) throws RestClientException {
            deleteCaptchaInstanceWithHttpInfo(captchaId);
            }






            /**
            * Delete a CAPTCHA Instance
            * Deletes a CAPTCHA instance by &#x60;captchaId&#x60;. If the CAPTCHA instance is currently being used in the org, the delete will not be allowed.
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param captchaId id of the CAPTCHA (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteCaptchaInstanceWithHttpInfo(String captchaId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'captchaId' is set ''
                if (captchaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'captchaId' when calling deleteCaptchaInstance");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("captchaId", captchaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/captchas/{captchaId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Retrieve a CAPTCHA Instance
        * Retrieves a CAPTCHA instance by &#x60;captchaId&#x60;
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param captchaId id of the CAPTCHA (required)
                * @return CAPTCHAInstance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public CAPTCHAInstance getCaptchaInstance(String captchaId) throws RestClientException {
                return getCaptchaInstanceWithHttpInfo(captchaId).getBody();
            }






            /**
            * Retrieve a CAPTCHA Instance
            * Retrieves a CAPTCHA instance by &#x60;captchaId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param captchaId id of the CAPTCHA (required)
            * @return ResponseEntity&lt;CAPTCHAInstance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<CAPTCHAInstance> getCaptchaInstanceWithHttpInfo(String captchaId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'captchaId' is set ''
                if (captchaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'captchaId' when calling getCaptchaInstance");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("captchaId", captchaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CAPTCHAInstance> localReturnType = new ParameterizedTypeReference<CAPTCHAInstance>() {};
            return apiClient.invokeAPI("/api/v1/captchas/{captchaId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a CAPTCHA Instance
            * Retrieves a CAPTCHA instance by &#x60;captchaId&#x60;
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param captchaId id of the CAPTCHA (required)
            * @return ResponseEntity&lt;CAPTCHAInstance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getCaptchaInstanceWithPaginationInfo(String captchaId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'captchaId' is set
                if (captchaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'captchaId' when calling getCaptchaInstance");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("captchaId", captchaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CAPTCHAInstance> localReturnType = new ParameterizedTypeReference<CAPTCHAInstance>() {};
            ResponseEntity<CAPTCHAInstance> responseEntity = apiClient.invokeAPI("/api/v1/captchas/{captchaId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all CAPTCHA instances
        * Lists all CAPTCHA instances with pagination support. A subset of CAPTCHA instances can be returned that match a supported filter expression or query.
            * <p><b>200</b> - OK
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @return List&lt;CAPTCHAInstance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<CAPTCHAInstance> listCaptchaInstances() throws RestClientException {
                return listCaptchaInstancesWithHttpInfo().getBody();
            }






            /**
            * List all CAPTCHA instances
            * Lists all CAPTCHA instances with pagination support. A subset of CAPTCHA instances can be returned that match a supported filter expression or query.
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;List&lt;CAPTCHAInstance&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<CAPTCHAInstance>> listCaptchaInstancesWithHttpInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<CAPTCHAInstance>> localReturnType = new ParameterizedTypeReference<List<CAPTCHAInstance>>() {};
            return apiClient.invokeAPI("/api/v1/captchas", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all CAPTCHA instances
            * Lists all CAPTCHA instances with pagination support. A subset of CAPTCHA instances can be returned that match a supported filter expression or query.
                * <p><b>200</b> - OK
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
            * @return ResponseEntity&lt;List&lt;CAPTCHAInstance&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listCaptchaInstancesWithPaginationInfo() throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<CAPTCHAInstance>> localReturnType = new ParameterizedTypeReference<List<CAPTCHAInstance>>() {};
            ResponseEntity<List<CAPTCHAInstance>> responseEntity = apiClient.invokeAPI("/api/v1/captchas", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace a CAPTCHA instance
        * Replaces a CAPTCHA instance by &#x60;captchaId&#x60;
            * <p><b>200</b> - OK
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param captchaId id of the CAPTCHA (required)
                * @param instance  (required)
                * @return CAPTCHAInstance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public CAPTCHAInstance replaceCaptchaInstance(String captchaId, CAPTCHAInstance instance) throws RestClientException {
                return replaceCaptchaInstanceWithHttpInfo(captchaId, instance).getBody();
            }




            /**
            * Replace a CAPTCHA instance
            * Replaces a CAPTCHA instance by &#x60;captchaId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param captchaId id of the CAPTCHA (required)
                * @param instance  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceCaptchaInstance(Class<?> T, String captchaId, CAPTCHAInstance instance) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceCaptchaInstanceWithReturnType(T, captchaId, instance).getBody(), T);
            }




            /**
            * Replace a CAPTCHA instance
            * Replaces a CAPTCHA instance by &#x60;captchaId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param captchaId id of the CAPTCHA (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;CAPTCHAInstance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<CAPTCHAInstance> replaceCaptchaInstanceWithHttpInfo(String captchaId, CAPTCHAInstance instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'captchaId' is set ''
                if (captchaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'captchaId' when calling replaceCaptchaInstance");
                }
        
                // verify the required parameter 'instance' is set ''
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling replaceCaptchaInstance");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("captchaId", captchaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CAPTCHAInstance> localReturnType = new ParameterizedTypeReference<CAPTCHAInstance>() {};
            return apiClient.invokeAPI("/api/v1/captchas/{captchaId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a CAPTCHA instance
            * Replaces a CAPTCHA instance by &#x60;captchaId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param captchaId id of the CAPTCHA (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;CAPTCHAInstance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceCaptchaInstanceWithReturnType(Class<?> T, String captchaId,CAPTCHAInstance instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'captchaId' is set
                if (captchaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'captchaId' when calling replaceCaptchaInstance");
                }
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling replaceCaptchaInstance");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("captchaId", captchaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/captchas/{captchaId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace a CAPTCHA instance
            * Replaces a CAPTCHA instance by &#x60;captchaId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param captchaId id of the CAPTCHA (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;CAPTCHAInstance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceCaptchaInstanceWithPaginationInfo(String captchaId, CAPTCHAInstance instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'captchaId' is set
                if (captchaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'captchaId' when calling replaceCaptchaInstance");
                }
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling replaceCaptchaInstance");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("captchaId", captchaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CAPTCHAInstance> localReturnType = new ParameterizedTypeReference<CAPTCHAInstance>() {};
            ResponseEntity<CAPTCHAInstance> responseEntity = apiClient.invokeAPI("/api/v1/captchas/{captchaId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Update a CAPTCHA instance
        * Partially updates a CAPTCHA instance by &#x60;captchaId&#x60;
            * <p><b>200</b> - OK
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param captchaId id of the CAPTCHA (required)
                * @param instance  (required)
                * @return CAPTCHAInstance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public CAPTCHAInstance updateCaptchaInstance(String captchaId, CAPTCHAInstance instance) throws RestClientException {
                return updateCaptchaInstanceWithHttpInfo(captchaId, instance).getBody();
            }




            /**
            * Update a CAPTCHA instance
            * Partially updates a CAPTCHA instance by &#x60;captchaId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param captchaId id of the CAPTCHA (required)
                * @param instance  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T updateCaptchaInstance(Class<?> T, String captchaId, CAPTCHAInstance instance) throws RestClientException {
                return (T) getObjectMapper().convertValue(updateCaptchaInstanceWithReturnType(T, captchaId, instance).getBody(), T);
            }




            /**
            * Update a CAPTCHA instance
            * Partially updates a CAPTCHA instance by &#x60;captchaId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param captchaId id of the CAPTCHA (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;CAPTCHAInstance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<CAPTCHAInstance> updateCaptchaInstanceWithHttpInfo(String captchaId, CAPTCHAInstance instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'captchaId' is set ''
                if (captchaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'captchaId' when calling updateCaptchaInstance");
                }
        
                // verify the required parameter 'instance' is set ''
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling updateCaptchaInstance");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("captchaId", captchaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CAPTCHAInstance> localReturnType = new ParameterizedTypeReference<CAPTCHAInstance>() {};
            return apiClient.invokeAPI("/api/v1/captchas/{captchaId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update a CAPTCHA instance
            * Partially updates a CAPTCHA instance by &#x60;captchaId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param captchaId id of the CAPTCHA (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;CAPTCHAInstance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> updateCaptchaInstanceWithReturnType(Class<?> T, String captchaId,CAPTCHAInstance instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'captchaId' is set
                if (captchaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'captchaId' when calling updateCaptchaInstance");
                }
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling updateCaptchaInstance");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("captchaId", captchaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/captchas/{captchaId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update a CAPTCHA instance
            * Partially updates a CAPTCHA instance by &#x60;captchaId&#x60;
                * <p><b>200</b> - OK
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param captchaId id of the CAPTCHA (required)
                * @param instance  (required)
            * @return ResponseEntity&lt;CAPTCHAInstance&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList updateCaptchaInstanceWithPaginationInfo(String captchaId, CAPTCHAInstance instance) throws RestClientException {
            Object localVarPostBody = instance;
        
                // verify the required parameter 'captchaId' is set
                if (captchaId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'captchaId' when calling updateCaptchaInstance");
                }
        
                // verify the required parameter 'instance' is set
                if (instance == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'instance' when calling updateCaptchaInstance");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("captchaId", captchaId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<CAPTCHAInstance> localReturnType = new ParameterizedTypeReference<CAPTCHAInstance>() {};
            ResponseEntity<CAPTCHAInstance> responseEntity = apiClient.invokeAPI("/api/v1/captchas/{captchaId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }


    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
