package org.openapitools.client.api;

import org.openapitools.client.ApiClient;

import org.openapitools.client.model.AppUser;
import org.openapitools.client.model.Application;
import org.openapitools.client.model.ApplicationFeature;
import org.openapitools.client.model.ApplicationGroupAssignment;
import org.openapitools.client.model.CapabilitiesObject;
import org.openapitools.client.model.Csr;
import org.openapitools.client.model.CsrMetadata;
import org.openapitools.client.model.Error;
import java.io.File;
import org.openapitools.client.model.JsonWebKey;
import org.openapitools.client.model.OAuth2ScopeConsentGrant;
import org.openapitools.client.model.OAuth2Token;
import org.openapitools.client.model.ProvisioningConnection;
import org.openapitools.client.model.ProvisioningConnectionRequest;

import java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;

import com.okta.sdk.resource.common.PagedList;

import com.okta.commons.lang.Assert;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
@Component("org.openapitools.client.api.ApplicationApi")
    public class ApplicationApi {
    private ApiClient apiClient;

    public ApplicationApi() {
    this(new ApiClient());
    }

    @Autowired
    public ApplicationApi(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
    return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
    }

        /**
        * Activate an Application
        * Activates an inactive application
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void activateApplication(String appId) throws RestClientException {
            activateApplicationWithHttpInfo(appId);
            }






            /**
            * Activate an Application
            * Activates an inactive application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> activateApplicationWithHttpInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling activateApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/lifecycle/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Activate the default Provisioning Connection
        * Activates the default Provisioning Connection for an application
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void activateDefaultProvisioningConnectionForApplication(String appId) throws RestClientException {
            activateDefaultProvisioningConnectionForApplicationWithHttpInfo(appId);
            }






            /**
            * Activate the default Provisioning Connection
            * Activates the default Provisioning Connection for an application
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> activateDefaultProvisioningConnectionForApplicationWithHttpInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling activateDefaultProvisioningConnectionForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default/lifecycle/activate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Assign an application to a specific policy
        * Assign an application to a specific policy. This unassigns the application from its currently assigned policy.
            * <p><b>204</b> - No Content
                * @param appId  (required)
                * @param policyId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void assignApplicationPolicy(String appId, String policyId) throws RestClientException {
            assignApplicationPolicyWithHttpInfo(appId, policyId);
            }






            /**
            * Assign an application to a specific policy
            * Assign an application to a specific policy. This unassigns the application from its currently assigned policy.
                * <p><b>204</b> - No Content
                * @param appId  (required)
                * @param policyId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> assignApplicationPolicyWithHttpInfo(String appId, String policyId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignApplicationPolicy");
                }
        
                // verify the required parameter 'policyId' is set ''
                if (policyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'policyId' when calling assignApplicationPolicy");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("policyId", policyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = {  };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/policies/{policyId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Assign a Group
        * Assigns a group to an application
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param groupId  (required)
                * @param applicationGroupAssignment  (optional)
                * @return ApplicationGroupAssignment
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ApplicationGroupAssignment assignGroupToApplication(String appId, String groupId, ApplicationGroupAssignment applicationGroupAssignment) throws RestClientException {
                return assignGroupToApplicationWithHttpInfo(appId, groupId, applicationGroupAssignment).getBody();
            }




            /**
            * Assign a Group
            * Assigns a group to an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param appId  (required)
                * @param groupId  (required)
                * @param applicationGroupAssignment  (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T assignGroupToApplication(Class<?> T, String appId, String groupId, ApplicationGroupAssignment applicationGroupAssignment) throws RestClientException {
                return (T) getObjectMapper().convertValue(assignGroupToApplicationWithReturnType(T, appId, groupId, applicationGroupAssignment).getBody(), T);
            }




            /**
            * Assign a Group
            * Assigns a group to an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param groupId  (required)
                * @param applicationGroupAssignment  (optional)
            * @return ResponseEntity&lt;ApplicationGroupAssignment&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ApplicationGroupAssignment> assignGroupToApplicationWithHttpInfo(String appId, String groupId, ApplicationGroupAssignment applicationGroupAssignment) throws RestClientException {
            Object localVarPostBody = applicationGroupAssignment;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignGroupToApplication");
                }
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignGroupToApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("groupId", groupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ApplicationGroupAssignment> localReturnType = new ParameterizedTypeReference<ApplicationGroupAssignment>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/groups/{groupId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Assign a Group
            * Assigns a group to an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param groupId  (required)
                * @param applicationGroupAssignment  (optional)
            * @return ResponseEntity&lt;ApplicationGroupAssignment&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> assignGroupToApplicationWithReturnType(Class<?> T, String appId,String groupId,ApplicationGroupAssignment applicationGroupAssignment) throws RestClientException {
            Object localVarPostBody = applicationGroupAssignment;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignGroupToApplication");
                }
        
                // verify the required parameter 'groupId' is set
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignGroupToApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("groupId", groupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/groups/{groupId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Assign a Group
            * Assigns a group to an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param groupId  (required)
                * @param applicationGroupAssignment  (optional)
            * @return ResponseEntity&lt;ApplicationGroupAssignment&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList assignGroupToApplicationWithPaginationInfo(String appId, String groupId, ApplicationGroupAssignment applicationGroupAssignment) throws RestClientException {
            Object localVarPostBody = applicationGroupAssignment;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignGroupToApplication");
                }
        
                // verify the required parameter 'groupId' is set
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling assignGroupToApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("groupId", groupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ApplicationGroupAssignment> localReturnType = new ParameterizedTypeReference<ApplicationGroupAssignment>() {};
            ResponseEntity<ApplicationGroupAssignment> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/groups/{groupId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Assign a User
        * Assigns an user to an application with [credentials](#application-user-credentials-object) and an app-specific [profile](#application-user-profile-object). Profile mappings defined for the application are first applied before applying any profile properties specified in the request.
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param appUser  (required)
                * @return AppUser
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AppUser assignUserToApplication(String appId, AppUser appUser) throws RestClientException {
                return assignUserToApplicationWithHttpInfo(appId, appUser).getBody();
            }




            /**
            * Assign a User
            * Assigns an user to an application with [credentials](#application-user-credentials-object) and an app-specific [profile](#application-user-profile-object). Profile mappings defined for the application are first applied before applying any profile properties specified in the request.
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param appId  (required)
                * @param appUser  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T assignUserToApplication(Class<?> T, String appId, AppUser appUser) throws RestClientException {
                return (T) getObjectMapper().convertValue(assignUserToApplicationWithReturnType(T, appId, appUser).getBody(), T);
            }




            /**
            * Assign a User
            * Assigns an user to an application with [credentials](#application-user-credentials-object) and an app-specific [profile](#application-user-profile-object). Profile mappings defined for the application are first applied before applying any profile properties specified in the request.
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param appUser  (required)
            * @return ResponseEntity&lt;AppUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AppUser> assignUserToApplicationWithHttpInfo(String appId, AppUser appUser) throws RestClientException {
            Object localVarPostBody = appUser;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignUserToApplication");
                }
        
                // verify the required parameter 'appUser' is set ''
                if (appUser == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appUser' when calling assignUserToApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AppUser> localReturnType = new ParameterizedTypeReference<AppUser>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/users", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Assign a User
            * Assigns an user to an application with [credentials](#application-user-credentials-object) and an app-specific [profile](#application-user-profile-object). Profile mappings defined for the application are first applied before applying any profile properties specified in the request.
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param appUser  (required)
            * @return ResponseEntity&lt;AppUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> assignUserToApplicationWithReturnType(Class<?> T, String appId,AppUser appUser) throws RestClientException {
            Object localVarPostBody = appUser;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignUserToApplication");
                }
        
                // verify the required parameter 'appUser' is set
                if (appUser == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appUser' when calling assignUserToApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/users", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Assign a User
            * Assigns an user to an application with [credentials](#application-user-credentials-object) and an app-specific [profile](#application-user-profile-object). Profile mappings defined for the application are first applied before applying any profile properties specified in the request.
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param appUser  (required)
            * @return ResponseEntity&lt;AppUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList assignUserToApplicationWithPaginationInfo(String appId, AppUser appUser) throws RestClientException {
            Object localVarPostBody = appUser;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling assignUserToApplication");
                }
        
                // verify the required parameter 'appUser' is set
                if (appUser == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appUser' when calling assignUserToApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AppUser> localReturnType = new ParameterizedTypeReference<AppUser>() {};
            ResponseEntity<AppUser> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/users", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Clone a Key Credential
        * Clones a X.509 certificate for an application key credential from a source application to target application.
            * <p><b>201</b> - Created
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param keyId  (required)
                * @param targetAid Unique key of the target Application (required)
                * @return JsonWebKey
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public JsonWebKey cloneApplicationKey(String appId, String keyId, String targetAid) throws RestClientException {
                return cloneApplicationKeyWithHttpInfo(appId, keyId, targetAid).getBody();
            }






            /**
            * Clone a Key Credential
            * Clones a X.509 certificate for an application key credential from a source application to target application.
                * <p><b>201</b> - Created
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param keyId  (required)
                * @param targetAid Unique key of the target Application (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<JsonWebKey> cloneApplicationKeyWithHttpInfo(String appId, String keyId, String targetAid) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling cloneApplicationKey");
                }
        
                // verify the required parameter 'keyId' is set ''
                if (keyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling cloneApplicationKey");
                }
        
                // verify the required parameter 'targetAid' is set ''
                if (targetAid == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'targetAid' when calling cloneApplicationKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("keyId", keyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "targetAid", targetAid));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys/{keyId}/clone", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Clone a Key Credential
            * Clones a X.509 certificate for an application key credential from a source application to target application.
                * <p><b>201</b> - Created
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param keyId  (required)
                * @param targetAid Unique key of the target Application (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList cloneApplicationKeyWithPaginationInfo(String appId, String keyId, String targetAid) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling cloneApplicationKey");
                }
        
                // verify the required parameter 'keyId' is set
                if (keyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling cloneApplicationKey");
                }
        
                // verify the required parameter 'targetAid' is set
                if (targetAid == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'targetAid' when calling cloneApplicationKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("keyId", keyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "targetAid", targetAid));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            ResponseEntity<JsonWebKey> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys/{keyId}/clone", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Create an Application
        * Creates a new application to your Okta organization
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param application  (required)
                * @param activate Executes activation lifecycle operation when creating the app (optional, default to true)
                * @param oktaAccessGatewayAgent  (optional)
                * @return Application
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Application createApplication(Application application, Boolean activate, String oktaAccessGatewayAgent) throws RestClientException {
                return createApplicationWithHttpInfo(application, activate, oktaAccessGatewayAgent).getBody();
            }




            /**
            * Create an Application
            * Creates a new application to your Okta organization
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param application  (required)
                * @param activate Executes activation lifecycle operation when creating the app (optional, default to true)
                * @param oktaAccessGatewayAgent  (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T createApplication(Class<?> T, Application application, Boolean activate, String oktaAccessGatewayAgent) throws RestClientException {
                return (T) getObjectMapper().convertValue(createApplicationWithReturnType(T, application, activate, oktaAccessGatewayAgent).getBody(), T);
            }




            /**
            * Create an Application
            * Creates a new application to your Okta organization
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param application  (required)
                * @param activate Executes activation lifecycle operation when creating the app (optional, default to true)
                * @param oktaAccessGatewayAgent  (optional)
            * @return ResponseEntity&lt;Application&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Application> createApplicationWithHttpInfo(Application application, Boolean activate, String oktaAccessGatewayAgent) throws RestClientException {
            Object localVarPostBody = application;
        
                // verify the required parameter 'application' is set ''
                if (application == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'application' when calling createApplication");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "activate", activate));

            if (oktaAccessGatewayAgent != null)
                localVarHeaderParams.add("OktaAccessGateway-Agent", apiClient.parameterToString(oktaAccessGatewayAgent));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Application> localReturnType = new ParameterizedTypeReference<Application>() {};
            return apiClient.invokeAPI("/api/v1/apps", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an Application
            * Creates a new application to your Okta organization
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param application  (required)
                * @param activate Executes activation lifecycle operation when creating the app (optional, default to true)
                * @param oktaAccessGatewayAgent  (optional)
            * @return ResponseEntity&lt;Application&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> createApplicationWithReturnType(Class<?> T, Application application,Boolean activate,String oktaAccessGatewayAgent) throws RestClientException {
            Object localVarPostBody = application;
        
                // verify the required parameter 'application' is set
                if (application == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'application' when calling createApplication");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "activate", activate));

            if (oktaAccessGatewayAgent != null)
                localVarHeaderParams.add("OktaAccessGateway-Agent", apiClient.parameterToString(oktaAccessGatewayAgent));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/apps", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Create an Application
            * Creates a new application to your Okta organization
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param application  (required)
                * @param activate Executes activation lifecycle operation when creating the app (optional, default to true)
                * @param oktaAccessGatewayAgent  (optional)
            * @return ResponseEntity&lt;Application&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList createApplicationWithPaginationInfo(Application application, Boolean activate, String oktaAccessGatewayAgent) throws RestClientException {
            Object localVarPostBody = application;
        
                // verify the required parameter 'application' is set
                if (application == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'application' when calling createApplication");
                }
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "activate", activate));

            if (oktaAccessGatewayAgent != null)
                localVarHeaderParams.add("OktaAccessGateway-Agent", apiClient.parameterToString(oktaAccessGatewayAgent));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Application> localReturnType = new ParameterizedTypeReference<Application>() {};
            ResponseEntity<Application> responseEntity = apiClient.invokeAPI("/api/v1/apps", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Deactivate an Application
        * Deactivates an active application
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deactivateApplication(String appId) throws RestClientException {
            deactivateApplicationWithHttpInfo(appId);
            }






            /**
            * Deactivate an Application
            * Deactivates an active application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deactivateApplicationWithHttpInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling deactivateApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/lifecycle/deactivate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Deactivate the default Provisioning Connection for an Application
        * Deactivates the default Provisioning Connection for an application
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deactivateDefaultProvisioningConnectionForApplication(String appId) throws RestClientException {
            deactivateDefaultProvisioningConnectionForApplicationWithHttpInfo(appId);
            }






            /**
            * Deactivate the default Provisioning Connection for an Application
            * Deactivates the default Provisioning Connection for an application
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deactivateDefaultProvisioningConnectionForApplicationWithHttpInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling deactivateDefaultProvisioningConnectionForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default/lifecycle/deactivate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Delete an Application
        * Deletes an inactive application
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void deleteApplication(String appId) throws RestClientException {
            deleteApplicationWithHttpInfo(appId);
            }






            /**
            * Delete an Application
            * Deletes an inactive application
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> deleteApplicationWithHttpInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling deleteApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Generate a Key Credential
        * Generates a new X.509 certificate for an application key credential
            * <p><b>201</b> - Created
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param validityYears  (optional)
                * @return JsonWebKey
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public JsonWebKey generateApplicationKey(String appId, Integer validityYears) throws RestClientException {
                return generateApplicationKeyWithHttpInfo(appId, validityYears).getBody();
            }






            /**
            * Generate a Key Credential
            * Generates a new X.509 certificate for an application key credential
                * <p><b>201</b> - Created
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param validityYears  (optional)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<JsonWebKey> generateApplicationKeyWithHttpInfo(String appId, Integer validityYears) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling generateApplicationKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "validityYears", validityYears));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys/generate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Generate a Key Credential
            * Generates a new X.509 certificate for an application key credential
                * <p><b>201</b> - Created
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param validityYears  (optional)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList generateApplicationKeyWithPaginationInfo(String appId, Integer validityYears) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling generateApplicationKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "validityYears", validityYears));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            ResponseEntity<JsonWebKey> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys/generate", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Generate a Certificate Signing Request
        * Generates a new key pair and returns the Certificate Signing Request for it
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param metadata  (required)
                * @return Csr
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Csr generateCsrForApplication(String appId, CsrMetadata metadata) throws RestClientException {
                return generateCsrForApplicationWithHttpInfo(appId, metadata).getBody();
            }




            /**
            * Generate a Certificate Signing Request
            * Generates a new key pair and returns the Certificate Signing Request for it
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param appId  (required)
                * @param metadata  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T generateCsrForApplication(Class<?> T, String appId, CsrMetadata metadata) throws RestClientException {
                return (T) getObjectMapper().convertValue(generateCsrForApplicationWithReturnType(T, appId, metadata).getBody(), T);
            }




            /**
            * Generate a Certificate Signing Request
            * Generates a new key pair and returns the Certificate Signing Request for it
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param metadata  (required)
            * @return ResponseEntity&lt;Csr&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Csr> generateCsrForApplicationWithHttpInfo(String appId, CsrMetadata metadata) throws RestClientException {
            Object localVarPostBody = metadata;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling generateCsrForApplication");
                }
        
                // verify the required parameter 'metadata' is set ''
                if (metadata == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'metadata' when calling generateCsrForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Csr> localReturnType = new ParameterizedTypeReference<Csr>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Generate a Certificate Signing Request
            * Generates a new key pair and returns the Certificate Signing Request for it
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param metadata  (required)
            * @return ResponseEntity&lt;Csr&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> generateCsrForApplicationWithReturnType(Class<?> T, String appId,CsrMetadata metadata) throws RestClientException {
            Object localVarPostBody = metadata;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling generateCsrForApplication");
                }
        
                // verify the required parameter 'metadata' is set
                if (metadata == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'metadata' when calling generateCsrForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Generate a Certificate Signing Request
            * Generates a new key pair and returns the Certificate Signing Request for it
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param metadata  (required)
            * @return ResponseEntity&lt;Csr&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList generateCsrForApplicationWithPaginationInfo(String appId, CsrMetadata metadata) throws RestClientException {
            Object localVarPostBody = metadata;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling generateCsrForApplication");
                }
        
                // verify the required parameter 'metadata' is set
                if (metadata == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'metadata' when calling generateCsrForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Csr> localReturnType = new ParameterizedTypeReference<Csr>() {};
            ResponseEntity<Csr> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve an Application
        * Retrieves an application from your Okta organization by &#x60;id&#x60;
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param expand  (optional)
                * @return Application
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Application getApplication(String appId, String expand) throws RestClientException {
                return getApplicationWithHttpInfo(appId, expand).getBody();
            }






            /**
            * Retrieve an Application
            * Retrieves an application from your Okta organization by &#x60;id&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;Application&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Application> getApplicationWithHttpInfo(String appId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Application> localReturnType = new ParameterizedTypeReference<Application>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve an Application
            * Retrieves an application from your Okta organization by &#x60;id&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;Application&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getApplicationWithPaginationInfo(String appId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Application> localReturnType = new ParameterizedTypeReference<Application>() {};
            ResponseEntity<Application> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve an Assigned Group
        * Retrieves an application group assignment
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param groupId  (required)
                * @param expand  (optional)
                * @return ApplicationGroupAssignment
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ApplicationGroupAssignment getApplicationGroupAssignment(String appId, String groupId, String expand) throws RestClientException {
                return getApplicationGroupAssignmentWithHttpInfo(appId, groupId, expand).getBody();
            }






            /**
            * Retrieve an Assigned Group
            * Retrieves an application group assignment
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param groupId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;ApplicationGroupAssignment&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ApplicationGroupAssignment> getApplicationGroupAssignmentWithHttpInfo(String appId, String groupId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplicationGroupAssignment");
                }
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling getApplicationGroupAssignment");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("groupId", groupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ApplicationGroupAssignment> localReturnType = new ParameterizedTypeReference<ApplicationGroupAssignment>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/groups/{groupId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve an Assigned Group
            * Retrieves an application group assignment
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param groupId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;ApplicationGroupAssignment&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getApplicationGroupAssignmentWithPaginationInfo(String appId, String groupId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplicationGroupAssignment");
                }
        
                // verify the required parameter 'groupId' is set
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling getApplicationGroupAssignment");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("groupId", groupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ApplicationGroupAssignment> localReturnType = new ParameterizedTypeReference<ApplicationGroupAssignment>() {};
            ResponseEntity<ApplicationGroupAssignment> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/groups/{groupId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Key Credential
        * Retrieves a specific application key credential by kid
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param keyId  (required)
                * @return JsonWebKey
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public JsonWebKey getApplicationKey(String appId, String keyId) throws RestClientException {
                return getApplicationKeyWithHttpInfo(appId, keyId).getBody();
            }






            /**
            * Retrieve a Key Credential
            * Retrieves a specific application key credential by kid
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param keyId  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<JsonWebKey> getApplicationKeyWithHttpInfo(String appId, String keyId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplicationKey");
                }
        
                // verify the required parameter 'keyId' is set ''
                if (keyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling getApplicationKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("keyId", keyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys/{keyId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Key Credential
            * Retrieves a specific application key credential by kid
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param keyId  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getApplicationKeyWithPaginationInfo(String appId, String keyId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplicationKey");
                }
        
                // verify the required parameter 'keyId' is set
                if (keyId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'keyId' when calling getApplicationKey");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("keyId", keyId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            ResponseEntity<JsonWebKey> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys/{keyId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve an Assigned User
        * Retrieves a specific user assignment for application by &#x60;id&#x60;
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param userId  (required)
                * @param expand  (optional)
                * @return AppUser
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AppUser getApplicationUser(String appId, String userId, String expand) throws RestClientException {
                return getApplicationUserWithHttpInfo(appId, userId, expand).getBody();
            }






            /**
            * Retrieve an Assigned User
            * Retrieves a specific user assignment for application by &#x60;id&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param userId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;AppUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AppUser> getApplicationUserWithHttpInfo(String appId, String userId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplicationUser");
                }
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getApplicationUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AppUser> localReturnType = new ParameterizedTypeReference<AppUser>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/users/{userId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve an Assigned User
            * Retrieves a specific user assignment for application by &#x60;id&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param userId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;AppUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getApplicationUserWithPaginationInfo(String appId, String userId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getApplicationUser");
                }
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling getApplicationUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AppUser> localReturnType = new ParameterizedTypeReference<AppUser>() {};
            ResponseEntity<AppUser> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/users/{userId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Certificate Signing Request
        * Retrieves a certificate signing request for the app by &#x60;id&#x60;
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param csrId  (required)
                * @return Csr
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Csr getCsrForApplication(String appId, String csrId) throws RestClientException {
                return getCsrForApplicationWithHttpInfo(appId, csrId).getBody();
            }






            /**
            * Retrieve a Certificate Signing Request
            * Retrieves a certificate signing request for the app by &#x60;id&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param csrId  (required)
            * @return ResponseEntity&lt;Csr&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Csr> getCsrForApplicationWithHttpInfo(String appId, String csrId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getCsrForApplication");
                }
        
                // verify the required parameter 'csrId' is set ''
                if (csrId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling getCsrForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("csrId", csrId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Csr> localReturnType = new ParameterizedTypeReference<Csr>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs/{csrId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Certificate Signing Request
            * Retrieves a certificate signing request for the app by &#x60;id&#x60;
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param csrId  (required)
            * @return ResponseEntity&lt;Csr&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getCsrForApplicationWithPaginationInfo(String appId, String csrId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getCsrForApplication");
                }
        
                // verify the required parameter 'csrId' is set
                if (csrId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling getCsrForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("csrId", csrId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Csr> localReturnType = new ParameterizedTypeReference<Csr>() {};
            ResponseEntity<Csr> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs/{csrId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve the default Provisioning Connection
        * Retrieves the default Provisioning Connection for application
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @return ProvisioningConnection
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ProvisioningConnection getDefaultProvisioningConnectionForApplication(String appId) throws RestClientException {
                return getDefaultProvisioningConnectionForApplicationWithHttpInfo(appId).getBody();
            }






            /**
            * Retrieve the default Provisioning Connection
            * Retrieves the default Provisioning Connection for application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;ProvisioningConnection&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ProvisioningConnection> getDefaultProvisioningConnectionForApplicationWithHttpInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getDefaultProvisioningConnectionForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ProvisioningConnection> localReturnType = new ParameterizedTypeReference<ProvisioningConnection>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve the default Provisioning Connection
            * Retrieves the default Provisioning Connection for application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;ProvisioningConnection&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getDefaultProvisioningConnectionForApplicationWithPaginationInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getDefaultProvisioningConnectionForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ProvisioningConnection> localReturnType = new ParameterizedTypeReference<ProvisioningConnection>() {};
            ResponseEntity<ProvisioningConnection> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Feature
        * Retrieves a Feature object for an application
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param name  (required)
                * @return ApplicationFeature
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ApplicationFeature getFeatureForApplication(String appId, String name) throws RestClientException {
                return getFeatureForApplicationWithHttpInfo(appId, name).getBody();
            }






            /**
            * Retrieve a Feature
            * Retrieves a Feature object for an application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param name  (required)
            * @return ResponseEntity&lt;ApplicationFeature&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ApplicationFeature> getFeatureForApplicationWithHttpInfo(String appId, String name) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getFeatureForApplication");
                }
        
                // verify the required parameter 'name' is set ''
                if (name == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'name' when calling getFeatureForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("name", name);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ApplicationFeature> localReturnType = new ParameterizedTypeReference<ApplicationFeature>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/features/{name}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Feature
            * Retrieves a Feature object for an application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param name  (required)
            * @return ResponseEntity&lt;ApplicationFeature&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getFeatureForApplicationWithPaginationInfo(String appId, String name) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getFeatureForApplication");
                }
        
                // verify the required parameter 'name' is set
                if (name == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'name' when calling getFeatureForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("name", name);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ApplicationFeature> localReturnType = new ParameterizedTypeReference<ApplicationFeature>() {};
            ResponseEntity<ApplicationFeature> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/features/{name}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve an OAuth 2.0 Token
        * Retrieves a token for the specified application
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param tokenId  (required)
                * @param expand  (optional)
                * @return OAuth2Token
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public OAuth2Token getOAuth2TokenForApplication(String appId, String tokenId, String expand) throws RestClientException {
                return getOAuth2TokenForApplicationWithHttpInfo(appId, tokenId, expand).getBody();
            }






            /**
            * Retrieve an OAuth 2.0 Token
            * Retrieves a token for the specified application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param tokenId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;OAuth2Token&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<OAuth2Token> getOAuth2TokenForApplicationWithHttpInfo(String appId, String tokenId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getOAuth2TokenForApplication");
                }
        
                // verify the required parameter 'tokenId' is set ''
                if (tokenId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling getOAuth2TokenForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("tokenId", tokenId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Token> localReturnType = new ParameterizedTypeReference<OAuth2Token>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/tokens/{tokenId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve an OAuth 2.0 Token
            * Retrieves a token for the specified application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param tokenId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;OAuth2Token&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getOAuth2TokenForApplicationWithPaginationInfo(String appId, String tokenId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getOAuth2TokenForApplication");
                }
        
                // verify the required parameter 'tokenId' is set
                if (tokenId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling getOAuth2TokenForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("tokenId", tokenId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<OAuth2Token> localReturnType = new ParameterizedTypeReference<OAuth2Token>() {};
            ResponseEntity<OAuth2Token> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/tokens/{tokenId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Retrieve a Scope Consent Grant
        * Retrieves a single scope consent grant for the application
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param grantId  (required)
                * @param expand  (optional)
                * @return OAuth2ScopeConsentGrant
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public OAuth2ScopeConsentGrant getScopeConsentGrant(String appId, String grantId, String expand) throws RestClientException {
                return getScopeConsentGrantWithHttpInfo(appId, grantId, expand).getBody();
            }






            /**
            * Retrieve a Scope Consent Grant
            * Retrieves a single scope consent grant for the application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param grantId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;OAuth2ScopeConsentGrant&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<OAuth2ScopeConsentGrant> getScopeConsentGrantWithHttpInfo(String appId, String grantId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getScopeConsentGrant");
                }
        
                // verify the required parameter 'grantId' is set ''
                if (grantId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'grantId' when calling getScopeConsentGrant");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("grantId", grantId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken" };

        ParameterizedTypeReference<OAuth2ScopeConsentGrant> localReturnType = new ParameterizedTypeReference<OAuth2ScopeConsentGrant>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/grants/{grantId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * Retrieve a Scope Consent Grant
            * Retrieves a single scope consent grant for the application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param grantId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;OAuth2ScopeConsentGrant&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList getScopeConsentGrantWithPaginationInfo(String appId, String grantId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling getScopeConsentGrant");
                }
        
                // verify the required parameter 'grantId' is set
                if (grantId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'grantId' when calling getScopeConsentGrant");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("grantId", grantId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken" };

        ParameterizedTypeReference<OAuth2ScopeConsentGrant> localReturnType = new ParameterizedTypeReference<OAuth2ScopeConsentGrant>() {};
            ResponseEntity<OAuth2ScopeConsentGrant> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/grants/{grantId}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Grant Consent to Scope
        * Grants consent for the application to request an OAuth 2.0 Okta scope
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param oAuth2ScopeConsentGrant  (required)
                * @return OAuth2ScopeConsentGrant
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public OAuth2ScopeConsentGrant grantConsentToScope(String appId, OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant) throws RestClientException {
                return grantConsentToScopeWithHttpInfo(appId, oAuth2ScopeConsentGrant).getBody();
            }




            /**
            * Grant Consent to Scope
            * Grants consent for the application to request an OAuth 2.0 Okta scope
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param appId  (required)
                * @param oAuth2ScopeConsentGrant  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T grantConsentToScope(Class<?> T, String appId, OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant) throws RestClientException {
                return (T) getObjectMapper().convertValue(grantConsentToScopeWithReturnType(T, appId, oAuth2ScopeConsentGrant).getBody(), T);
            }




            /**
            * Grant Consent to Scope
            * Grants consent for the application to request an OAuth 2.0 Okta scope
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param oAuth2ScopeConsentGrant  (required)
            * @return ResponseEntity&lt;OAuth2ScopeConsentGrant&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<OAuth2ScopeConsentGrant> grantConsentToScopeWithHttpInfo(String appId, OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant) throws RestClientException {
            Object localVarPostBody = oAuth2ScopeConsentGrant;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling grantConsentToScope");
                }
        
                // verify the required parameter 'oAuth2ScopeConsentGrant' is set ''
                if (oAuth2ScopeConsentGrant == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2ScopeConsentGrant' when calling grantConsentToScope");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken" };

        ParameterizedTypeReference<OAuth2ScopeConsentGrant> localReturnType = new ParameterizedTypeReference<OAuth2ScopeConsentGrant>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/grants", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Grant Consent to Scope
            * Grants consent for the application to request an OAuth 2.0 Okta scope
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param oAuth2ScopeConsentGrant  (required)
            * @return ResponseEntity&lt;OAuth2ScopeConsentGrant&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> grantConsentToScopeWithReturnType(Class<?> T, String appId,OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant) throws RestClientException {
            Object localVarPostBody = oAuth2ScopeConsentGrant;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling grantConsentToScope");
                }
        
                // verify the required parameter 'oAuth2ScopeConsentGrant' is set
                if (oAuth2ScopeConsentGrant == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2ScopeConsentGrant' when calling grantConsentToScope");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/grants", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Grant Consent to Scope
            * Grants consent for the application to request an OAuth 2.0 Okta scope
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param oAuth2ScopeConsentGrant  (required)
            * @return ResponseEntity&lt;OAuth2ScopeConsentGrant&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList grantConsentToScopeWithPaginationInfo(String appId, OAuth2ScopeConsentGrant oAuth2ScopeConsentGrant) throws RestClientException {
            Object localVarPostBody = oAuth2ScopeConsentGrant;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling grantConsentToScope");
                }
        
                // verify the required parameter 'oAuth2ScopeConsentGrant' is set
                if (oAuth2ScopeConsentGrant == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'oAuth2ScopeConsentGrant' when calling grantConsentToScope");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken" };

        ParameterizedTypeReference<OAuth2ScopeConsentGrant> localReturnType = new ParameterizedTypeReference<OAuth2ScopeConsentGrant>() {};
            ResponseEntity<OAuth2ScopeConsentGrant> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/grants", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Assigned Groups
        * Lists all group assignments for an application
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param q  (optional)
                * @param after Specifies the pagination cursor for the next page of assignments (optional)
                * @param limit Specifies the number of results for a page (optional, default to -1)
                * @param expand  (optional)
                * @return List&lt;ApplicationGroupAssignment&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<ApplicationGroupAssignment> listApplicationGroupAssignments(String appId, String q, String after, Integer limit, String expand) throws RestClientException {
                return listApplicationGroupAssignmentsWithHttpInfo(appId, q, after, limit, expand).getBody();
            }






            /**
            * List all Assigned Groups
            * Lists all group assignments for an application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param q  (optional)
                * @param after Specifies the pagination cursor for the next page of assignments (optional)
                * @param limit Specifies the number of results for a page (optional, default to -1)
                * @param expand  (optional)
            * @return ResponseEntity&lt;List&lt;ApplicationGroupAssignment&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<ApplicationGroupAssignment>> listApplicationGroupAssignmentsWithHttpInfo(String appId, String q, String after, Integer limit, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listApplicationGroupAssignments");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<ApplicationGroupAssignment>> localReturnType = new ParameterizedTypeReference<List<ApplicationGroupAssignment>>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/groups", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Assigned Groups
            * Lists all group assignments for an application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param q  (optional)
                * @param after Specifies the pagination cursor for the next page of assignments (optional)
                * @param limit Specifies the number of results for a page (optional, default to -1)
                * @param expand  (optional)
            * @return ResponseEntity&lt;List&lt;ApplicationGroupAssignment&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listApplicationGroupAssignmentsWithPaginationInfo(String appId, String q, String after, Integer limit, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listApplicationGroupAssignments");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<ApplicationGroupAssignment>> localReturnType = new ParameterizedTypeReference<List<ApplicationGroupAssignment>>() {};
            ResponseEntity<List<ApplicationGroupAssignment>> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/groups", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Key Credentials
        * Lists all key credentials for an application
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @return List&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<JsonWebKey> listApplicationKeys(String appId) throws RestClientException {
                return listApplicationKeysWithHttpInfo(appId).getBody();
            }






            /**
            * List all Key Credentials
            * Lists all key credentials for an application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;List&lt;JsonWebKey&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<JsonWebKey>> listApplicationKeysWithHttpInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listApplicationKeys");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Key Credentials
            * Lists all key credentials for an application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;List&lt;JsonWebKey&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listApplicationKeysWithPaginationInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listApplicationKeys");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<JsonWebKey>> localReturnType = new ParameterizedTypeReference<List<JsonWebKey>>() {};
            ResponseEntity<List<JsonWebKey>> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/keys", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Assigned Users
        * Lists all assigned [application users](#application-user-model) for an application
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param q  (optional)
                * @param queryScope  (optional)
                * @param after specifies the pagination cursor for the next page of assignments (optional)
                * @param limit specifies the number of results for a page (optional, default to -1)
                * @param filter  (optional)
                * @param expand  (optional)
                * @return List&lt;AppUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<AppUser> listApplicationUsers(String appId, String q, String queryScope, String after, Integer limit, String filter, String expand) throws RestClientException {
                return listApplicationUsersWithHttpInfo(appId, q, queryScope, after, limit, filter, expand).getBody();
            }






            /**
            * List all Assigned Users
            * Lists all assigned [application users](#application-user-model) for an application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param q  (optional)
                * @param queryScope  (optional)
                * @param after specifies the pagination cursor for the next page of assignments (optional)
                * @param limit specifies the number of results for a page (optional, default to -1)
                * @param filter  (optional)
                * @param expand  (optional)
            * @return ResponseEntity&lt;List&lt;AppUser&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<AppUser>> listApplicationUsersWithHttpInfo(String appId, String q, String queryScope, String after, Integer limit, String filter, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listApplicationUsers");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "query_scope", queryScope));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "filter", filter));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AppUser>> localReturnType = new ParameterizedTypeReference<List<AppUser>>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/users", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Assigned Users
            * Lists all assigned [application users](#application-user-model) for an application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param q  (optional)
                * @param queryScope  (optional)
                * @param after specifies the pagination cursor for the next page of assignments (optional)
                * @param limit specifies the number of results for a page (optional, default to -1)
                * @param filter  (optional)
                * @param expand  (optional)
            * @return ResponseEntity&lt;List&lt;AppUser&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listApplicationUsersWithPaginationInfo(String appId, String q, String queryScope, String after, Integer limit, String filter, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listApplicationUsers");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "query_scope", queryScope));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "filter", filter));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<AppUser>> localReturnType = new ParameterizedTypeReference<List<AppUser>>() {};
            ResponseEntity<List<AppUser>> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/users", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Applications
        * Lists all applications with pagination. A subset of apps can be returned that match a supported filter expression or query.
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>429</b> - Too Many Requests
                * @param q  (optional)
                * @param after Specifies the pagination cursor for the next page of apps (optional)
                * @param limit Specifies the number of results for a page (optional, default to -1)
                * @param filter Filters apps by status, user.id, group.id or credentials.signing.kid expression (optional)
                * @param expand Traverses users link relationship and optionally embeds Application User resource (optional)
                * @param includeNonDeleted  (optional, default to false)
                * @return List&lt;Application&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<Application> listApplications(String q, String after, Integer limit, String filter, String expand, Boolean includeNonDeleted) throws RestClientException {
                return listApplicationsWithHttpInfo(q, after, limit, filter, expand, includeNonDeleted).getBody();
            }






            /**
            * List all Applications
            * Lists all applications with pagination. A subset of apps can be returned that match a supported filter expression or query.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param q  (optional)
                * @param after Specifies the pagination cursor for the next page of apps (optional)
                * @param limit Specifies the number of results for a page (optional, default to -1)
                * @param filter Filters apps by status, user.id, group.id or credentials.signing.kid expression (optional)
                * @param expand Traverses users link relationship and optionally embeds Application User resource (optional)
                * @param includeNonDeleted  (optional, default to false)
            * @return ResponseEntity&lt;List&lt;Application&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<Application>> listApplicationsWithHttpInfo(String q, String after, Integer limit, String filter, String expand, Boolean includeNonDeleted) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "filter", filter));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "includeNonDeleted", includeNonDeleted));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Application>> localReturnType = new ParameterizedTypeReference<List<Application>>() {};
            return apiClient.invokeAPI("/api/v1/apps", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Applications
            * Lists all applications with pagination. A subset of apps can be returned that match a supported filter expression or query.
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>429</b> - Too Many Requests
                * @param q  (optional)
                * @param after Specifies the pagination cursor for the next page of apps (optional)
                * @param limit Specifies the number of results for a page (optional, default to -1)
                * @param filter Filters apps by status, user.id, group.id or credentials.signing.kid expression (optional)
                * @param expand Traverses users link relationship and optionally embeds Application User resource (optional)
                * @param includeNonDeleted  (optional, default to false)
            * @return ResponseEntity&lt;List&lt;Application&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listApplicationsWithPaginationInfo(String q, String after, Integer limit, String filter, String expand, Boolean includeNonDeleted) throws RestClientException {
            Object localVarPostBody = null;
        

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "q", q));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "filter", filter));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "includeNonDeleted", includeNonDeleted));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Application>> localReturnType = new ParameterizedTypeReference<List<Application>>() {};
            ResponseEntity<List<Application>> responseEntity = apiClient.invokeAPI("/api/v1/apps", HttpMethod.GET, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Certificate Signing Requests
        * Lists all Certificate Signing Requests for an application
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @return List&lt;Csr&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<Csr> listCsrsForApplication(String appId) throws RestClientException {
                return listCsrsForApplicationWithHttpInfo(appId).getBody();
            }






            /**
            * List all Certificate Signing Requests
            * Lists all Certificate Signing Requests for an application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;List&lt;Csr&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<Csr>> listCsrsForApplicationWithHttpInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listCsrsForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Csr>> localReturnType = new ParameterizedTypeReference<List<Csr>>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Certificate Signing Requests
            * Lists all Certificate Signing Requests for an application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;List&lt;Csr&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listCsrsForApplicationWithPaginationInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listCsrsForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<Csr>> localReturnType = new ParameterizedTypeReference<List<Csr>>() {};
            ResponseEntity<List<Csr>> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Features
        * Lists all features for an application
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @return List&lt;ApplicationFeature&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<ApplicationFeature> listFeaturesForApplication(String appId) throws RestClientException {
                return listFeaturesForApplicationWithHttpInfo(appId).getBody();
            }






            /**
            * List all Features
            * Lists all features for an application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;List&lt;ApplicationFeature&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<ApplicationFeature>> listFeaturesForApplicationWithHttpInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listFeaturesForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<ApplicationFeature>> localReturnType = new ParameterizedTypeReference<List<ApplicationFeature>>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/features", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Features
            * Lists all features for an application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;List&lt;ApplicationFeature&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listFeaturesForApplicationWithPaginationInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listFeaturesForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<ApplicationFeature>> localReturnType = new ParameterizedTypeReference<List<ApplicationFeature>>() {};
            ResponseEntity<List<ApplicationFeature>> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/features", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all OAuth 2.0 Tokens
        * Lists all tokens for the application
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
                * @return List&lt;OAuth2Token&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<OAuth2Token> listOAuth2TokensForApplication(String appId, String expand, String after, Integer limit) throws RestClientException {
                return listOAuth2TokensForApplicationWithHttpInfo(appId, expand, after, limit).getBody();
            }






            /**
            * List all OAuth 2.0 Tokens
            * Lists all tokens for the application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;OAuth2Token&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<OAuth2Token>> listOAuth2TokensForApplicationWithHttpInfo(String appId, String expand, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listOAuth2TokensForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2Token>> localReturnType = new ParameterizedTypeReference<List<OAuth2Token>>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/tokens", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all OAuth 2.0 Tokens
            * Lists all tokens for the application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param expand  (optional)
                * @param after  (optional)
                * @param limit  (optional, default to 20)
            * @return ResponseEntity&lt;List&lt;OAuth2Token&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listOAuth2TokensForApplicationWithPaginationInfo(String appId, String expand, String after, Integer limit) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listOAuth2TokensForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "after", after));
            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<List<OAuth2Token>> localReturnType = new ParameterizedTypeReference<List<OAuth2Token>>() {};
            ResponseEntity<List<OAuth2Token>> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/tokens", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * List all Scope Consent Grants
        * Lists all scope consent grants for the application
            * <p><b>200</b> - Success
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param expand  (optional)
                * @return List&lt;OAuth2ScopeConsentGrant&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public List<OAuth2ScopeConsentGrant> listScopeConsentGrants(String appId, String expand) throws RestClientException {
                return listScopeConsentGrantsWithHttpInfo(appId, expand).getBody();
            }






            /**
            * List all Scope Consent Grants
            * Lists all scope consent grants for the application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;List&lt;OAuth2ScopeConsentGrant&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<List<OAuth2ScopeConsentGrant>> listScopeConsentGrantsWithHttpInfo(String appId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listScopeConsentGrants");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken" };

        ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>> localReturnType = new ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/grants", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







            /**
            * List all Scope Consent Grants
            * Lists all scope consent grants for the application
                * <p><b>200</b> - Success
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param expand  (optional)
            * @return ResponseEntity&lt;List&lt;OAuth2ScopeConsentGrant&gt;&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList listScopeConsentGrantsWithPaginationInfo(String appId, String expand) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling listScopeConsentGrants");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "expand", expand));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken" };

        ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>> localReturnType = new ParameterizedTypeReference<List<OAuth2ScopeConsentGrant>>() {};
            ResponseEntity<List<OAuth2ScopeConsentGrant>> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/grants", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Publish a Certificate Signing Request
        * Updates a certificate signing request for the app with a signed X.509 certificate and adds it into the application key credentials
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param csrId  (required)
                * @param body  (required)
                * @return JsonWebKey
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public JsonWebKey publishCsrFromApplication(String appId, String csrId, File body) throws RestClientException {
                return publishCsrFromApplicationWithHttpInfo(appId, csrId, body).getBody();
            }




            /**
            * Publish a Certificate Signing Request
            * Updates a certificate signing request for the app with a signed X.509 certificate and adds it into the application key credentials
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param appId  (required)
                * @param csrId  (required)
                * @param body  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T publishCsrFromApplication(Class<?> T, String appId, String csrId, File body) throws RestClientException {
                return (T) getObjectMapper().convertValue(publishCsrFromApplicationWithReturnType(T, appId, csrId, body).getBody(), T);
            }




            /**
            * Publish a Certificate Signing Request
            * Updates a certificate signing request for the app with a signed X.509 certificate and adds it into the application key credentials
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param csrId  (required)
                * @param body  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<JsonWebKey> publishCsrFromApplicationWithHttpInfo(String appId, String csrId, File body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling publishCsrFromApplication");
                }
        
                // verify the required parameter 'csrId' is set ''
                if (csrId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling publishCsrFromApplication");
                }
        
                // verify the required parameter 'body' is set ''
                if (body == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling publishCsrFromApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("csrId", csrId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/x-x509-ca-cert", "application/pkix-cert", "application/x-pem-file"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs/{csrId}/lifecycle/publish", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Publish a Certificate Signing Request
            * Updates a certificate signing request for the app with a signed X.509 certificate and adds it into the application key credentials
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param csrId  (required)
                * @param body  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> publishCsrFromApplicationWithReturnType(Class<?> T, String appId,String csrId,File body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling publishCsrFromApplication");
                }
        
                // verify the required parameter 'csrId' is set
                if (csrId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling publishCsrFromApplication");
                }
        
                // verify the required parameter 'body' is set
                if (body == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling publishCsrFromApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("csrId", csrId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/x-x509-ca-cert", "application/pkix-cert", "application/x-pem-file"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs/{csrId}/lifecycle/publish", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Publish a Certificate Signing Request
            * Updates a certificate signing request for the app with a signed X.509 certificate and adds it into the application key credentials
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param csrId  (required)
                * @param body  (required)
            * @return ResponseEntity&lt;JsonWebKey&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList publishCsrFromApplicationWithPaginationInfo(String appId, String csrId, File body) throws RestClientException {
            Object localVarPostBody = body;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling publishCsrFromApplication");
                }
        
                // verify the required parameter 'csrId' is set
                if (csrId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling publishCsrFromApplication");
                }
        
                // verify the required parameter 'body' is set
                if (body == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'body' when calling publishCsrFromApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("csrId", csrId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/x-x509-ca-cert", "application/pkix-cert", "application/x-pem-file"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<JsonWebKey> localReturnType = new ParameterizedTypeReference<JsonWebKey>() {};
            ResponseEntity<JsonWebKey> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs/{csrId}/lifecycle/publish", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Replace an Application
        * Replaces an application
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param application  (required)
                * @return Application
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public Application replaceApplication(String appId, Application application) throws RestClientException {
                return replaceApplicationWithHttpInfo(appId, application).getBody();
            }




            /**
            * Replace an Application
            * Replaces an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param appId  (required)
                * @param application  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T replaceApplication(Class<?> T, String appId, Application application) throws RestClientException {
                return (T) getObjectMapper().convertValue(replaceApplicationWithReturnType(T, appId, application).getBody(), T);
            }




            /**
            * Replace an Application
            * Replaces an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param application  (required)
            * @return ResponseEntity&lt;Application&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Application> replaceApplicationWithHttpInfo(String appId, Application application) throws RestClientException {
            Object localVarPostBody = application;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling replaceApplication");
                }
        
                // verify the required parameter 'application' is set ''
                if (application == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'application' when calling replaceApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Application> localReturnType = new ParameterizedTypeReference<Application>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace an Application
            * Replaces an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param application  (required)
            * @return ResponseEntity&lt;Application&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> replaceApplicationWithReturnType(Class<?> T, String appId,Application application) throws RestClientException {
            Object localVarPostBody = application;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling replaceApplication");
                }
        
                // verify the required parameter 'application' is set
                if (application == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'application' when calling replaceApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Replace an Application
            * Replaces an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param application  (required)
            * @return ResponseEntity&lt;Application&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList replaceApplicationWithPaginationInfo(String appId, Application application) throws RestClientException {
            Object localVarPostBody = application;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling replaceApplication");
                }
        
                // verify the required parameter 'application' is set
                if (application == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'application' when calling replaceApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Application> localReturnType = new ParameterizedTypeReference<Application>() {};
            ResponseEntity<Application> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Revoke a Certificate Signing Request
        * Revokes a certificate signing request and deletes the key pair from the application
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param csrId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeCsrFromApplication(String appId, String csrId) throws RestClientException {
            revokeCsrFromApplicationWithHttpInfo(appId, csrId);
            }






            /**
            * Revoke a Certificate Signing Request
            * Revokes a certificate signing request and deletes the key pair from the application
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param csrId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeCsrFromApplicationWithHttpInfo(String appId, String csrId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling revokeCsrFromApplication");
                }
        
                // verify the required parameter 'csrId' is set ''
                if (csrId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'csrId' when calling revokeCsrFromApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("csrId", csrId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/credentials/csrs/{csrId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Revoke an OAuth 2.0 Token
        * Revokes the specified token for the specified application
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param tokenId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeOAuth2TokenForApplication(String appId, String tokenId) throws RestClientException {
            revokeOAuth2TokenForApplicationWithHttpInfo(appId, tokenId);
            }






            /**
            * Revoke an OAuth 2.0 Token
            * Revokes the specified token for the specified application
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param tokenId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeOAuth2TokenForApplicationWithHttpInfo(String appId, String tokenId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling revokeOAuth2TokenForApplication");
                }
        
                // verify the required parameter 'tokenId' is set ''
                if (tokenId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tokenId' when calling revokeOAuth2TokenForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("tokenId", tokenId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/tokens/{tokenId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Revoke all OAuth 2.0 Tokens
        * Revokes all tokens for the specified application
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeOAuth2TokensForApplication(String appId) throws RestClientException {
            revokeOAuth2TokensForApplicationWithHttpInfo(appId);
            }






            /**
            * Revoke all OAuth 2.0 Tokens
            * Revokes all tokens for the specified application
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeOAuth2TokensForApplicationWithHttpInfo(String appId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling revokeOAuth2TokensForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/tokens", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Revoke a Scope Consent Grant
        * Revokes permission for the application to request the given scope
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param grantId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void revokeScopeConsentGrant(String appId, String grantId) throws RestClientException {
            revokeScopeConsentGrantWithHttpInfo(appId, grantId);
            }






            /**
            * Revoke a Scope Consent Grant
            * Revokes permission for the application to request the given scope
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param grantId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> revokeScopeConsentGrantWithHttpInfo(String appId, String grantId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling revokeScopeConsentGrant");
                }
        
                // verify the required parameter 'grantId' is set ''
                if (grantId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'grantId' when calling revokeScopeConsentGrant");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("grantId", grantId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/grants/{grantId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Unassign a Group
        * Unassigns a group from an application
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param groupId  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unassignApplicationFromGroup(String appId, String groupId) throws RestClientException {
            unassignApplicationFromGroupWithHttpInfo(appId, groupId);
            }






            /**
            * Unassign a Group
            * Unassigns a group from an application
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param groupId  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unassignApplicationFromGroupWithHttpInfo(String appId, String groupId) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling unassignApplicationFromGroup");
                }
        
                // verify the required parameter 'groupId' is set ''
                if (groupId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'groupId' when calling unassignApplicationFromGroup");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("groupId", groupId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/groups/{groupId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Unassign a User
        * Unassigns a user from an application
            * <p><b>204</b> - No Content
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param userId  (required)
                * @param sendEmail  (optional, default to false)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void unassignUserFromApplication(String appId, String userId, Boolean sendEmail) throws RestClientException {
            unassignUserFromApplicationWithHttpInfo(appId, userId, sendEmail);
            }






            /**
            * Unassign a User
            * Unassigns a user from an application
                * <p><b>204</b> - No Content
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param userId  (required)
                * @param sendEmail  (optional, default to false)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> unassignUserFromApplicationWithHttpInfo(String appId, String userId, Boolean sendEmail) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling unassignUserFromApplication");
                }
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling unassignUserFromApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sendEmail", sendEmail));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = {  };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/users/{userId}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }







        /**
        * Update an Application Profile for Assigned User
        * Updates a user&#39;s profile for an application
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param userId  (required)
                * @param appUser  (required)
                * @return AppUser
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public AppUser updateApplicationUser(String appId, String userId, AppUser appUser) throws RestClientException {
                return updateApplicationUserWithHttpInfo(appId, userId, appUser).getBody();
            }




            /**
            * Update an Application Profile for Assigned User
            * Updates a user&#39;s profile for an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param appId  (required)
                * @param userId  (required)
                * @param appUser  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T updateApplicationUser(Class<?> T, String appId, String userId, AppUser appUser) throws RestClientException {
                return (T) getObjectMapper().convertValue(updateApplicationUserWithReturnType(T, appId, userId, appUser).getBody(), T);
            }




            /**
            * Update an Application Profile for Assigned User
            * Updates a user&#39;s profile for an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param userId  (required)
                * @param appUser  (required)
            * @return ResponseEntity&lt;AppUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<AppUser> updateApplicationUserWithHttpInfo(String appId, String userId, AppUser appUser) throws RestClientException {
            Object localVarPostBody = appUser;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateApplicationUser");
                }
        
                // verify the required parameter 'userId' is set ''
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling updateApplicationUser");
                }
        
                // verify the required parameter 'appUser' is set ''
                if (appUser == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appUser' when calling updateApplicationUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AppUser> localReturnType = new ParameterizedTypeReference<AppUser>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/users/{userId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update an Application Profile for Assigned User
            * Updates a user&#39;s profile for an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param userId  (required)
                * @param appUser  (required)
            * @return ResponseEntity&lt;AppUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> updateApplicationUserWithReturnType(Class<?> T, String appId,String userId,AppUser appUser) throws RestClientException {
            Object localVarPostBody = appUser;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateApplicationUser");
                }
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling updateApplicationUser");
                }
        
                // verify the required parameter 'appUser' is set
                if (appUser == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appUser' when calling updateApplicationUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/users/{userId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update an Application Profile for Assigned User
            * Updates a user&#39;s profile for an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param userId  (required)
                * @param appUser  (required)
            * @return ResponseEntity&lt;AppUser&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList updateApplicationUserWithPaginationInfo(String appId, String userId, AppUser appUser) throws RestClientException {
            Object localVarPostBody = appUser;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateApplicationUser");
                }
        
                // verify the required parameter 'userId' is set
                if (userId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'userId' when calling updateApplicationUser");
                }
        
                // verify the required parameter 'appUser' is set
                if (appUser == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appUser' when calling updateApplicationUser");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("userId", userId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<AppUser> localReturnType = new ParameterizedTypeReference<AppUser>() {};
            ResponseEntity<AppUser> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/users/{userId}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Update the default Provisioning Connection
        * Updates the default provisioning connection for application
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param provisioningConnectionRequest  (required)
                * @param activate  (optional)
                * @return ProvisioningConnection
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ProvisioningConnection updateDefaultProvisioningConnectionForApplication(String appId, ProvisioningConnectionRequest provisioningConnectionRequest, Boolean activate) throws RestClientException {
                return updateDefaultProvisioningConnectionForApplicationWithHttpInfo(appId, provisioningConnectionRequest, activate).getBody();
            }




            /**
            * Update the default Provisioning Connection
            * Updates the default provisioning connection for application
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param appId  (required)
                * @param provisioningConnectionRequest  (required)
                * @param activate  (optional)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T updateDefaultProvisioningConnectionForApplication(Class<?> T, String appId, ProvisioningConnectionRequest provisioningConnectionRequest, Boolean activate) throws RestClientException {
                return (T) getObjectMapper().convertValue(updateDefaultProvisioningConnectionForApplicationWithReturnType(T, appId, provisioningConnectionRequest, activate).getBody(), T);
            }




            /**
            * Update the default Provisioning Connection
            * Updates the default provisioning connection for application
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param provisioningConnectionRequest  (required)
                * @param activate  (optional)
            * @return ResponseEntity&lt;ProvisioningConnection&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ProvisioningConnection> updateDefaultProvisioningConnectionForApplicationWithHttpInfo(String appId, ProvisioningConnectionRequest provisioningConnectionRequest, Boolean activate) throws RestClientException {
            Object localVarPostBody = provisioningConnectionRequest;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateDefaultProvisioningConnectionForApplication");
                }
        
                // verify the required parameter 'provisioningConnectionRequest' is set ''
                if (provisioningConnectionRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'provisioningConnectionRequest' when calling updateDefaultProvisioningConnectionForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "activate", activate));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ProvisioningConnection> localReturnType = new ParameterizedTypeReference<ProvisioningConnection>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update the default Provisioning Connection
            * Updates the default provisioning connection for application
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param provisioningConnectionRequest  (required)
                * @param activate  (optional)
            * @return ResponseEntity&lt;ProvisioningConnection&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> updateDefaultProvisioningConnectionForApplicationWithReturnType(Class<?> T, String appId,ProvisioningConnectionRequest provisioningConnectionRequest,Boolean activate) throws RestClientException {
            Object localVarPostBody = provisioningConnectionRequest;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateDefaultProvisioningConnectionForApplication");
                }
        
                // verify the required parameter 'provisioningConnectionRequest' is set
                if (provisioningConnectionRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'provisioningConnectionRequest' when calling updateDefaultProvisioningConnectionForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "activate", activate));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update the default Provisioning Connection
            * Updates the default provisioning connection for application
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param provisioningConnectionRequest  (required)
                * @param activate  (optional)
            * @return ResponseEntity&lt;ProvisioningConnection&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList updateDefaultProvisioningConnectionForApplicationWithPaginationInfo(String appId, ProvisioningConnectionRequest provisioningConnectionRequest, Boolean activate) throws RestClientException {
            Object localVarPostBody = provisioningConnectionRequest;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateDefaultProvisioningConnectionForApplication");
                }
        
                // verify the required parameter 'provisioningConnectionRequest' is set
                if (provisioningConnectionRequest == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'provisioningConnectionRequest' when calling updateDefaultProvisioningConnectionForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "activate", activate));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ProvisioningConnection> localReturnType = new ParameterizedTypeReference<ProvisioningConnection>() {};
            ResponseEntity<ProvisioningConnection> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/connections/default", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Update a Feature
        * Updates a Feature object for an application
            * <p><b>200</b> - Success
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param name  (required)
                * @param capabilitiesObject  (required)
                * @return ApplicationFeature
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public ApplicationFeature updateFeatureForApplication(String appId, String name, CapabilitiesObject capabilitiesObject) throws RestClientException {
                return updateFeatureForApplicationWithHttpInfo(appId, name, capabilitiesObject).getBody();
            }




            /**
            * Update a Feature
            * Updates a Feature object for an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param T (required) - the assignable return type
                * @param appId  (required)
                * @param name  (required)
                * @param capabilitiesObject  (required)
                * @return T instance
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public <T> T updateFeatureForApplication(Class<?> T, String appId, String name, CapabilitiesObject capabilitiesObject) throws RestClientException {
                return (T) getObjectMapper().convertValue(updateFeatureForApplicationWithReturnType(T, appId, name, capabilitiesObject).getBody(), T);
            }




            /**
            * Update a Feature
            * Updates a Feature object for an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param name  (required)
                * @param capabilitiesObject  (required)
            * @return ResponseEntity&lt;ApplicationFeature&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<ApplicationFeature> updateFeatureForApplicationWithHttpInfo(String appId, String name, CapabilitiesObject capabilitiesObject) throws RestClientException {
            Object localVarPostBody = capabilitiesObject;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateFeatureForApplication");
                }
        
                // verify the required parameter 'name' is set ''
                if (name == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'name' when calling updateFeatureForApplication");
                }
        
                // verify the required parameter 'capabilitiesObject' is set ''
                if (capabilitiesObject == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'capabilitiesObject' when calling updateFeatureForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("name", name);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ApplicationFeature> localReturnType = new ParameterizedTypeReference<ApplicationFeature>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/features/{name}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update a Feature
            * Updates a Feature object for an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param name  (required)
                * @param capabilitiesObject  (required)
            * @return ResponseEntity&lt;ApplicationFeature&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private <T> ResponseEntity<T> updateFeatureForApplicationWithReturnType(Class<?> T, String appId,String name,CapabilitiesObject capabilitiesObject) throws RestClientException {
            Object localVarPostBody = capabilitiesObject;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateFeatureForApplication");
                }
        
                // verify the required parameter 'name' is set
                if (name == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'name' when calling updateFeatureForApplication");
                }
        
                // verify the required parameter 'capabilitiesObject' is set
                if (capabilitiesObject == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'capabilitiesObject' when calling updateFeatureForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("name", name);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<T> localReturnType = new ParameterizedTypeReference<T>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/features/{name}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }




            /**
            * Update a Feature
            * Updates a Feature object for an application
                * <p><b>200</b> - Success
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param name  (required)
                * @param capabilitiesObject  (required)
            * @return ResponseEntity&lt;ApplicationFeature&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public PagedList updateFeatureForApplicationWithPaginationInfo(String appId, String name, CapabilitiesObject capabilitiesObject) throws RestClientException {
            Object localVarPostBody = capabilitiesObject;
        
                // verify the required parameter 'appId' is set
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling updateFeatureForApplication");
                }
        
                // verify the required parameter 'name' is set
                if (name == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'name' when calling updateFeatureForApplication");
                }
        
                // verify the required parameter 'capabilitiesObject' is set
                if (capabilitiesObject == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'capabilitiesObject' when calling updateFeatureForApplication");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);
                    uriVariables.put("name", name);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "application/json"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<ApplicationFeature> localReturnType = new ParameterizedTypeReference<ApplicationFeature>() {};
            ResponseEntity<ApplicationFeature> responseEntity = apiClient.invokeAPI("/api/v1/apps/{appId}/features/{name}", HttpMethod.PUT, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
                    HttpHeaders headers = responseEntity.getHeaders();
                    PagedList pagedList = new PagedList();
                    List<String> linkHeaders = headers.get("link");
                    String self = null, nextPage = null;
                    for (String link : linkHeaders) {
                    if (link.contains("next")) {
                    nextPage = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    if (link.contains("self")) {
                    self = link.split(";")[0]
                    .replaceAll("<", "")
                    .replaceAll(">", "");
                    }
                    }
                    pagedList.addItems(Arrays.asList(responseEntity.getBody()));
                    if (Objects.nonNull(nextPage)) {
                    pagedList.setNextPage(nextPage);
                    }
                    if (Objects.nonNull(self)) {
                    pagedList.setSelf(self);
                    }
                    return pagedList;
        }

        /**
        * Upload a Logo
        * The file must be in PNG, JPG, or GIF format, and less than 1 MB in size. For best results use landscape orientation, a transparent background, and a minimum size of 420px by 120px to prevent upscaling.
            * <p><b>201</b> - Created
            * <p><b>400</b> - Bad Request
            * <p><b>403</b> - Forbidden
            * <p><b>404</b> - Not Found
            * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param _file  (required)
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            public void uploadApplicationLogo(String appId, File _file) throws RestClientException {
            uploadApplicationLogoWithHttpInfo(appId, _file);
            }






            /**
            * Upload a Logo
            * The file must be in PNG, JPG, or GIF format, and less than 1 MB in size. For best results use landscape orientation, a transparent background, and a minimum size of 420px by 120px to prevent upscaling.
                * <p><b>201</b> - Created
                * <p><b>400</b> - Bad Request
                * <p><b>403</b> - Forbidden
                * <p><b>404</b> - Not Found
                * <p><b>429</b> - Too Many Requests
                * @param appId  (required)
                * @param _file  (required)
            * @return ResponseEntity&lt;Void&gt;
            * @throws RestClientException if an error occurs while attempting to invoke the API
            */
            private ResponseEntity<Void> uploadApplicationLogoWithHttpInfo(String appId, File _file) throws RestClientException {
            Object localVarPostBody = null;
        
                // verify the required parameter 'appId' is set ''
                if (appId == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'appId' when calling uploadApplicationLogo");
                }
        
                // verify the required parameter '_file' is set ''
                if (_file == null) {
                throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter '_file' when calling uploadApplicationLogo");
                }
        
                // create path and map variables
                final Map<String, Object> uriVariables = new HashMap<String, Object>();
                    uriVariables.put("appId", appId);

            final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
            final HttpHeaders localVarHeaderParams = new HttpHeaders();
            final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
            final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

            if (_file != null)
                localVarFormParams.add("file", new FileSystemResource(_file));

            final String[] localVarAccepts = { 
            "application/json"
         };
            final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
            final String[] localVarContentTypes = { 
            "multipart/form-data"
         };
            final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

            String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
            return apiClient.invokeAPI("/api/v1/apps/{appId}/logo", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
            }








    private ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }
        }
