package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets VerifyUserFactorResult
 */
public enum VerifyUserFactorResult {
  
  CHALLENGE("CHALLENGE"),
  
  ERROR("ERROR"),
  
  EXPIRED("EXPIRED"),
  
  FAILED("FAILED"),
  
  PASSCODE_REPLAYED("PASSCODE_REPLAYED"),
  
  REJECTED("REJECTED"),
  
  SUCCESS("SUCCESS"),
  
  TIMEOUT("TIMEOUT"),
  
  TIME_WINDOW_EXCEEDED("TIME_WINDOW_EXCEEDED"),
  
  WAITING("WAITING");

  private String value;

  VerifyUserFactorResult(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static VerifyUserFactorResult fromValue(String value) {
    for (VerifyUserFactorResult b : VerifyUserFactorResult.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

