package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets UserStatus
 */
public enum UserStatus {
  
  ACTIVE("ACTIVE"),
  
  DEPROVISIONED("DEPROVISIONED"),
  
  LOCKED_OUT("LOCKED_OUT"),
  
  PASSWORD_EXPIRED("PASSWORD_EXPIRED"),
  
  PROVISIONED("PROVISIONED"),
  
  RECOVERY("RECOVERY"),
  
  STAGED("STAGED"),
  
  SUSPENDED("SUSPENDED");

  private String value;

  UserStatus(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static UserStatus fromValue(String value) {
    for (UserStatus b : UserStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

