package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonSubTypes;
    import com.fasterxml.jackson.annotation.JsonTypeInfo;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import java.util.HashMap;
    import java.util.Map;
    import org.openapitools.client.model.CallUserFactor;
    import org.openapitools.client.model.CustomHotpUserFactor;
    import org.openapitools.client.model.EmailUserFactor;
    import org.openapitools.client.model.FactorProvider;
    import org.openapitools.client.model.FactorStatus;
    import org.openapitools.client.model.FactorType;
    import org.openapitools.client.model.HardwareUserFactor;
    import org.openapitools.client.model.PushUserFactor;
    import org.openapitools.client.model.SecurityQuestionUserFactor;
    import org.openapitools.client.model.SmsUserFactor;
    import org.openapitools.client.model.TokenUserFactor;
    import org.openapitools.client.model.TotpUserFactor;
    import org.openapitools.client.model.U2fUserFactor;
    import org.openapitools.client.model.VerifyFactorRequest;
    import org.openapitools.client.model.WebAuthnUserFactor;
    import org.openapitools.client.model.WebUserFactor;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* UserFactor
*/
    @JsonPropertyOrder({
        UserFactor.JSON_PROPERTY_CREATED,
        UserFactor.JSON_PROPERTY_FACTOR_TYPE,
        UserFactor.JSON_PROPERTY_ID,
        UserFactor.JSON_PROPERTY_LAST_UPDATED,
        UserFactor.JSON_PROPERTY_PROVIDER,
        UserFactor.JSON_PROPERTY_STATUS,
        UserFactor.JSON_PROPERTY_VERIFY,
        UserFactor.JSON_PROPERTY_EMBEDDED,
        UserFactor.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class UserFactor {


        public static final String JSON_PROPERTY_CREATED = "created";
            private OffsetDateTime created;

        public static final String JSON_PROPERTY_FACTOR_TYPE = "factorType";
            protected FactorType factorType;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
            private OffsetDateTime lastUpdated;

        public static final String JSON_PROPERTY_PROVIDER = "provider";
            private FactorProvider provider;

        public static final String JSON_PROPERTY_STATUS = "status";
            private FactorStatus status;

        public static final String JSON_PROPERTY_VERIFY = "verify";
            private VerifyFactorRequest verify;

        public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
            private Map<String, Object> embedded = null;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private Map<String, Object> links = null;

public UserFactor() { 
}

    /*
    @JsonCreator
    public UserFactor(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated, 
        @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded, 
        @JsonProperty(JSON_PROPERTY_LINKS) Map<String, Object> links
    ) {
    this();
        this.created = created;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.embedded = embedded;
        this.links = links;
    }*/


    /**
        * Get created
    * @return created
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }




        public UserFactor factorType(FactorType factorType) {
        
        this.factorType = factorType;
        return this;
        }

    /**
        * Get factorType
    * @return factorType
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_FACTOR_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FactorType getFactorType() {
        return factorType;
    }


          @JsonProperty(JSON_PROPERTY_FACTOR_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFactorType(FactorType factorType) {
            this.factorType = factorType;
        }


    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




    /**
        * Get lastUpdated
    * @return lastUpdated
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }




        public UserFactor provider(FactorProvider provider) {
        
        this.provider = provider;
        return this;
        }

    /**
        * Get provider
    * @return provider
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FactorProvider getProvider() {
        return provider;
    }


          @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProvider(FactorProvider provider) {
            this.provider = provider;
        }


        public UserFactor status(FactorStatus status) {
        
        this.status = status;
        return this;
        }

    /**
        * Get status
    * @return status
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FactorStatus getStatus() {
        return status;
    }


          @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(FactorStatus status) {
            this.status = status;
        }


        public UserFactor verify(VerifyFactorRequest verify) {
        
        this.verify = verify;
        return this;
        }

    /**
        * Get verify
    * @return verify
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_VERIFY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public VerifyFactorRequest getVerify() {
        return verify;
    }


          @JsonProperty(JSON_PROPERTY_VERIFY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVerify(VerifyFactorRequest verify) {
            this.verify = verify;
        }


    /**
        * Get embedded
    * @return embedded
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_EMBEDDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getEmbedded() {
        return embedded;
    }




    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getLinks() {
        return links;
    }




@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        UserFactor userFactor = (UserFactor) o;
        return Objects.equals(this.created, userFactor.created) &&
        Objects.equals(this.factorType, userFactor.factorType) &&
        Objects.equals(this.id, userFactor.id) &&
        Objects.equals(this.lastUpdated, userFactor.lastUpdated) &&
        Objects.equals(this.provider, userFactor.provider) &&
        Objects.equals(this.status, userFactor.status) &&
        Objects.equals(this.verify, userFactor.verify) &&
        Objects.equals(this.embedded, userFactor.embedded) &&
        Objects.equals(this.links, userFactor.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(created, factorType, id, lastUpdated, provider, status, verify, embedded, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserFactor {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    factorType: ").append(toIndentedString(factorType)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    verify: ").append(toIndentedString(verify)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
