package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import java.util.ArrayList;
    import java.util.List;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* SocialAuthToken
*/
    @JsonPropertyOrder({
        SocialAuthToken.JSON_PROPERTY_EXPIRES_AT,
        SocialAuthToken.JSON_PROPERTY_ID,
        SocialAuthToken.JSON_PROPERTY_SCOPES,
        SocialAuthToken.JSON_PROPERTY_TOKEN,
        SocialAuthToken.JSON_PROPERTY_TOKEN_AUTH_SCHEME,
        SocialAuthToken.JSON_PROPERTY_TOKEN_TYPE
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class SocialAuthToken {


        public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
            private OffsetDateTime expiresAt;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_SCOPES = "scopes";
            private List<String> scopes = null;

        public static final String JSON_PROPERTY_TOKEN = "token";
            private String token;

        public static final String JSON_PROPERTY_TOKEN_AUTH_SCHEME = "tokenAuthScheme";
            private String tokenAuthScheme;

        public static final String JSON_PROPERTY_TOKEN_TYPE = "tokenType";
            private String tokenType;

public SocialAuthToken() { 
}

    /*
    @JsonCreator
    public SocialAuthToken(
        @JsonProperty(JSON_PROPERTY_EXPIRES_AT) OffsetDateTime expiresAt, 
        @JsonProperty(JSON_PROPERTY_ID) String id
    ) {
    this();
        this.expiresAt = expiresAt;
        this.id = id;
    }*/


    /**
        * Get expiresAt
    * @return expiresAt
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getExpiresAt() {
        return expiresAt;
    }




    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




        public SocialAuthToken scopes(List<String> scopes) {
        
        this.scopes = scopes;
        return this;
        }

            public SocialAuthToken addScopesItem(String scopesItem) {
                    if (this.scopes == null) {
                    this.scopes = new ArrayList<>();
                    }
                this.scopes.add(scopesItem);
                return this;
            }

    /**
        * Get scopes
    * @return scopes
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SCOPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getScopes() {
        return scopes;
    }


          @JsonProperty(JSON_PROPERTY_SCOPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }


        public SocialAuthToken token(String token) {
        
        this.token = token;
        return this;
        }

    /**
        * Get token
    * @return token
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getToken() {
        return token;
    }


          @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setToken(String token) {
            this.token = token;
        }


        public SocialAuthToken tokenAuthScheme(String tokenAuthScheme) {
        
        this.tokenAuthScheme = tokenAuthScheme;
        return this;
        }

    /**
        * Get tokenAuthScheme
    * @return tokenAuthScheme
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_TOKEN_AUTH_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTokenAuthScheme() {
        return tokenAuthScheme;
    }


          @JsonProperty(JSON_PROPERTY_TOKEN_AUTH_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenAuthScheme(String tokenAuthScheme) {
            this.tokenAuthScheme = tokenAuthScheme;
        }


        public SocialAuthToken tokenType(String tokenType) {
        
        this.tokenType = tokenType;
        return this;
        }

    /**
        * Get tokenType
    * @return tokenType
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_TOKEN_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTokenType() {
        return tokenType;
    }


          @JsonProperty(JSON_PROPERTY_TOKEN_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        SocialAuthToken socialAuthToken = (SocialAuthToken) o;
        return Objects.equals(this.expiresAt, socialAuthToken.expiresAt) &&
        Objects.equals(this.id, socialAuthToken.id) &&
        Objects.equals(this.scopes, socialAuthToken.scopes) &&
        Objects.equals(this.token, socialAuthToken.token) &&
        Objects.equals(this.tokenAuthScheme, socialAuthToken.tokenAuthScheme) &&
        Objects.equals(this.tokenType, socialAuthToken.tokenType);
}

    @Override
    public int hashCode() {
        return Objects.hash(expiresAt, id, scopes, token, tokenAuthScheme, tokenType);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SocialAuthToken {\n");
        sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
        sb.append("    token: ").append(toIndentedString(token)).append("\n");
        sb.append("    tokenAuthScheme: ").append(toIndentedString(tokenAuthScheme)).append("\n");
        sb.append("    tokenType: ").append(toIndentedString(tokenType)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
