package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.util.ArrayList;
    import java.util.List;
    import org.openapitools.client.model.IdentityProviderCredentials;
    import org.openapitools.client.model.ProtocolAlgorithms;
    import org.openapitools.client.model.ProtocolEndpoint;
    import org.openapitools.client.model.ProtocolEndpoints;
    import org.openapitools.client.model.ProtocolRelayState;
    import org.openapitools.client.model.ProtocolSettings;
    import org.openapitools.client.model.ProtocolType;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* Protocol
*/
    @JsonPropertyOrder({
        Protocol.JSON_PROPERTY_ALGORITHMS,
        Protocol.JSON_PROPERTY_CREDENTIALS,
        Protocol.JSON_PROPERTY_ENDPOINTS,
        Protocol.JSON_PROPERTY_ISSUER,
        Protocol.JSON_PROPERTY_RELAY_STATE,
        Protocol.JSON_PROPERTY_SCOPES,
        Protocol.JSON_PROPERTY_SETTINGS,
        Protocol.JSON_PROPERTY_TYPE
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class Protocol {


        public static final String JSON_PROPERTY_ALGORITHMS = "algorithms";
            private ProtocolAlgorithms algorithms;

        public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
            private IdentityProviderCredentials credentials;

        public static final String JSON_PROPERTY_ENDPOINTS = "endpoints";
            private ProtocolEndpoints endpoints;

        public static final String JSON_PROPERTY_ISSUER = "issuer";
            private ProtocolEndpoint issuer;

        public static final String JSON_PROPERTY_RELAY_STATE = "relayState";
            private ProtocolRelayState relayState;

        public static final String JSON_PROPERTY_SCOPES = "scopes";
            private List<String> scopes = null;

        public static final String JSON_PROPERTY_SETTINGS = "settings";
            private ProtocolSettings settings;

        public static final String JSON_PROPERTY_TYPE = "type";
            private ProtocolType type;

public Protocol() { 
}

        public Protocol algorithms(ProtocolAlgorithms algorithms) {
        
        this.algorithms = algorithms;
        return this;
        }

    /**
        * Get algorithms
    * @return algorithms
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ALGORITHMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolAlgorithms getAlgorithms() {
        return algorithms;
    }


          @JsonProperty(JSON_PROPERTY_ALGORITHMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlgorithms(ProtocolAlgorithms algorithms) {
            this.algorithms = algorithms;
        }


        public Protocol credentials(IdentityProviderCredentials credentials) {
        
        this.credentials = credentials;
        return this;
        }

    /**
        * Get credentials
    * @return credentials
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IdentityProviderCredentials getCredentials() {
        return credentials;
    }


          @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCredentials(IdentityProviderCredentials credentials) {
            this.credentials = credentials;
        }


        public Protocol endpoints(ProtocolEndpoints endpoints) {
        
        this.endpoints = endpoints;
        return this;
        }

    /**
        * Get endpoints
    * @return endpoints
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ENDPOINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolEndpoints getEndpoints() {
        return endpoints;
    }


          @JsonProperty(JSON_PROPERTY_ENDPOINTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndpoints(ProtocolEndpoints endpoints) {
            this.endpoints = endpoints;
        }


        public Protocol issuer(ProtocolEndpoint issuer) {
        
        this.issuer = issuer;
        return this;
        }

    /**
        * Get issuer
    * @return issuer
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolEndpoint getIssuer() {
        return issuer;
    }


          @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuer(ProtocolEndpoint issuer) {
            this.issuer = issuer;
        }


        public Protocol relayState(ProtocolRelayState relayState) {
        
        this.relayState = relayState;
        return this;
        }

    /**
        * Get relayState
    * @return relayState
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_RELAY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolRelayState getRelayState() {
        return relayState;
    }


          @JsonProperty(JSON_PROPERTY_RELAY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRelayState(ProtocolRelayState relayState) {
            this.relayState = relayState;
        }


        public Protocol scopes(List<String> scopes) {
        
        this.scopes = scopes;
        return this;
        }

            public Protocol addScopesItem(String scopesItem) {
                    if (this.scopes == null) {
                    this.scopes = new ArrayList<>();
                    }
                this.scopes.add(scopesItem);
                return this;
            }

    /**
        * Get scopes
    * @return scopes
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SCOPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getScopes() {
        return scopes;
    }


          @JsonProperty(JSON_PROPERTY_SCOPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScopes(List<String> scopes) {
            this.scopes = scopes;
        }


        public Protocol settings(ProtocolSettings settings) {
        
        this.settings = settings;
        return this;
        }

    /**
        * Get settings
    * @return settings
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolSettings getSettings() {
        return settings;
    }


          @JsonProperty(JSON_PROPERTY_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSettings(ProtocolSettings settings) {
            this.settings = settings;
        }


        public Protocol type(ProtocolType type) {
        
        this.type = type;
        return this;
        }

    /**
        * Get type
    * @return type
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolType getType() {
        return type;
    }


          @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(ProtocolType type) {
            this.type = type;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        Protocol protocol = (Protocol) o;
        return Objects.equals(this.algorithms, protocol.algorithms) &&
        Objects.equals(this.credentials, protocol.credentials) &&
        Objects.equals(this.endpoints, protocol.endpoints) &&
        Objects.equals(this.issuer, protocol.issuer) &&
        Objects.equals(this.relayState, protocol.relayState) &&
        Objects.equals(this.scopes, protocol.scopes) &&
        Objects.equals(this.settings, protocol.settings) &&
        Objects.equals(this.type, protocol.type);
}

    @Override
    public int hashCode() {
        return Objects.hash(algorithms, credentials, endpoints, issuer, relayState, scopes, settings, type);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Protocol {\n");
        sb.append("    algorithms: ").append(toIndentedString(algorithms)).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    endpoints: ").append(toIndentedString(endpoints)).append("\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("    relayState: ").append(toIndentedString(relayState)).append("\n");
        sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
