package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets PolicySubjectMatchType
 */
public enum PolicySubjectMatchType {
  
  CUSTOM_ATTRIBUTE("CUSTOM_ATTRIBUTE"),
  
  EMAIL("EMAIL"),
  
  USERNAME("USERNAME"),
  
  USERNAME_OR_EMAIL("USERNAME_OR_EMAIL");

  private String value;

  PolicySubjectMatchType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static PolicySubjectMatchType fromValue(String value) {
    for (PolicySubjectMatchType b : PolicySubjectMatchType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

