package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets PasswordPolicyAuthenticationProviderType
 */
public enum PasswordPolicyAuthenticationProviderType {
  
  ACTIVE_DIRECTORY("ACTIVE_DIRECTORY"),
  
  ANY("ANY"),
  
  LDAP("LDAP"),
  
  OKTA("OKTA");

  private String value;

  PasswordPolicyAuthenticationProviderType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static PasswordPolicyAuthenticationProviderType fromValue(String value) {
    for (PasswordPolicyAuthenticationProviderType b : PasswordPolicyAuthenticationProviderType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

