package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.util.ArrayList;
    import java.util.List;
    import org.openapitools.client.model.OAuthGrantType;
    import org.openapitools.client.model.OAuthResponseType;
    import org.openapitools.client.model.OpenIdConnectApplicationConsentMethod;
    import org.openapitools.client.model.OpenIdConnectApplicationIdpInitiatedLogin;
    import org.openapitools.client.model.OpenIdConnectApplicationIssuerMode;
    import org.openapitools.client.model.OpenIdConnectApplicationSettingsClientKeys;
    import org.openapitools.client.model.OpenIdConnectApplicationSettingsRefreshToken;
    import org.openapitools.client.model.OpenIdConnectApplicationType;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* OpenIdConnectApplicationSettingsClient
*/
    @JsonPropertyOrder({
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_APPLICATION_TYPE,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_CLIENT_URI,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_CONSENT_METHOD,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_GRANT_TYPES,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_IDP_INITIATED_LOGIN,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_INITIATE_LOGIN_URI,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_ISSUER_MODE,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_JWKS,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_LOGO_URI,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_POLICY_URI,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_REDIRECT_URIS,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_REFRESH_TOKEN,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_RESPONSE_TYPES,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_TOS_URI,
        OpenIdConnectApplicationSettingsClient.JSON_PROPERTY_WILDCARD_REDIRECT
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class OpenIdConnectApplicationSettingsClient {


        public static final String JSON_PROPERTY_APPLICATION_TYPE = "application_type";
            private OpenIdConnectApplicationType applicationType;

        public static final String JSON_PROPERTY_CLIENT_URI = "client_uri";
            private String clientUri;

        public static final String JSON_PROPERTY_CONSENT_METHOD = "consent_method";
            private OpenIdConnectApplicationConsentMethod consentMethod;

        public static final String JSON_PROPERTY_GRANT_TYPES = "grant_types";
            private List<OAuthGrantType> grantTypes = null;

        public static final String JSON_PROPERTY_IDP_INITIATED_LOGIN = "idp_initiated_login";
            private OpenIdConnectApplicationIdpInitiatedLogin idpInitiatedLogin;

        public static final String JSON_PROPERTY_INITIATE_LOGIN_URI = "initiate_login_uri";
            private String initiateLoginUri;

        public static final String JSON_PROPERTY_ISSUER_MODE = "issuer_mode";
            private OpenIdConnectApplicationIssuerMode issuerMode;

        public static final String JSON_PROPERTY_JWKS = "jwks";
            private OpenIdConnectApplicationSettingsClientKeys jwks;

        public static final String JSON_PROPERTY_LOGO_URI = "logo_uri";
            private String logoUri;

        public static final String JSON_PROPERTY_POLICY_URI = "policy_uri";
            private String policyUri;

        public static final String JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS = "post_logout_redirect_uris";
            private List<String> postLogoutRedirectUris = null;

        public static final String JSON_PROPERTY_REDIRECT_URIS = "redirect_uris";
            private List<String> redirectUris = null;

        public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
            private OpenIdConnectApplicationSettingsRefreshToken refreshToken;

        public static final String JSON_PROPERTY_RESPONSE_TYPES = "response_types";
            private List<OAuthResponseType> responseTypes = null;

        public static final String JSON_PROPERTY_TOS_URI = "tos_uri";
            private String tosUri;

        public static final String JSON_PROPERTY_WILDCARD_REDIRECT = "wildcard_redirect";
            private String wildcardRedirect;

public OpenIdConnectApplicationSettingsClient() { 
}

        public OpenIdConnectApplicationSettingsClient applicationType(OpenIdConnectApplicationType applicationType) {
        
        this.applicationType = applicationType;
        return this;
        }

    /**
        * Get applicationType
    * @return applicationType
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_APPLICATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationType getApplicationType() {
        return applicationType;
    }


          @JsonProperty(JSON_PROPERTY_APPLICATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationType(OpenIdConnectApplicationType applicationType) {
            this.applicationType = applicationType;
        }


        public OpenIdConnectApplicationSettingsClient clientUri(String clientUri) {
        
        this.clientUri = clientUri;
        return this;
        }

    /**
        * Get clientUri
    * @return clientUri
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CLIENT_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientUri() {
        return clientUri;
    }


          @JsonProperty(JSON_PROPERTY_CLIENT_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientUri(String clientUri) {
            this.clientUri = clientUri;
        }


        public OpenIdConnectApplicationSettingsClient consentMethod(OpenIdConnectApplicationConsentMethod consentMethod) {
        
        this.consentMethod = consentMethod;
        return this;
        }

    /**
        * Get consentMethod
    * @return consentMethod
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CONSENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationConsentMethod getConsentMethod() {
        return consentMethod;
    }


          @JsonProperty(JSON_PROPERTY_CONSENT_METHOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConsentMethod(OpenIdConnectApplicationConsentMethod consentMethod) {
            this.consentMethod = consentMethod;
        }


        public OpenIdConnectApplicationSettingsClient grantTypes(List<OAuthGrantType> grantTypes) {
        
        this.grantTypes = grantTypes;
        return this;
        }

            public OpenIdConnectApplicationSettingsClient addGrantTypesItem(OAuthGrantType grantTypesItem) {
                    if (this.grantTypes == null) {
                    this.grantTypes = new ArrayList<>();
                    }
                this.grantTypes.add(grantTypesItem);
                return this;
            }

    /**
        * Get grantTypes
    * @return grantTypes
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_GRANT_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<OAuthGrantType> getGrantTypes() {
        return grantTypes;
    }


          @JsonProperty(JSON_PROPERTY_GRANT_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGrantTypes(List<OAuthGrantType> grantTypes) {
            this.grantTypes = grantTypes;
        }


        public OpenIdConnectApplicationSettingsClient idpInitiatedLogin(OpenIdConnectApplicationIdpInitiatedLogin idpInitiatedLogin) {
        
        this.idpInitiatedLogin = idpInitiatedLogin;
        return this;
        }

    /**
        * Get idpInitiatedLogin
    * @return idpInitiatedLogin
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_IDP_INITIATED_LOGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationIdpInitiatedLogin getIdpInitiatedLogin() {
        return idpInitiatedLogin;
    }


          @JsonProperty(JSON_PROPERTY_IDP_INITIATED_LOGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdpInitiatedLogin(OpenIdConnectApplicationIdpInitiatedLogin idpInitiatedLogin) {
            this.idpInitiatedLogin = idpInitiatedLogin;
        }


        public OpenIdConnectApplicationSettingsClient initiateLoginUri(String initiateLoginUri) {
        
        this.initiateLoginUri = initiateLoginUri;
        return this;
        }

    /**
        * Get initiateLoginUri
    * @return initiateLoginUri
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_INITIATE_LOGIN_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getInitiateLoginUri() {
        return initiateLoginUri;
    }


          @JsonProperty(JSON_PROPERTY_INITIATE_LOGIN_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInitiateLoginUri(String initiateLoginUri) {
            this.initiateLoginUri = initiateLoginUri;
        }


        public OpenIdConnectApplicationSettingsClient issuerMode(OpenIdConnectApplicationIssuerMode issuerMode) {
        
        this.issuerMode = issuerMode;
        return this;
        }

    /**
        * Get issuerMode
    * @return issuerMode
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ISSUER_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationIssuerMode getIssuerMode() {
        return issuerMode;
    }


          @JsonProperty(JSON_PROPERTY_ISSUER_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuerMode(OpenIdConnectApplicationIssuerMode issuerMode) {
            this.issuerMode = issuerMode;
        }


        public OpenIdConnectApplicationSettingsClient jwks(OpenIdConnectApplicationSettingsClientKeys jwks) {
        
        this.jwks = jwks;
        return this;
        }

    /**
        * Get jwks
    * @return jwks
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_JWKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationSettingsClientKeys getJwks() {
        return jwks;
    }


          @JsonProperty(JSON_PROPERTY_JWKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJwks(OpenIdConnectApplicationSettingsClientKeys jwks) {
            this.jwks = jwks;
        }


        public OpenIdConnectApplicationSettingsClient logoUri(String logoUri) {
        
        this.logoUri = logoUri;
        return this;
        }

    /**
        * Get logoUri
    * @return logoUri
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LOGO_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLogoUri() {
        return logoUri;
    }


          @JsonProperty(JSON_PROPERTY_LOGO_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogoUri(String logoUri) {
            this.logoUri = logoUri;
        }


        public OpenIdConnectApplicationSettingsClient policyUri(String policyUri) {
        
        this.policyUri = policyUri;
        return this;
        }

    /**
        * Get policyUri
    * @return policyUri
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_POLICY_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPolicyUri() {
        return policyUri;
    }


          @JsonProperty(JSON_PROPERTY_POLICY_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicyUri(String policyUri) {
            this.policyUri = policyUri;
        }


        public OpenIdConnectApplicationSettingsClient postLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        
        this.postLogoutRedirectUris = postLogoutRedirectUris;
        return this;
        }

            public OpenIdConnectApplicationSettingsClient addPostLogoutRedirectUrisItem(String postLogoutRedirectUrisItem) {
                    if (this.postLogoutRedirectUris == null) {
                    this.postLogoutRedirectUris = new ArrayList<>();
                    }
                this.postLogoutRedirectUris.add(postLogoutRedirectUrisItem);
                return this;
            }

    /**
        * Get postLogoutRedirectUris
    * @return postLogoutRedirectUris
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getPostLogoutRedirectUris() {
        return postLogoutRedirectUris;
    }


          @JsonProperty(JSON_PROPERTY_POST_LOGOUT_REDIRECT_URIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
            this.postLogoutRedirectUris = postLogoutRedirectUris;
        }


        public OpenIdConnectApplicationSettingsClient redirectUris(List<String> redirectUris) {
        
        this.redirectUris = redirectUris;
        return this;
        }

            public OpenIdConnectApplicationSettingsClient addRedirectUrisItem(String redirectUrisItem) {
                    if (this.redirectUris == null) {
                    this.redirectUris = new ArrayList<>();
                    }
                this.redirectUris.add(redirectUrisItem);
                return this;
            }

    /**
        * Get redirectUris
    * @return redirectUris
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_REDIRECT_URIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getRedirectUris() {
        return redirectUris;
    }


          @JsonProperty(JSON_PROPERTY_REDIRECT_URIS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedirectUris(List<String> redirectUris) {
            this.redirectUris = redirectUris;
        }


        public OpenIdConnectApplicationSettingsClient refreshToken(OpenIdConnectApplicationSettingsRefreshToken refreshToken) {
        
        this.refreshToken = refreshToken;
        return this;
        }

    /**
        * Get refreshToken
    * @return refreshToken
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationSettingsRefreshToken getRefreshToken() {
        return refreshToken;
    }


          @JsonProperty(JSON_PROPERTY_REFRESH_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefreshToken(OpenIdConnectApplicationSettingsRefreshToken refreshToken) {
            this.refreshToken = refreshToken;
        }


        public OpenIdConnectApplicationSettingsClient responseTypes(List<OAuthResponseType> responseTypes) {
        
        this.responseTypes = responseTypes;
        return this;
        }

            public OpenIdConnectApplicationSettingsClient addResponseTypesItem(OAuthResponseType responseTypesItem) {
                    if (this.responseTypes == null) {
                    this.responseTypes = new ArrayList<>();
                    }
                this.responseTypes.add(responseTypesItem);
                return this;
            }

    /**
        * Get responseTypes
    * @return responseTypes
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_RESPONSE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<OAuthResponseType> getResponseTypes() {
        return responseTypes;
    }


          @JsonProperty(JSON_PROPERTY_RESPONSE_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponseTypes(List<OAuthResponseType> responseTypes) {
            this.responseTypes = responseTypes;
        }


        public OpenIdConnectApplicationSettingsClient tosUri(String tosUri) {
        
        this.tosUri = tosUri;
        return this;
        }

    /**
        * Get tosUri
    * @return tosUri
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_TOS_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTosUri() {
        return tosUri;
    }


          @JsonProperty(JSON_PROPERTY_TOS_URI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTosUri(String tosUri) {
            this.tosUri = tosUri;
        }


        public OpenIdConnectApplicationSettingsClient wildcardRedirect(String wildcardRedirect) {
        
        this.wildcardRedirect = wildcardRedirect;
        return this;
        }

    /**
        * Get wildcardRedirect
    * @return wildcardRedirect
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_WILDCARD_REDIRECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getWildcardRedirect() {
        return wildcardRedirect;
    }


          @JsonProperty(JSON_PROPERTY_WILDCARD_REDIRECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWildcardRedirect(String wildcardRedirect) {
            this.wildcardRedirect = wildcardRedirect;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        OpenIdConnectApplicationSettingsClient openIdConnectApplicationSettingsClient = (OpenIdConnectApplicationSettingsClient) o;
        return Objects.equals(this.applicationType, openIdConnectApplicationSettingsClient.applicationType) &&
        Objects.equals(this.clientUri, openIdConnectApplicationSettingsClient.clientUri) &&
        Objects.equals(this.consentMethod, openIdConnectApplicationSettingsClient.consentMethod) &&
        Objects.equals(this.grantTypes, openIdConnectApplicationSettingsClient.grantTypes) &&
        Objects.equals(this.idpInitiatedLogin, openIdConnectApplicationSettingsClient.idpInitiatedLogin) &&
        Objects.equals(this.initiateLoginUri, openIdConnectApplicationSettingsClient.initiateLoginUri) &&
        Objects.equals(this.issuerMode, openIdConnectApplicationSettingsClient.issuerMode) &&
        Objects.equals(this.jwks, openIdConnectApplicationSettingsClient.jwks) &&
        Objects.equals(this.logoUri, openIdConnectApplicationSettingsClient.logoUri) &&
        Objects.equals(this.policyUri, openIdConnectApplicationSettingsClient.policyUri) &&
        Objects.equals(this.postLogoutRedirectUris, openIdConnectApplicationSettingsClient.postLogoutRedirectUris) &&
        Objects.equals(this.redirectUris, openIdConnectApplicationSettingsClient.redirectUris) &&
        Objects.equals(this.refreshToken, openIdConnectApplicationSettingsClient.refreshToken) &&
        Objects.equals(this.responseTypes, openIdConnectApplicationSettingsClient.responseTypes) &&
        Objects.equals(this.tosUri, openIdConnectApplicationSettingsClient.tosUri) &&
        Objects.equals(this.wildcardRedirect, openIdConnectApplicationSettingsClient.wildcardRedirect);
}

    @Override
    public int hashCode() {
        return Objects.hash(applicationType, clientUri, consentMethod, grantTypes, idpInitiatedLogin, initiateLoginUri, issuerMode, jwks, logoUri, policyUri, postLogoutRedirectUris, redirectUris, refreshToken, responseTypes, tosUri, wildcardRedirect);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OpenIdConnectApplicationSettingsClient {\n");
        sb.append("    applicationType: ").append(toIndentedString(applicationType)).append("\n");
        sb.append("    clientUri: ").append(toIndentedString(clientUri)).append("\n");
        sb.append("    consentMethod: ").append(toIndentedString(consentMethod)).append("\n");
        sb.append("    grantTypes: ").append(toIndentedString(grantTypes)).append("\n");
        sb.append("    idpInitiatedLogin: ").append(toIndentedString(idpInitiatedLogin)).append("\n");
        sb.append("    initiateLoginUri: ").append(toIndentedString(initiateLoginUri)).append("\n");
        sb.append("    issuerMode: ").append(toIndentedString(issuerMode)).append("\n");
        sb.append("    jwks: ").append(toIndentedString(jwks)).append("\n");
        sb.append("    logoUri: ").append(toIndentedString(logoUri)).append("\n");
        sb.append("    policyUri: ").append(toIndentedString(policyUri)).append("\n");
        sb.append("    postLogoutRedirectUris: ").append(toIndentedString(postLogoutRedirectUris)).append("\n");
        sb.append("    redirectUris: ").append(toIndentedString(redirectUris)).append("\n");
        sb.append("    refreshToken: ").append(toIndentedString(refreshToken)).append("\n");
        sb.append("    responseTypes: ").append(toIndentedString(responseTypes)).append("\n");
        sb.append("    tosUri: ").append(toIndentedString(tosUri)).append("\n");
        sb.append("    wildcardRedirect: ").append(toIndentedString(wildcardRedirect)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
