package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets OpenIdConnectApplicationIssuerMode
 */
public enum OpenIdConnectApplicationIssuerMode {
  
  CUSTOM_URL("CUSTOM_URL"),
  
  DYNAMIC("DYNAMIC"),
  
  ORG_URL("ORG_URL");

  private String value;

  OpenIdConnectApplicationIssuerMode(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static OpenIdConnectApplicationIssuerMode fromValue(String value) {
    for (OpenIdConnectApplicationIssuerMode b : OpenIdConnectApplicationIssuerMode.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

