package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import org.openapitools.client.model.OAuthApplicationCredentials;
    import org.openapitools.client.model.OpenIdConnectApplicationSettings;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* OpenIdConnectApplicationAllOf
*/
    @JsonPropertyOrder({
        OpenIdConnectApplicationAllOf.JSON_PROPERTY_CREDENTIALS,
        OpenIdConnectApplicationAllOf.JSON_PROPERTY_NAME,
        OpenIdConnectApplicationAllOf.JSON_PROPERTY_SETTINGS
    })
        @JsonTypeName("OpenIdConnectApplication_allOf")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class OpenIdConnectApplicationAllOf {


        public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
            private OAuthApplicationCredentials credentials;

        public static final String JSON_PROPERTY_NAME = "name";
            private String name = "oidc_client";

        public static final String JSON_PROPERTY_SETTINGS = "settings";
            private OpenIdConnectApplicationSettings settings;

public OpenIdConnectApplicationAllOf() { 
}

        public OpenIdConnectApplicationAllOf credentials(OAuthApplicationCredentials credentials) {
        
        this.credentials = credentials;
        return this;
        }

    /**
        * Get credentials
    * @return credentials
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuthApplicationCredentials getCredentials() {
        return credentials;
    }


          @JsonProperty(JSON_PROPERTY_CREDENTIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCredentials(OAuthApplicationCredentials credentials) {
            this.credentials = credentials;
        }


        public OpenIdConnectApplicationAllOf name(String name) {
        
        this.name = name;
        return this;
        }

    /**
        * Get name
    * @return name
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }


          @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
            this.name = name;
        }


        public OpenIdConnectApplicationAllOf settings(OpenIdConnectApplicationSettings settings) {
        
        this.settings = settings;
        return this;
        }

    /**
        * Get settings
    * @return settings
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OpenIdConnectApplicationSettings getSettings() {
        return settings;
    }


          @JsonProperty(JSON_PROPERTY_SETTINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSettings(OpenIdConnectApplicationSettings settings) {
            this.settings = settings;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        OpenIdConnectApplicationAllOf openIdConnectApplicationAllOf = (OpenIdConnectApplicationAllOf) o;
        return Objects.equals(this.credentials, openIdConnectApplicationAllOf.credentials) &&
        Objects.equals(this.name, openIdConnectApplicationAllOf.name) &&
        Objects.equals(this.settings, openIdConnectApplicationAllOf.settings);
}

    @Override
    public int hashCode() {
        return Objects.hash(credentials, name, settings);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OpenIdConnectApplicationAllOf {\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
