package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets OAuthEndpointAuthenticationMethod
 */
public enum OAuthEndpointAuthenticationMethod {
  
  CLIENT_SECRET_BASIC("client_secret_basic"),
  
  CLIENT_SECRET_JWT("client_secret_jwt"),
  
  CLIENT_SECRET_POST("client_secret_post"),
  
  NONE("none"),
  
  PRIVATE_KEY_JWT("private_key_jwt");

  private String value;

  OAuthEndpointAuthenticationMethod(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static OAuthEndpointAuthenticationMethod fromValue(String value) {
    for (OAuthEndpointAuthenticationMethod b : OAuthEndpointAuthenticationMethod.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

