package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets OAuth2ScopeConsentGrantSource
 */
public enum OAuth2ScopeConsentGrantSource {
  
  ADMIN("ADMIN"),
  
  END_USER("END_USER");

  private String value;

  OAuth2ScopeConsentGrantSource(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static OAuth2ScopeConsentGrantSource fromValue(String value) {
    for (OAuth2ScopeConsentGrantSource b : OAuth2ScopeConsentGrantSource.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

