package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import java.util.HashMap;
    import java.util.Map;
    import org.openapitools.client.model.GrantOrTokenStatus;
    import org.openapitools.client.model.OAuth2Actor;
    import org.openapitools.client.model.OAuth2ScopeConsentGrantSource;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* OAuth2ScopeConsentGrant
*/
    @JsonPropertyOrder({
        OAuth2ScopeConsentGrant.JSON_PROPERTY_CLIENT_ID,
        OAuth2ScopeConsentGrant.JSON_PROPERTY_CREATED,
        OAuth2ScopeConsentGrant.JSON_PROPERTY_CREATED_BY,
        OAuth2ScopeConsentGrant.JSON_PROPERTY_ID,
        OAuth2ScopeConsentGrant.JSON_PROPERTY_ISSUER,
        OAuth2ScopeConsentGrant.JSON_PROPERTY_LAST_UPDATED,
        OAuth2ScopeConsentGrant.JSON_PROPERTY_SCOPE_ID,
        OAuth2ScopeConsentGrant.JSON_PROPERTY_SOURCE,
        OAuth2ScopeConsentGrant.JSON_PROPERTY_STATUS,
        OAuth2ScopeConsentGrant.JSON_PROPERTY_USER_ID,
        OAuth2ScopeConsentGrant.JSON_PROPERTY_EMBEDDED,
        OAuth2ScopeConsentGrant.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class OAuth2ScopeConsentGrant {


        public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
            private String clientId;

        public static final String JSON_PROPERTY_CREATED = "created";
            private OffsetDateTime created;

        public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
            private OAuth2Actor createdBy;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_ISSUER = "issuer";
            private String issuer;

        public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
            private OffsetDateTime lastUpdated;

        public static final String JSON_PROPERTY_SCOPE_ID = "scopeId";
            private String scopeId;

        public static final String JSON_PROPERTY_SOURCE = "source";
            private OAuth2ScopeConsentGrantSource source;

        public static final String JSON_PROPERTY_STATUS = "status";
            private GrantOrTokenStatus status;

        public static final String JSON_PROPERTY_USER_ID = "userId";
            private String userId;

        public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
            private Map<String, Object> embedded = null;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private Map<String, Object> links = null;

public OAuth2ScopeConsentGrant() { 
}

    /*
    @JsonCreator
    public OAuth2ScopeConsentGrant(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated, 
        @JsonProperty(JSON_PROPERTY_EMBEDDED) Map<String, Object> embedded, 
        @JsonProperty(JSON_PROPERTY_LINKS) Map<String, Object> links
    ) {
    this();
        this.created = created;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.embedded = embedded;
        this.links = links;
    }*/


        public OAuth2ScopeConsentGrant clientId(String clientId) {
        
        this.clientId = clientId;
        return this;
        }

    /**
        * Get clientId
    * @return clientId
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientId() {
        return clientId;
    }


          @JsonProperty(JSON_PROPERTY_CLIENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClientId(String clientId) {
            this.clientId = clientId;
        }


    /**
        * Get created
    * @return created
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }




        public OAuth2ScopeConsentGrant createdBy(OAuth2Actor createdBy) {
        
        this.createdBy = createdBy;
        return this;
        }

    /**
        * Get createdBy
    * @return createdBy
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2Actor getCreatedBy() {
        return createdBy;
    }


          @JsonProperty(JSON_PROPERTY_CREATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedBy(OAuth2Actor createdBy) {
            this.createdBy = createdBy;
        }


    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




        public OAuth2ScopeConsentGrant issuer(String issuer) {
        
        this.issuer = issuer;
        return this;
        }

    /**
        * Get issuer
    * @return issuer
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIssuer() {
        return issuer;
    }


          @JsonProperty(JSON_PROPERTY_ISSUER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssuer(String issuer) {
            this.issuer = issuer;
        }


    /**
        * Get lastUpdated
    * @return lastUpdated
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }




        public OAuth2ScopeConsentGrant scopeId(String scopeId) {
        
        this.scopeId = scopeId;
        return this;
        }

    /**
        * Get scopeId
    * @return scopeId
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SCOPE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getScopeId() {
        return scopeId;
    }


          @JsonProperty(JSON_PROPERTY_SCOPE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScopeId(String scopeId) {
            this.scopeId = scopeId;
        }


        public OAuth2ScopeConsentGrant source(OAuth2ScopeConsentGrantSource source) {
        
        this.source = source;
        return this;
        }

    /**
        * Get source
    * @return source
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2ScopeConsentGrantSource getSource() {
        return source;
    }


          @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSource(OAuth2ScopeConsentGrantSource source) {
            this.source = source;
        }


        public OAuth2ScopeConsentGrant status(GrantOrTokenStatus status) {
        
        this.status = status;
        return this;
        }

    /**
        * Get status
    * @return status
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GrantOrTokenStatus getStatus() {
        return status;
    }


          @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(GrantOrTokenStatus status) {
            this.status = status;
        }


        public OAuth2ScopeConsentGrant userId(String userId) {
        
        this.userId = userId;
        return this;
        }

    /**
        * Get userId
    * @return userId
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserId() {
        return userId;
    }


          @JsonProperty(JSON_PROPERTY_USER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserId(String userId) {
            this.userId = userId;
        }


    /**
        * Get embedded
    * @return embedded
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_EMBEDDED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getEmbedded() {
        return embedded;
    }




    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getLinks() {
        return links;
    }




@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        OAuth2ScopeConsentGrant oauth2ScopeConsentGrant = (OAuth2ScopeConsentGrant) o;
        return Objects.equals(this.clientId, oauth2ScopeConsentGrant.clientId) &&
        Objects.equals(this.created, oauth2ScopeConsentGrant.created) &&
        Objects.equals(this.createdBy, oauth2ScopeConsentGrant.createdBy) &&
        Objects.equals(this.id, oauth2ScopeConsentGrant.id) &&
        Objects.equals(this.issuer, oauth2ScopeConsentGrant.issuer) &&
        Objects.equals(this.lastUpdated, oauth2ScopeConsentGrant.lastUpdated) &&
        Objects.equals(this.scopeId, oauth2ScopeConsentGrant.scopeId) &&
        Objects.equals(this.source, oauth2ScopeConsentGrant.source) &&
        Objects.equals(this.status, oauth2ScopeConsentGrant.status) &&
        Objects.equals(this.userId, oauth2ScopeConsentGrant.userId) &&
        Objects.equals(this.embedded, oauth2ScopeConsentGrant.embedded) &&
        Objects.equals(this.links, oauth2ScopeConsentGrant.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(clientId, created, createdBy, id, issuer, lastUpdated, scopeId, source, status, userId, embedded, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OAuth2ScopeConsentGrant {\n");
        sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    scopeId: ").append(toIndentedString(scopeId)).append("\n");
        sb.append("    source: ").append(toIndentedString(source)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
