package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets NotificationType
 */
public enum NotificationType {
  
  AD_AGENT("AD_AGENT"),
  
  APP_IMPORT("APP_IMPORT"),
  
  CONNECTOR_AGENT("CONNECTOR_AGENT"),
  
  IWA_AGENT("IWA_AGENT"),
  
  LDAP_AGENT("LDAP_AGENT"),
  
  OKTA_ANNOUNCEMENT("OKTA_ANNOUNCEMENT"),
  
  OKTA_ISSUE("OKTA_ISSUE"),
  
  OKTA_UPDATE("OKTA_UPDATE"),
  
  RATELIMIT_NOTIFICATION("RATELIMIT_NOTIFICATION"),
  
  REPORT_SUSPICIOUS_ACTIVITY("REPORT_SUSPICIOUS_ACTIVITY"),
  
  USER_DEPROVISION("USER_DEPROVISION"),
  
  USER_LOCKED_OUT("USER_LOCKED_OUT");

  private String value;

  NotificationType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static NotificationType fromValue(String value) {
    for (NotificationType b : NotificationType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

