package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets IdentityProviderPolicyProvider
 */
public enum IdentityProviderPolicyProvider {
  
  ANY("ANY"),
  
  OKTA("OKTA"),
  
  SPECIFIC_IDP("SPECIFIC_IDP");

  private String value;

  IdentityProviderPolicyProvider(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static IdentityProviderPolicyProvider fromValue(String value) {
    for (IdentityProviderPolicyProvider b : IdentityProviderPolicyProvider.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

