package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import java.util.ArrayList;
    import java.util.List;
    import org.openapitools.client.model.IamRoleLinks;
    import org.openapitools.client.model.RolePermissionType;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* IamRole
*/
    @JsonPropertyOrder({
        IamRole.JSON_PROPERTY_CREATED,
        IamRole.JSON_PROPERTY_DESCRIPTION,
        IamRole.JSON_PROPERTY_ID,
        IamRole.JSON_PROPERTY_LABEL,
        IamRole.JSON_PROPERTY_LAST_UPDATED,
        IamRole.JSON_PROPERTY_PERMISSIONS,
        IamRole.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class IamRole {


        public static final String JSON_PROPERTY_CREATED = "created";
            private OffsetDateTime created;

        public static final String JSON_PROPERTY_DESCRIPTION = "description";
            private String description;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_LABEL = "label";
            private String label;

        public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
            private OffsetDateTime lastUpdated;

        public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
            private List<RolePermissionType> permissions = new ArrayList<>();

        public static final String JSON_PROPERTY_LINKS = "_links";
            private IamRoleLinks links;

public IamRole() { 
}

    /*
    @JsonCreator
    public IamRole(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated
    ) {
    this();
        this.created = created;
        this.id = id;
        this.lastUpdated = lastUpdated;
    }*/


    /**
        * Timestamp when the role was created
    * @return created
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "Timestamp when the role was created")
      @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }




        public IamRole description(String description) {
        
        this.description = description;
        return this;
        }

    /**
        * Description of the role
    * @return description
    **/
            @javax.annotation.Nonnull
      @ApiModelProperty(required = true, value = "Description of the role")
      @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getDescription() {
        return description;
    }


          @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
            this.description = description;
        }


    /**
        * Unique key for the role
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "Unique key for the role")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




        public IamRole label(String label) {
        
        this.label = label;
        return this;
        }

    /**
        * Unique label for the role
    * @return label
    **/
            @javax.annotation.Nonnull
      @ApiModelProperty(required = true, value = "Unique label for the role")
      @JsonProperty(JSON_PROPERTY_LABEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getLabel() {
        return label;
    }


          @JsonProperty(JSON_PROPERTY_LABEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLabel(String label) {
            this.label = label;
        }


    /**
        * Timestamp when the role was last updated
    * @return lastUpdated
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "Timestamp when the role was last updated")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }




        public IamRole permissions(List<RolePermissionType> permissions) {
        
        this.permissions = permissions;
        return this;
        }

            public IamRole addPermissionsItem(RolePermissionType permissionsItem) {
                this.permissions.add(permissionsItem);
                return this;
            }

    /**
        * Array of permissions that the role will grant. See [Permission Types](https://developer.okta.com/docs/concepts/role-assignment/#permission-types).
    * @return permissions
    **/
            @javax.annotation.Nonnull
      @ApiModelProperty(required = true, value = "Array of permissions that the role will grant. See [Permission Types](https://developer.okta.com/docs/concepts/role-assignment/#permission-types).")
      @JsonProperty(JSON_PROPERTY_PERMISSIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<RolePermissionType> getPermissions() {
        return permissions;
    }


          @JsonProperty(JSON_PROPERTY_PERMISSIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPermissions(List<RolePermissionType> permissions) {
            this.permissions = permissions;
        }


        public IamRole links(IamRoleLinks links) {
        
        this.links = links;
        return this;
        }

    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public IamRoleLinks getLinks() {
        return links;
    }


          @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinks(IamRoleLinks links) {
            this.links = links;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        IamRole iamRole = (IamRole) o;
        return Objects.equals(this.created, iamRole.created) &&
        Objects.equals(this.description, iamRole.description) &&
        Objects.equals(this.id, iamRole.id) &&
        Objects.equals(this.label, iamRole.label) &&
        Objects.equals(this.lastUpdated, iamRole.lastUpdated) &&
        Objects.equals(this.permissions, iamRole.permissions) &&
        Objects.equals(this.links, iamRole.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(created, description, id, label, lastUpdated, permissions, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IamRole {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
