package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets GroupOwnerOriginType
 */
public enum GroupOwnerOriginType {
  
  APPLICATION("APPLICATION"),
  
  OKTA_DIRECTORY("OKTA_DIRECTORY");

  private String value;

  GroupOwnerOriginType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static GroupOwnerOriginType fromValue(String value) {
    for (GroupOwnerOriginType b : GroupOwnerOriginType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

