package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets FactorType
 */
public enum FactorType {
  
  CALL("call"),
  
  EMAIL("email"),
  
  HOTP("hotp"),
  
  PUSH("push"),
  
  QUESTION("question"),
  
  SMS("sms"),
  
  TOKEN("token"),
  
  TOKEN_HARDWARE("token:hardware"),
  
  TOKEN_HOTP("token:hotp"),
  
  TOKEN_SOFTWARE_TOTP("token:software:totp"),
  
  U2F("u2f"),
  
  WEB("web"),
  
  WEBAUTHN("webauthn");

  private String value;

  FactorType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static FactorType fromValue(String value) {
    for (FactorType b : FactorType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

