package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets FactorProvider
 */
public enum FactorProvider {
  
  CUSTOM("CUSTOM"),
  
  DUO("DUO"),
  
  FIDO("FIDO"),
  
  GOOGLE("GOOGLE"),
  
  OKTA("OKTA"),
  
  RSA("RSA"),
  
  SYMANTEC("SYMANTEC"),
  
  YUBICO("YUBICO");

  private String value;

  FactorProvider(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static FactorProvider fromValue(String value) {
    for (FactorProvider b : FactorProvider.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

