package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.time.OffsetDateTime;
    import java.util.HashMap;
    import java.util.Map;
    import org.openapitools.client.model.EventHookChannel;
    import org.openapitools.client.model.EventHookVerificationStatus;
    import org.openapitools.client.model.EventSubscriptions;
    import org.openapitools.client.model.LifecycleStatus;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* EventHook
*/
    @JsonPropertyOrder({
        EventHook.JSON_PROPERTY_CHANNEL,
        EventHook.JSON_PROPERTY_CREATED,
        EventHook.JSON_PROPERTY_CREATED_BY,
        EventHook.JSON_PROPERTY_EVENTS,
        EventHook.JSON_PROPERTY_ID,
        EventHook.JSON_PROPERTY_LAST_UPDATED,
        EventHook.JSON_PROPERTY_NAME,
        EventHook.JSON_PROPERTY_STATUS,
        EventHook.JSON_PROPERTY_VERIFICATION_STATUS,
        EventHook.JSON_PROPERTY_LINKS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class EventHook {


        public static final String JSON_PROPERTY_CHANNEL = "channel";
            private EventHookChannel channel;

        public static final String JSON_PROPERTY_CREATED = "created";
            private OffsetDateTime created;

        public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
            private String createdBy;

        public static final String JSON_PROPERTY_EVENTS = "events";
            private EventSubscriptions events;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
            private OffsetDateTime lastUpdated;

        public static final String JSON_PROPERTY_NAME = "name";
            private String name;

        public static final String JSON_PROPERTY_STATUS = "status";
            private LifecycleStatus status;

        public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
            private EventHookVerificationStatus verificationStatus;

        public static final String JSON_PROPERTY_LINKS = "_links";
            private Map<String, Object> links = null;

public EventHook() { 
}

    /*
    @JsonCreator
    public EventHook(
        @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created, 
        @JsonProperty(JSON_PROPERTY_ID) String id, 
        @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated, 
        @JsonProperty(JSON_PROPERTY_LINKS) Map<String, Object> links
    ) {
    this();
        this.created = created;
        this.id = id;
        this.lastUpdated = lastUpdated;
        this.links = links;
    }*/


        public EventHook channel(EventHookChannel channel) {
        
        this.channel = channel;
        return this;
        }

    /**
        * Get channel
    * @return channel
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EventHookChannel getChannel() {
        return channel;
    }


          @JsonProperty(JSON_PROPERTY_CHANNEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannel(EventHookChannel channel) {
            this.channel = channel;
        }


    /**
        * Get created
    * @return created
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }




        public EventHook createdBy(String createdBy) {
        
        this.createdBy = createdBy;
        return this;
        }

    /**
        * Get createdBy
    * @return createdBy
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CREATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCreatedBy() {
        return createdBy;
    }


          @JsonProperty(JSON_PROPERTY_CREATED_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }


        public EventHook events(EventSubscriptions events) {
        
        this.events = events;
        return this;
        }

    /**
        * Get events
    * @return events
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_EVENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EventSubscriptions getEvents() {
        return events;
    }


          @JsonProperty(JSON_PROPERTY_EVENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvents(EventSubscriptions events) {
            this.events = events;
        }


    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }




    /**
        * Get lastUpdated
    * @return lastUpdated
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }




        public EventHook name(String name) {
        
        this.name = name;
        return this;
        }

    /**
        * Get name
    * @return name
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }


          @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
            this.name = name;
        }


        public EventHook status(LifecycleStatus status) {
        
        this.status = status;
        return this;
        }

    /**
        * Get status
    * @return status
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }


          @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(LifecycleStatus status) {
            this.status = status;
        }


        public EventHook verificationStatus(EventHookVerificationStatus verificationStatus) {
        
        this.verificationStatus = verificationStatus;
        return this;
        }

    /**
        * Get verificationStatus
    * @return verificationStatus
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EventHookVerificationStatus getVerificationStatus() {
        return verificationStatus;
    }


          @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVerificationStatus(EventHookVerificationStatus verificationStatus) {
            this.verificationStatus = verificationStatus;
        }


    /**
        * Get links
    * @return links
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getLinks() {
        return links;
    }




@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        EventHook eventHook = (EventHook) o;
        return Objects.equals(this.channel, eventHook.channel) &&
        Objects.equals(this.created, eventHook.created) &&
        Objects.equals(this.createdBy, eventHook.createdBy) &&
        Objects.equals(this.events, eventHook.events) &&
        Objects.equals(this.id, eventHook.id) &&
        Objects.equals(this.lastUpdated, eventHook.lastUpdated) &&
        Objects.equals(this.name, eventHook.name) &&
        Objects.equals(this.status, eventHook.status) &&
        Objects.equals(this.verificationStatus, eventHook.verificationStatus) &&
        Objects.equals(this.links, eventHook.links);
}

    @Override
    public int hashCode() {
        return Objects.hash(channel, created, createdBy, events, id, lastUpdated, name, status, verificationStatus, links);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EventHook {\n");
        sb.append("    channel: ").append(toIndentedString(channel)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
        sb.append("    events: ").append(toIndentedString(events)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    verificationStatus: ").append(toIndentedString(verificationStatus)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
