package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets ErrorPageTouchPointVariant
 */
public enum ErrorPageTouchPointVariant {
  
  BACKGROUND_IMAGE("BACKGROUND_IMAGE"),
  
  BACKGROUND_SECONDARY_COLOR("BACKGROUND_SECONDARY_COLOR"),
  
  OKTA_DEFAULT("OKTA_DEFAULT");

  private String value;

  ErrorPageTouchPointVariant(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static ErrorPageTouchPointVariant fromValue(String value) {
    for (ErrorPageTouchPointVariant b : ErrorPageTouchPointVariant.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

