package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets EndUserDashboardTouchPointVariant
 */
public enum EndUserDashboardTouchPointVariant {
  
  FULL_THEME("FULL_THEME"),
  
  LOGO_ON_FULL_WHITE_BACKGROUND("LOGO_ON_FULL_WHITE_BACKGROUND"),
  
  OKTA_DEFAULT("OKTA_DEFAULT"),
  
  WHITE_LOGO_BACKGROUND("WHITE_LOGO_BACKGROUND");

  private String value;

  EndUserDashboardTouchPointVariant(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static EndUserDashboardTouchPointVariant fromValue(String value) {
    for (EndUserDashboardTouchPointVariant b : EndUserDashboardTouchPointVariant.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

