package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets EmailTemplateTouchPointVariant
 */
public enum EmailTemplateTouchPointVariant {
  
  FULL_THEME("FULL_THEME"),
  
  OKTA_DEFAULT("OKTA_DEFAULT");

  private String value;

  EmailTemplateTouchPointVariant(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static EmailTemplateTouchPointVariant fromValue(String value) {
    for (EmailTemplateTouchPointVariant b : EmailTemplateTouchPointVariant.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

