package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets DomainValidationStatus
 */
public enum DomainValidationStatus {
  
  COMPLETED("COMPLETED"),
  
  IN_PROGRESS("IN_PROGRESS"),
  
  NOT_STARTED("NOT_STARTED"),
  
  VERIFIED("VERIFIED");

  private String value;

  DomainValidationStatus(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static DomainValidationStatus fromValue(String value) {
    for (DomainValidationStatus b : DomainValidationStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

