package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonInclude;
    import com.fasterxml.jackson.annotation.JsonProperty;
    import com.fasterxml.jackson.annotation.JsonCreator;
    import com.fasterxml.jackson.annotation.JsonTypeName;
    import com.fasterxml.jackson.annotation.JsonValue;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import java.util.ArrayList;
    import java.util.List;
    import org.openapitools.client.model.DNSRecord;
    import org.openapitools.client.model.DomainCertificateMetadata;
    import org.openapitools.client.model.DomainCertificateSourceType;
    import org.openapitools.client.model.DomainValidationStatus;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        /**
* Domain
*/
    @JsonPropertyOrder({
        Domain.JSON_PROPERTY_BRAND_ID,
        Domain.JSON_PROPERTY_CERTIFICATE_SOURCE_TYPE,
        Domain.JSON_PROPERTY_DNS_RECORDS,
        Domain.JSON_PROPERTY_DOMAIN,
        Domain.JSON_PROPERTY_ID,
        Domain.JSON_PROPERTY_PUBLIC_CERTIFICATE,
        Domain.JSON_PROPERTY_VALIDATION_STATUS
    })
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-10-28T09:44:59.080-05:00[America/Chicago]")
public class Domain {


        public static final String JSON_PROPERTY_BRAND_ID = "brandId";
            private String brandId;

        public static final String JSON_PROPERTY_CERTIFICATE_SOURCE_TYPE = "certificateSourceType";
            private DomainCertificateSourceType certificateSourceType;

        public static final String JSON_PROPERTY_DNS_RECORDS = "dnsRecords";
            private List<DNSRecord> dnsRecords = null;

        public static final String JSON_PROPERTY_DOMAIN = "domain";
            private String domain;

        public static final String JSON_PROPERTY_ID = "id";
            private String id;

        public static final String JSON_PROPERTY_PUBLIC_CERTIFICATE = "publicCertificate";
            private DomainCertificateMetadata publicCertificate;

        public static final String JSON_PROPERTY_VALIDATION_STATUS = "validationStatus";
            private DomainValidationStatus validationStatus;

public Domain() { 
}

        public Domain brandId(String brandId) {
        
        this.brandId = brandId;
        return this;
        }

    /**
        * Get brandId
    * @return brandId
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_BRAND_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getBrandId() {
        return brandId;
    }


          @JsonProperty(JSON_PROPERTY_BRAND_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrandId(String brandId) {
            this.brandId = brandId;
        }


        public Domain certificateSourceType(DomainCertificateSourceType certificateSourceType) {
        
        this.certificateSourceType = certificateSourceType;
        return this;
        }

    /**
        * Get certificateSourceType
    * @return certificateSourceType
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_CERTIFICATE_SOURCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DomainCertificateSourceType getCertificateSourceType() {
        return certificateSourceType;
    }


          @JsonProperty(JSON_PROPERTY_CERTIFICATE_SOURCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCertificateSourceType(DomainCertificateSourceType certificateSourceType) {
            this.certificateSourceType = certificateSourceType;
        }


        public Domain dnsRecords(List<DNSRecord> dnsRecords) {
        
        this.dnsRecords = dnsRecords;
        return this;
        }

            public Domain addDnsRecordsItem(DNSRecord dnsRecordsItem) {
                    if (this.dnsRecords == null) {
                    this.dnsRecords = new ArrayList<>();
                    }
                this.dnsRecords.add(dnsRecordsItem);
                return this;
            }

    /**
        * Get dnsRecords
    * @return dnsRecords
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_DNS_RECORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<DNSRecord> getDnsRecords() {
        return dnsRecords;
    }


          @JsonProperty(JSON_PROPERTY_DNS_RECORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDnsRecords(List<DNSRecord> dnsRecords) {
            this.dnsRecords = dnsRecords;
        }


        public Domain domain(String domain) {
        
        this.domain = domain;
        return this;
        }

    /**
        * Get domain
    * @return domain
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDomain() {
        return domain;
    }


          @JsonProperty(JSON_PROPERTY_DOMAIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDomain(String domain) {
            this.domain = domain;
        }


        public Domain id(String id) {
        
        this.id = id;
        return this;
        }

    /**
        * Get id
    * @return id
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }


          @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
            this.id = id;
        }


        public Domain publicCertificate(DomainCertificateMetadata publicCertificate) {
        
        this.publicCertificate = publicCertificate;
        return this;
        }

    /**
        * Get publicCertificate
    * @return publicCertificate
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_PUBLIC_CERTIFICATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DomainCertificateMetadata getPublicCertificate() {
        return publicCertificate;
    }


          @JsonProperty(JSON_PROPERTY_PUBLIC_CERTIFICATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPublicCertificate(DomainCertificateMetadata publicCertificate) {
            this.publicCertificate = publicCertificate;
        }


        public Domain validationStatus(DomainValidationStatus validationStatus) {
        
        this.validationStatus = validationStatus;
        return this;
        }

    /**
        * Get validationStatus
    * @return validationStatus
    **/
        @javax.annotation.Nullable
      @ApiModelProperty(value = "")
      @JsonProperty(JSON_PROPERTY_VALIDATION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DomainValidationStatus getValidationStatus() {
        return validationStatus;
    }


          @JsonProperty(JSON_PROPERTY_VALIDATION_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValidationStatus(DomainValidationStatus validationStatus) {
            this.validationStatus = validationStatus;
        }


@Override
public boolean equals(Object o) {
    if (this == o) {
    return true;
    }
    if (o == null || getClass() != o.getClass()) {
    return false;
    }
        Domain domain = (Domain) o;
        return Objects.equals(this.brandId, domain.brandId) &&
        Objects.equals(this.certificateSourceType, domain.certificateSourceType) &&
        Objects.equals(this.dnsRecords, domain.dnsRecords) &&
        Objects.equals(this.domain, domain.domain) &&
        Objects.equals(this.id, domain.id) &&
        Objects.equals(this.publicCertificate, domain.publicCertificate) &&
        Objects.equals(this.validationStatus, domain.validationStatus);
}

    @Override
    public int hashCode() {
        return Objects.hash(brandId, certificateSourceType, dnsRecords, domain, id, publicCertificate, validationStatus);
    }

    @Override
    public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Domain {\n");
        sb.append("    brandId: ").append(toIndentedString(brandId)).append("\n");
        sb.append("    certificateSourceType: ").append(toIndentedString(certificateSourceType)).append("\n");
        sb.append("    dnsRecords: ").append(toIndentedString(dnsRecords)).append("\n");
        sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    publicCertificate: ").append(toIndentedString(publicCertificate)).append("\n");
        sb.append("    validationStatus: ").append(toIndentedString(validationStatus)).append("\n");
    sb.append("}");
    return sb.toString();
    }

    /**
    * Convert the given object to string with each line indented by 4 spaces
    * (except the first line).
    */
    private String toIndentedString(Object o) {
    if (o == null) {
    return "null";
    }
    return o.toString().replace("\n", "\n    ");
    }


    }
