package org.openapitools.client.model;

import java.util.Objects;
import java.util.Arrays;
    import com.fasterxml.jackson.annotation.JsonPropertyOrder;
    import com.fasterxml.jackson.annotation.JsonTypeName;

        import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Gets or Sets DiskEncryptionType
 */
public enum DiskEncryptionType {
  
  ALL_INTERNAL_VOLUMES("ALL_INTERNAL_VOLUMES"),
  
  FULL("FULL"),
  
  USER("USER");

  private String value;

  DiskEncryptionType(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static DiskEncryptionType fromValue(String value) {
    for (DiskEncryptionType b : DiskEncryptionType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }
}

